package cn.gtmap.landtax.model.dictionary;

import org.apache.commons.lang.StringUtils;

/**
 * 是否税源核查
 *
 * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
 * @version 1.0, 2014/6/26
 */
public enum Isxf {
    YXF("1", "已下发"),
    WXF("2", "未下发"),
    ZDLR("3","宗地录入");
    private String dm;
    private String mc;

    private Isxf(String dm, String mc) {
        this.dm = dm;
        this.mc = mc;
    }
    public String getMc(){
        return this.mc;
    }

    public String getDm(){
        return this.dm;
    }
    @Override
    public String toString() {
        return dm;
    }

    public static String getMcByDm(String dm){
        if(StringUtils.isNotBlank(dm)){
            Isxf[] Ishcs = Isxf.values();
            for(int i=0;i<Ishcs.length;i++){
                if(Ishcs[i].getDm().equals(StringUtils.trim(dm))){
                    return Ishcs[i].getMc();
                }
            }
        }
        return null;
    }
}
