package cn.gtmap.landtax.model.dictionary;

import org.apache.commons.lang.StringUtils;

/**
 * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
 * @version 1.0, 2014/7/7
 */
public enum Hylx {
    JZY("E","建筑业"),
    FDCY("K","房地产业"),
    ZLSWFWY("L","租赁和商务服务业"),
    NLMY("A", "农、林、牧、渔业"),
    CKY("B","采矿业"),
    ZZY("C","制造业"),
    DRRSG("D","电力、热力、燃气及水生产和供应业"),
    PFHLSY("F","批发和零售业"),
    JTCCYZ("G","交通运输、仓储和邮政业"),
    ZUCY("H","住宿和餐饮业"),
    XXRJFW("I","信息传输、软件和信息技术服务业"),
    JRY("J","金融业"),
    KXYJJSFWY("M","科学研究和技术服务业"),
    SLHJGGSSGLY("N","水利、环境和公共设施管理业"),
    JMXLQT("O","居民服务、修理和其他服务业"),
    JY("P","教育"),
    WSSHGZ("Q","卫生和社会工作"),
    WHTYYL("R","文化、体育和娱乐业"),
    GGGLSHBZ("S","公共管理、社会保障和社会组织"),
    GJZZ("T","国际组织");

    private String dm;
    private String mc;

    private Hylx(String dm, String mc) {
        this.dm = dm;
        this.mc = mc;
    }

    @Override
    public String toString() {
        return dm;
    }

    public String getMc(){
        return this.mc;
    }

    public String getDm(){
        return this.dm;
    }

    public static String getMcByDm(String dm){
        if(StringUtils.isNotBlank(dm)){
            Hylx[] Hylxs = Hylx.values();
            for(int i=0;i<Hylxs.length;i++){
                if(Hylxs[i].getDm().equals(StringUtils.trim(dm))){
                    return Hylxs[i].getMc();
                }
            }
        }
        return null;
    }
}
