package cn.gtmap.landtax.model.dictionary;/**
 * Created by janeshen on 2014/8/19.
 */

import org.apache.commons.lang.StringUtils;

/**
 * .
 * <p/>
 *
 * @author shenjian
 * @version V1.0, 2014/8/19
 */

public enum Hcxmlx {
    ZDHC("1", "国土宗地信息核查"),
    TDSYHC("2", "土地税源信息核查"),
    FCSYHC("3", "房产税源信息核查"),
    SYZDYDQC("4", "税源宗地数据疑点清册"),
    TDSBJSYDQC("5","土地税申报缴税信息疑点清册"),
    FCSBJSYDQC("6","房产税申报缴税信息疑点清册"),
    TDZSYDQC("7","土地税征收信息疑点清册"),
    FCZSYDQC("8","房产税征收信息疑点清册"),
    GDHC("9","供地信息核查"),
    BPHC("10","报批信息核查"),
    SYBL("11", "税源补录"),
    GDBL("12", "供地税源补录"),
    BPBL("13", "报批税源补录"),
    TDMSRD("14", "土地免税认定"),
    SYSC("15", "税源信息注销"),
    SYSJ("16","税源信息编辑申请"),
    GDZYSSC("17","耕地占用税税源信息注销申请"),
    GDZYSSJ("18","耕地占用税税源信息编辑申请"),
	BDCHC("20","不动产登记核查"),
    MJYD("11","面积疑点核查");
    private String dm;
    private String mc;

    private Hcxmlx(String dm, String mc) {
        this.dm = dm;
        this.mc = mc;
    }

    @Override
    public String toString() {
        return dm;
    }

    public String getMc(){
        return this.mc;
    }
    
    public String getDm(){
        return this.dm;
    }

    public static String getMcByDm(String dm){
        if(StringUtils.isNotBlank(dm)){
            Hcxmlx[] hcxmlxs = Hcxmlx.values();
            for(int i=0;i<hcxmlxs.length;i++){
                if(hcxmlxs[i].getDm().equals(StringUtils.trim(dm))){
                    return hcxmlxs[i].getMc();
                }
            }
        }
        return null;
    }
}
