package cn.gtmap.landtax.model.dictionary;

import org.apache.commons.lang.StringUtils;

/**
 * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
 * @version 1.0, 2014/6/26
 */
public enum Fwxz {
    GY("10", "工业"),
    SYJBG("20", "商业及办公"),
    ZF("30", "住房"),
    QT("40", "其他");
    private String dm;
    private String mc;

    private Fwxz(String dm, String mc) {
        this.dm = dm;
        this.mc = mc;
    }

    @Override
    public String toString() {
        return dm;
    }

    public String getMc(){
        return this.mc;
    }

    public String getDm(){
        return this.dm;
    }

    public static String getMcByDm(String dm){
        if(StringUtils.isNotBlank(dm)){
            Fwxz[] Fwxzs = Fwxz.values();
            for(int i=0;i<Fwxzs.length;i++){
                if(Fwxzs[i].getDm().equals(StringUtils.trim(dm))){
                    return Fwxzs[i].getMc();
                }
            }
        }
        return null;
    }
}
