package cn.gtmap.landtax.model.dictionary;

import org.apache.commons.lang.StringUtils;

/**
 * 数据操作类型
 * @author
 * @version 1.0, 2016/10/14
 */
public enum ConfirmHc {
    YES("01", "是"),
    NO("02", "否");
    private String dm;
    private String mc;

    private ConfirmHc(String dm, String mc) {
        this.dm = dm;
        this.mc = mc;
    }

    @Override
    public String toString() {
        return dm;
    }

    public String getMc(){
        return this.mc;
    }

    public String getDm(){
        return this.dm;
    }

    public static String getMcByDm(String dm){
        if(StringUtils.isNotBlank(dm)){
            ConfirmHc[] Byzyys = ConfirmHc.values();
            for(int i=0;i<Byzyys.length;i++){
                if(Byzyys[i].getDm().equals(StringUtils.trim(dm))){
                    return Byzyys[i].getMc();
                }
            }
        }
        return null;
    }
}
