
package cn.gtmap.landtax.ex;

import cn.gtmap.landtax.support.message.MessageUtils;

/**
 * .
 * <p/>
 * 一般异常类
 *
 * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
 * @version 1.0, 2014/6/23
 */
public class TaxException extends RuntimeException {

    private ExceptionCode exCode;

    private Object args[];

    public TaxException() {
        super();
    }

    public TaxException(ExceptionCode exCode) {
        super();
        this.exCode = exCode;
    }

    public TaxException(String message) {
        super(message);
    }

    public TaxException(ExceptionCode exCode, String message, Object... args) {
        super(message);
        this.exCode = exCode;
        this.args = args;
    }

    public TaxException(String message, Throwable cause) {
        super(message, cause);
    }

    @Override
    public String getMessage() {
        return MessageUtils.getExceptionMsg(this.exCode, this.args);
    }

    @Override
    public String toString() {
        return getMessage();
    }
}
