package cn.gtmap.landtax.entity;

/**
 * Created by janeshen on 2014/8/19.
 */

import org.hibernate.annotations.*;

import javax.persistence.*;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.util.Set;

/**
 * .
 * <p/>
 *  核查项目与工作流项目的关联
 * @author shenjian
 * @version V1.0, 2014/8/19
 */
@Entity
@org.hibernate.annotations.Cache(usage = CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
@Table(name = "SW_HC_XM_RW_REL")
public class SwHcXmRwRel {
    @Id
    @Column
    private String shxrId;

    @ManyToOne(fetch = FetchType.LAZY)
    @JoinColumn(name = "HCXM_ID")
    private SwHcXm swHcXm;

    /**
     * 任务Id即对应的工作流项目Id
     */
    @Column(name="RW_ID")
    private String rwId;

    /**
     * 比对Id，可以是国土宗地比对Id，也可以是税源比对Id
     */
    @Column
    private String bdId;

    /**
     * 办理状态
     * 0：正在办理，1：已办理
     */
    @Column
    private String blzt;
    /**
     * 核查的税源信息存储在税源表中，用syzt为3来表示临时税源信息
     */
//    @OneToOne(fetch = FetchType.LAZY)
//    @JoinColumn(name = "SY_ID")
//    private SwDjSy swDjSy;

    @OneToMany(mappedBy = "swHcXmRwRel",fetch = FetchType.LAZY,cascade = CascadeType.REFRESH)
    private Set<SwDjSy> swDjSySet;

    public String getShxrId() {
        return shxrId;
    }

    public void setShxrId(String shxrId) {
        this.shxrId = shxrId;
    }

    public SwHcXm getSwHcXm() {
        return swHcXm;
    }

    public void setSwHcXm(SwHcXm swHcXm) {
        this.swHcXm = swHcXm;
    }

    public String getRwId() {
        return rwId;
    }

    public void setRwId(String rwId) {
        this.rwId = rwId;
    }

    public String getBdId() {
        return bdId;
    }

    public void setBdId(String bdId) {
        this.bdId = bdId;
    }

    public Set<SwDjSy> getSwDjSySet() {
        return swDjSySet;
    }

    public void setSwDjSySet(Set<SwDjSy> swDjSySet) {
        this.swDjSySet = swDjSySet;
    }

    public String getBlzt() {
        return blzt;
    }

    public void setBlzt(String blzt) {
        this.blzt = blzt;
    }
}
