package cn.gtmap.landtax.entity;

import com.alibaba.fastjson.annotation.JSONField;
import org.hibernate.annotations.CacheConcurrencyStrategy;

import javax.persistence.*;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 项目信息
 */
@Entity
@org.hibernate.annotations.Cache(usage = CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
@Table(name = "SW_DJ_XMXX")
public class SwDjXmxx {
    @Id
    @Column
    private String xmId;

    @Column
    private String xmmc;

    @Column
    private BigDecimal gdmj;

    @Column
    private String qdfs;

    @Column
    private BigDecimal qdjg;

    @Column
    private Date gdsj;

    @Column(name="tdyt")
    private String xmTdyt;
    @Column(name="yddw")
    private String xmYddw;
    @Column(name="xzqdm")
    private String xmXzqdm;
    @Column(name="tdzl")
    private String xmTdzl;

    @JSONField(serialize = false)
    @ManyToOne(fetch = FetchType.LAZY)
    @JoinColumn(name = "djh")
    private Zd zd;


    public String getXmId() {
        return xmId;
    }

    public void setXmId(String xmId) {
        this.xmId = xmId;
    }

    public String getXmmc() {
        return xmmc;
    }

    public void setXmmc(String xmmc) {
        this.xmmc = xmmc;
    }

    public BigDecimal getGdmj() {
        return gdmj;
    }

    public void setGdmj(BigDecimal gdmj) {
        this.gdmj = gdmj;
    }

    public String getQdfs() {
        return qdfs;
    }

    public void setQdfs(String qdfs) {
        this.qdfs = qdfs;
    }

    public BigDecimal getQdjg() {
        return qdjg;
    }

    public void setQdjg(BigDecimal qdjg) {
        this.qdjg = qdjg;
    }

    public Date getGdsj() {
        return gdsj;
    }

    public void setGdsj(Date gdsj) {
        this.gdsj = gdsj;
    }

    public String getXmTdyt() {
        return xmTdyt;
    }

    public void setXmTdyt(String xmTdyt) {
        this.xmTdyt = xmTdyt;
    }

    public String getXmYddw() {
        return xmYddw;
    }

    public void setXmYddw(String xmYddw) {
        this.xmYddw = xmYddw;
    }

    public String getXmXzqdm() {
        return xmXzqdm;
    }

    public void setXmXzqdm(String xmXzqdm) {
        this.xmXzqdm = xmXzqdm;
    }

    public String getXmTdzl() {
        return xmTdzl;
    }

    public void setXmTdzl(String xmTdzl) {
        this.xmTdzl = xmTdzl;
    }

    public Zd getZd() {
        return zd;
    }

    public void setZd(Zd zd) {
        this.zd = zd;
    }
}
