package cn.gtmap.landtax.entity;

import com.alibaba.fastjson.annotation.JSONField;
import org.hibernate.annotations.*;

import javax.persistence.*;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 税务登记土地未比对表
 *
 * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
 * @version 1.0, 2014/6/25
 */
@Entity
@org.hibernate.annotations.Cache(usage = CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
@Table(name = "SW_DJ_TD_WBD")
public class SwDjTdWbd extends SwDjTdBase implements Serializable {
    @Id
    @Column
    private String tdId;
//    @Column
//    private String djh;
    @Column
    private String dbh;
    @Column
    private String nsrmc;
    @Column
    private String glbm;
    @Column
    private String nsrsbh;
    @Column
    private String tdsyqlx;



    @ManyToOne(fetch = FetchType.LAZY)
    @JoinColumn(name = "JBB_ID")
    private SwDjJbbWbd swDjJbbWbd;
    @JSONField(serialize = false)
    @ManyToOne(fetch = FetchType.LAZY,cascade = CascadeType.REFRESH)
    @JoinColumn(name="DJH")
    private Zd zd;
    public String getNsrsbh() {
        return nsrsbh;
    }

    public void setNsrsbh(String nsrsbh) {
        this.nsrsbh = nsrsbh;
    }


    public String getTdId() {
        return tdId;
    }

    public void setTdId(String tdId) {
        this.tdId = tdId;
    }

    public SwDjJbbWbd getSwDjJbbWbd() {
        return swDjJbbWbd;
    }

    public void setSwDjJbbWbd(SwDjJbbWbd swDjJbbWbd) {
        this.swDjJbbWbd = swDjJbbWbd;
    }


//    public String getDjh() {
//        return djh;
//    }
//
//    public void setDjh(String djh) {
//        this.djh = djh;
//    }
    public String getTdsyqlx() {
        return tdsyqlx;
    }

    public void setTds(String tdsyqlx) {
        this.tdsyqlx = tdsyqlx;
    }

    public String getDbh() {
        return dbh;
    }

    public void setDbh(String dbh) {
        this.dbh = dbh;
    }

    public String getNsrmc() {
        return nsrmc;
    }

    public void setNsrmc(String nsrmc) {
        this.nsrmc = nsrmc;
    }

    public String getGlbm() {
        return glbm;
    }

    public void setGlbm(String glbm) {
        this.glbm = glbm;
    }

    public Zd getZd() {
        return zd;
    }

    public void setZd(Zd zd) {
        this.zd = zd;
    }

}
