package cn.gtmap.landtax.entity;

import com.alibaba.fastjson.annotation.JSONField;
import org.hibernate.annotations.*;

import javax.persistence.*;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 税务土地登记表
 *
 * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
 * @version 1.0, 2014/6/25
 */
@Entity
@org.hibernate.annotations.Cache(usage = CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
@Table(name = "SW_DJ_TD")
public class SwDjTd extends SwDjTdBase implements Serializable {
    @Id
    @Column
    private String tdId;
    @Column
    private Date updateDate;

    @Column
    private String tdsyqlx;
    @Column
    private Date tdMssjBegin;
    @Column
    private Date tdMssjEnd;
    @Column
    private String tdMsyy;
    @Column
    private String tdqdfsDm;
    @Column
    private String tdsyytDm;
    @Column
    private BigDecimal dj;
    @Column
    private BigDecimal qdsyqzfje;
    @Column
    private BigDecimal tdkfcb;
    @Column
    private Date csqdsj;
    @Column
    private Date syqzzsj;
    @Column
    private String tdjmxzdm;

    @ManyToOne(fetch = FetchType.LAZY,cascade = CascadeType.REFRESH)
    @JoinColumn(name = "JBB_ID")
    private SwDjJbb swDjJbb;

    @JSONField(serialize = false)
    @OneToOne(fetch = FetchType.LAZY)
    @JoinColumn(name = "SY_ID")
    private SwDjSy swDjSy;

    public String getTdId() {
        return tdId;
    }

    public void setTdId(String tdId) {
        this.tdId = tdId;
    }

    public SwDjJbb getSwDjJbb() {
        return swDjJbb;
    }

    public void setSwDjJbb(SwDjJbb swDjJbb) {
        this.swDjJbb = swDjJbb;
    }

    public SwDjSy getSwDjSy() {
        return swDjSy;
    }

    public void setSwDjSy(SwDjSy swDjSy) {
        this.swDjSy = swDjSy;
    }

    public Date getUpdateDate() {
        return updateDate;
    }

    public void setUpdateDate(Date updateDate) {
        this.updateDate = updateDate;
    }

    public String getTdsyqlx() {
        return tdsyqlx;
    }

    public void setTdsyqlx(String tdsyqlx) {
        this.tdsyqlx = tdsyqlx;
    }

    public Date getTdMssjBegin() {
        return tdMssjBegin;
    }

    public void setTdMssjBegin(Date tdMssjBegin) {
        this.tdMssjBegin = tdMssjBegin;
    }

    public Date getTdMssjEnd() {
        return tdMssjEnd;
    }

    public void setTdMssjEnd(Date tdMssjEnd) {
        this.tdMssjEnd = tdMssjEnd;
    }

    public String getTdMsyy() {
        return tdMsyy;
    }

    public void setTdMsyy(String tdMsyy) {
        this.tdMsyy = tdMsyy;
    }

    public String getTdqdfsDm() {
        return tdqdfsDm;
    }

    public void setTdqdfsDm(String tdqdfsDm) {
        this.tdqdfsDm = tdqdfsDm;
    }

    public String getTdsyytDm() {
        return tdsyytDm;
    }

    public void setTdsyytDm(String tdsyytDm) {
        this.tdsyytDm = tdsyytDm;
    }

    public BigDecimal getDj() {
        return dj;
    }

    public void setDj(BigDecimal dj) {
        this.dj = dj;
    }

    public BigDecimal getQdsyqzfje() {
        return qdsyqzfje;
    }

    public void setQdsyqzfje(BigDecimal qdsyqzfje) {
        this.qdsyqzfje = qdsyqzfje;
    }

    public BigDecimal getTdkfcb() {
        return tdkfcb;
    }

    public void setTdkfcb(BigDecimal tdkfcb) {
        this.tdkfcb = tdkfcb;
    }

    public Date getCsqdsj() {
        return csqdsj;
    }

    public void setCsqdsj(Date csqdsj) {
        this.csqdsj = csqdsj;
    }

    public Date getSyqzzsj() {
        return syqzzsj;
    }

    public void setSyqzzsj(Date syqzzsj) {
        this.syqzzsj = syqzzsj;
    }

    public String getTdjmxzdm() {
        return tdjmxzdm;
    }

    public void setTdjmxzdm(String tdjmxzdm) {
        this.tdjmxzdm = tdjmxzdm;
    }
}
