package cn.gtmap.landtax.entity;

import com.alibaba.fastjson.annotation.JSONField;
import org.hibernate.annotations.*;

import javax.persistence.*;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.OrderBy;
import javax.persistence.Table;
import java.math.BigDecimal;
import java.util.Set;

/**
 * 税源主表
 * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
 * @version 1.0, 2014/7/11
 */
@Entity
@org.hibernate.annotations.Cache(usage = CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
@Table(name = "SW_DJ_SY")
public class SwDjSy {
    @Id
    @Column
    private String syId;

    @Column
    private String dbh;//即土地使用号

    @Column
    private String syzt;//税源状态

    @Column
    private String bz;

    @Column(name="sjly")
    private String sysjly;

    @Column
    private String ishc;//是否进行了税源核查(0:为何查。1：已核查)

    @OneToOne(mappedBy = "swDjSy",fetch = FetchType.LAZY,cascade = CascadeType.ALL)
    private SwDjTd swDjTd;

    @OneToOne(mappedBy = "swDjSy",fetch = FetchType.LAZY,cascade = CascadeType.ALL)
    private SwDjFc swDjFc;

    @OneToOne(mappedBy = "swDjSy",fetch = FetchType.LAZY,cascade = CascadeType.ALL)
    private SwDjGdzys swDjGdzys;

    @OneToOne(mappedBy = "swDjSy",fetch = FetchType.LAZY,cascade = CascadeType.ALL)
    private SwDjQs swDjQs;

    @JSONField(serialize = false)
    @ManyToOne(fetch = FetchType.LAZY,cascade = CascadeType.REFRESH)
    @JoinColumn(name="DJH")
    private Zd zd;
    @JSONField(serialize = false)
    @ManyToOne(fetch = FetchType.LAZY,cascade = CascadeType.REFRESH)
    @JoinColumn(name="GD_ID")
    private SwDjXmxx swDjXmxx;
    @JSONField(serialize = false)
    @ManyToOne(fetch = FetchType.LAZY,cascade = CascadeType.REFRESH)
    @JoinColumn(name="BP_ID")
    private SwDjPcxx swDjPcxx;
    @JSONField(serialize = false)
    @OneToMany(mappedBy = "swDjSy",fetch = FetchType.LAZY,cascade = CascadeType.REFRESH)
    @OrderBy("xgrq asc")
    private Set<SwDjSyHis> swDjSyHisSet;
    @JSONField(serialize = false)
    @ManyToOne(fetch = FetchType.LAZY,cascade = CascadeType.REFRESH)
    @JoinColumn(name="SHXR_ID")
    private SwHcXmRwRel swHcXmRwRel;

    @Column
    private BigDecimal gzsynse;//耕占税应纳税额
    @Column
    private BigDecimal gzsxbje;//耕占税需补缴额
    @Column
    private BigDecimal qsynse;//契税应纳税额
    @Column
    private BigDecimal qsbjje;//契税补缴金额

    public String getSyId() {
        return syId;
    }

    public void setSyId(String syId) {
        this.syId = syId;
    }

    public String getDbh() {
        return dbh;
    }

    public void setDbh(String dbh) {
        this.dbh = dbh;
    }

    public SwDjTd getSwDjTd() {
        return swDjTd;
    }

    public void setSwDjTd(SwDjTd swDjTd) {
        this.swDjTd = swDjTd;
    }

    public SwDjFc getSwDjFc() {
        return swDjFc;
    }

    public void setSwDjFc(SwDjFc swDjFc) {
        this.swDjFc = swDjFc;
    }

    public Zd getZd() {
        return zd;
    }

    public void setZd(Zd zd) {
        this.zd = zd;
    }

    public SwDjXmxx getSwDjXmxx() {
        return swDjXmxx;
    }

    public void setSwDjXmxx(SwDjXmxx swDjXmxx) {
        this.swDjXmxx = swDjXmxx;
    }

    public SwDjPcxx getSwDjPcxx() {
        return swDjPcxx;
    }

    public void setSwDjPcxx(SwDjPcxx swDjPcxx) {
        this.swDjPcxx = swDjPcxx;
    }

    public Set<SwDjSyHis> getSwDjSyHisSet() {
        return swDjSyHisSet;
    }

    public void setSwDjSyHisSet(Set<SwDjSyHis> swDjSyHisSet) {

        this.swDjSyHisSet = swDjSyHisSet;
    }

    public String getSyzt() {
        return syzt;
    }

    public void setSyzt(String syzt) {
        this.syzt = syzt;
    }

    public String getBz() {
        return bz;
    }

    public void setBz(String bz) {
        this.bz = bz;
    }

    public String getSysjly() {
        return sysjly;
    }

    public void setSysjly(String sysjly) {
        this.sysjly = sysjly;
    }

    public SwHcXmRwRel getSwHcXmRwRel() {
        return swHcXmRwRel;
    }

    public void setSwHcXmRwRel(SwHcXmRwRel swHcXmRwRel) {
        this.swHcXmRwRel = swHcXmRwRel;
    }

    public String getIshc() {
        return ishc;
    }

    public void setIshc(String ishc) {
        this.ishc = ishc;
    }



    public BigDecimal getGzsynse() {
        return gzsynse;
    }

    public void setGzsynse(BigDecimal gzsynse) {
        this.gzsynse = gzsynse;
    }

    public BigDecimal getGzsxbje() {
        return gzsxbje;
    }

    public void setGzsxbje(BigDecimal gzsxbje) {
        this.gzsxbje = gzsxbje;
    }

    public BigDecimal getQsynse() {
        return qsynse;
    }

    public void setQsynse(BigDecimal qsynse) {
        this.qsynse = qsynse;
    }

    public BigDecimal getQsbjje() {
        return qsbjje;
    }

    public void setQsbjje(BigDecimal qsbjje) {
        this.qsbjje = qsbjje;
    }

    public SwDjGdzys getSwDjGdzys() {
        return swDjGdzys;
    }

    public void setSwDjGdzys(SwDjGdzys swDjGdzys) {
        this.swDjGdzys = swDjGdzys;
    }

    public SwDjQs getSwDjQs() {
        return swDjQs;
    }

    public void setSwDjQs(SwDjQs swDjQs) {
        this.swDjQs = swDjQs;
    }
}
