package cn.gtmap.landtax.entity;

import com.alibaba.fastjson.annotation.JSONField;
import org.hibernate.annotations.CacheConcurrencyStrategy;

import javax.persistence.*;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 项目信息
 */
@Entity
@org.hibernate.annotations.Cache(usage = CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
@Table(name = "SW_DJ_QS")
public class SwDjQs {

    @Id
    @Column
    private String qsId;

    @Column(name="szly")
    private String qsSzly;

    @Column(name="ynse")
    private BigDecimal qsYnse;

    @Column(name="yjne")
    private BigDecimal qsYjne;

    @Column(name="jmxz")
    private String qsJmxz;

    @Column(name="jmse")
    private BigDecimal qsJmse;

    @Column(name="jspz")
    private String qsJspz;

    @Column(name="xbjse")
    private BigDecimal qsXbjse;

    @Column(name="bz")
    private String qsBz;

    @Column(name="lrrq")
    private Date qsLrrq;

    @Column(name="hclx")
    private String qsHclx;

    @Column(name="qs_zt")
    private String qsZt;

    @Column(name="ZDSYBZ")
    private String zdsybz;

    public String getZdsybz() {
        return zdsybz;
    }

    public void setZdsybz(String zdsybz) {
        this.zdsybz = zdsybz;
    }


    @JSONField(serialize = false)
    @OneToOne(fetch = FetchType.LAZY)
    @JoinColumn(name = "SY_ID")
    private SwDjSy swDjSy;

    @ManyToOne(fetch = FetchType.LAZY)
    @JoinColumn(name = "JBB_ID")
    private SwDjJbb swDjJbb;

    public String getQsId() {
        return qsId;
    }

    public void setQsId(String qsId) {
        this.qsId = qsId;
    }

    public String getQsSzly() {
        return qsSzly;
    }

    public void setQsSzly(String qsSzly) {
        this.qsSzly = qsSzly;
    }

    public BigDecimal getQsYnse() {
        return qsYnse;
    }

    public void setQsYnse(BigDecimal qsYnse) {
        this.qsYnse = qsYnse;
    }

    public BigDecimal getQsYjne() {
        return qsYjne;
    }

    public void setQsYjne(BigDecimal qsYjne) {
        this.qsYjne = qsYjne;
    }

    public String getQsJmxz() {
        return qsJmxz;
    }

    public void setQsJmxz(String qsJmxz) {
        this.qsJmxz = qsJmxz;
    }

    public BigDecimal getQsJmse() {
        return qsJmse;
    }

    public void setQsJmse(BigDecimal qsJmse) {
        this.qsJmse = qsJmse;
    }

    public String getQsJspz() {
        return qsJspz;
    }

    public void setQsJspz(String qsJspz) {
        this.qsJspz = qsJspz;
    }

    public BigDecimal getQsXbjse() {
        return qsXbjse;
    }

    public void setQsXbjse(BigDecimal qsXbjse) {
        this.qsXbjse = qsXbjse;
    }

    public String getQsBz() {
        return qsBz;
    }

    public void setQsBz(String qsBz) {
        this.qsBz = qsBz;
    }

    public Date getQsLrrq() {
        return qsLrrq;
    }

    public void setQsLrrq(Date qsLrrq) {
        this.qsLrrq = qsLrrq;
    }

    public SwDjSy getSwDjSy() {
        return swDjSy;
    }

    public void setSwDjSy(SwDjSy swDjSy) {
        this.swDjSy = swDjSy;
    }

    public SwDjJbb getSwDjJbb() {
        return swDjJbb;
    }

    public void setSwDjJbb(SwDjJbb swDjJbb) {
        this.swDjJbb = swDjJbb;
    }

    public String getQsHclx() {
        return qsHclx;
    }

    public void setQsHclx(String qsHclx) {
        this.qsHclx = qsHclx;
    }

    public String getQsZt() {
        return qsZt;
    }

    public void setQsZt(String qsZt) {
        this.qsZt = qsZt;
    }
}
