package cn.gtmap.landtax.entity;

import com.alibaba.fastjson.annotation.JSONField;
import org.hibernate.annotations.*;

import javax.persistence.*;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;
import java.util.Set;

/**
 * 税务基本表
 *
 * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
 * @version 1.0, 2014/6/25
 */
@Entity
@org.hibernate.annotations.Cache(usage = CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
@Table(name = "SW_DJ_JBB")
public class SwDjJbb extends SwDjJbbBase implements Serializable {
    @Id
    @Column
    private String jbbId;

    @JSONField(serialize = false)
    @OneToMany(mappedBy = "swDjJbb", cascade = CascadeType.REFRESH,fetch = FetchType.LAZY)
    Set<SwDjFc> swDjFcSet;

    @JSONField(serialize = false)
    @OneToMany(mappedBy = "swDjJbb", cascade = CascadeType.REFRESH,fetch = FetchType.LAZY)
    Set<SwDjTd> swDjTdSet;

    @JSONField(serialize = false)
    @OneToMany(mappedBy = "swDjJbb", cascade = CascadeType.REFRESH,fetch = FetchType.LAZY)
    Set<SwDjQs> swDjQsSet;

    @JSONField(serialize = false)
    @OneToMany(mappedBy = "swDjJbb", cascade = CascadeType.REFRESH,fetch = FetchType.LAZY)
    Set<SwDjGdzys> swDjGdzysSet;



    public String getJbbId() {
        return jbbId;
    }

    public void setJbbId(String jbbId) {
        this.jbbId = jbbId;
    }

    public Set<SwDjTd> getSwDjTdSet() {
        return swDjTdSet;
    }

    public void setSwDjTdSet(Set<SwDjTd> swDjTdSet) {
        this.swDjTdSet = swDjTdSet;
    }

    public Set<SwDjFc> getSwDjFcSet() {
        return swDjFcSet;
    }

    public void setSwDjFcSet(Set<SwDjFc> swDjFcSet) {
        this.swDjFcSet = swDjFcSet;
    }

    public Set<SwDjQs> getSwDjQsSet() {
        return swDjQsSet;
    }

    public void setSwDjQsSet(Set<SwDjQs> swDjQsSet) {
        this.swDjQsSet = swDjQsSet;
    }

    public Set<SwDjGdzys> getSwDjGdzysSet() {
        return swDjGdzysSet;
    }

    public void setSwDjGdzysSet(Set<SwDjGdzys> swDjGdzysSet) {
        this.swDjGdzysSet = swDjGdzysSet;
    }
}
