package cn.gtmap.landtax.entity;

import com.alibaba.fastjson.annotation.JSONField;
import org.hibernate.annotations.*;

import javax.persistence.*;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 税务房产登记表
 *
 * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
 * @version 1.0, 2014/6/25
 */
@Entity
@org.hibernate.annotations.Cache(usage = CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
@Table(name = "SW_DJ_FC")
public class SwDjFc extends SwDjFcBase implements Serializable {

    @Id
    @Column
    private String fcId;
    @Column
    private Date updateDate;
    @Column
    private Date fcMssjBegin;
    @Column
    private Date fcMssjEnd;
    @Column
    private String fcMsyy;
    @Column
    private Date htzlqBegin;
    @Column
    private Date htzlqEnd;

    @ManyToOne(fetch = FetchType.LAZY)
    @JoinColumn(name = "JBB_ID")
    private SwDjJbb swDjJbb;

    @JSONField(serialize = false)
    @OneToOne(fetch = FetchType.LAZY)
    @JoinColumn(name = "SY_ID")
    private SwDjSy swDjSy;
    @Column
    private BigDecimal czfcyz;
    @Column
    private BigDecimal jsbl;
    @Column
    private String fcjmxzdm;
    @Column
    private String fczlXian;
    @Column
    private String fczlZhen;
    @Column
    private String fczlLu;
    @Column
    private String fczlHao;
    @Column
    private String fczlDong;
    @Column
    private String fczlDy;
    @Column
    private String fczlLou;
    @Column
    private String fczlShi;

    public Date getHtzlqBegin() {
        return htzlqBegin;
    }

    public void setHtzlqBegin(Date htzlqBegin) {
        this.htzlqBegin = htzlqBegin;
    }

    public Date getHtzlqEnd() {
        return htzlqEnd;
    }

    public void setHtzlqEnd(Date htzlqEnd) {
        this.htzlqEnd = htzlqEnd;
    }

    public SwDjJbb getSwDjJbb() {
        return swDjJbb;
    }

    public void setSwDjJbb(SwDjJbb swDjJbb) {
        this.swDjJbb = swDjJbb;
    }

    public String getFcId() {
        return fcId;
    }

    public void setFcId(String fcId) {
        this.fcId = fcId;
    }

    public SwDjSy getSwDjSy() {
        return swDjSy;
    }

    public void setSwDjSy(SwDjSy swDjSy) {
        this.swDjSy = swDjSy;
    }

    public Date getUpdateDate() {
        return updateDate;
    }

    public void setUpdateDate(Date updateDate) {
        this.updateDate = updateDate;
    }

    public Date getFcMssjBegin() {
        return fcMssjBegin;
    }

    public void setFcMssjBegin(Date fcMssjBegin) {
        this.fcMssjBegin = fcMssjBegin;
    }

    public Date getFcMssjEnd() {
        return fcMssjEnd;
    }

    public void setFcMssjEnd(Date fcMssjEnd) {
        this.fcMssjEnd = fcMssjEnd;
    }

    public String getFcMsyy() {
        return fcMsyy;
    }

    public void setFcMsyy(String fcMsyy) {
        this.fcMsyy = fcMsyy;
    }

    public BigDecimal getCzfcyz() {
        return czfcyz;
    }

    public void setCzfcyz(BigDecimal czfcyz) {
        this.czfcyz = czfcyz;
    }

    public BigDecimal getJsbl() {
        return jsbl;
    }

    public void setJsbl(BigDecimal jsbl) {
        this.jsbl = jsbl;
    }

    public String getFcjmxzdm() {
        return fcjmxzdm;
    }

    public void setFcjmxzdm(String fcjmxzdm) {
        this.fcjmxzdm = fcjmxzdm;
    }

    public String getFczlXian() {
        return fczlXian;
    }

    public void setFczlXian(String fczlXian) {
        this.fczlXian = fczlXian;
    }

    public String getFczlZhen() {
        return fczlZhen;
    }

    public void setFczlZhen(String fczlZhen) {
        this.fczlZhen = fczlZhen;
    }

    public String getFczlLu() {
        return fczlLu;
    }

    public void setFczlLu(String fczlLu) {
        this.fczlLu = fczlLu;
    }

    public String getFczlHao() {
        return fczlHao;
    }

    public void setFczlHao(String fczlHao) {
        this.fczlHao = fczlHao;
    }

    public String getFczlDong() {
        return fczlDong;
    }

    public void setFczlDong(String fczlDong) {
        this.fczlDong = fczlDong;
    }

    public String getFczlDy() {
        return fczlDy;
    }

    public void setFczlDy(String fczlDy) {
        this.fczlDy = fczlDy;
    }

    public String getFczlLou() {
        return fczlLou;
    }

    public void setFczlLou(String fczlLou) {
        this.fczlLou = fczlLou;
    }

    public String getFczlShi() {
        return fczlShi;
    }

    public void setFczlShi(String fczlShi) {
        this.fczlShi = fczlShi;
    }
}
