package cn.gtmap.landtax.entity;

import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 国土数据比对结果表
 *
 * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
 * @version 1.0, 2014/6/25
 */
@Entity
@Cache(usage = CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
@Table(name = "LOCAL_SB_YZSS")
public class SbYzss implements Serializable {
    @Id
    @Column
    private String sbNum;
    @Column
    private Date fsrq;//入库日期
    @Column
    private String szdm;//税种代码
    @Column
    private String glbm;//管理编码
    @Column
    private BigDecimal nse;//应纳税额
    @Column
    private Date gxrq;//更新日期

    public String getSbNum() {
        return sbNum;
    }

    public void setSbNum(String sbNum) {
        this.sbNum = sbNum;
    }

    public Date getFsrq() {
        return fsrq;
    }

    public void setFsrq(Date fsrq) {
        this.fsrq = fsrq;
    }

    public String getSzdm() {
        return szdm;
    }

    public void setSzdm(String szdm) {
        this.szdm = szdm;
    }

    public String getGlbm() {
        return glbm;
    }

    public void setGlbm(String glbm) {
        this.glbm = glbm;
    }

    public BigDecimal getNse() {
        return nse;
    }

    public void setNse(BigDecimal nse) {
        this.nse = nse;
    }

    public Date getGxrq() {
        return gxrq;
    }

    public void setGxrq(Date gxrq) {
        this.gxrq = gxrq;
    }
}
