package cn.gtmap.landtax.entity;

import com.gtis.common.util.UUIDGenerator;
import org.apache.commons.lang.StringUtils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;


public class ChartBaseParamVo {
    /**
     * 唯一值，用来标记在同一统计页面中，不同图表的配置信息，可自动生成
     * */
    private String uniqueId;

    /**
     * 数据系列参数，该参数不在配置文件中配置，通过seriesStr赋值
     * HashMap中存三个值
     * seriesField：数值对应查询字段
     * seriesName：数值名称
     * seriesUnit：数值单位
     * */
    private List<HashMap> seriesList;

    /**
     * 解析成seriesList，格式如下
     * seriesField,seriesName,seriesUnit[;seriesField,seriesName,seriesUnit...]
     * 例如：SCMJHJ,税源面积合计,平方米
     * */
    private String seriesStr; //

    /**
     * 数值单位
     * */
    private String unit;

    /**
     * X轴刻度名称对应的查询结果列名
     * */
    private String categoriesField;
    /**
     * 图表类型，支持column、pie
     * */
    private String chartType;

    /**
     * 图表标题
     * */
    private String title;

    /**
     * 标记图表中是否使用该记录的标记字段
     * 默认为ROW_USE_FLAG_FIELD_DEFAULT的值
     * 字段不存在或者值为1表示使用该条记录，其它值不使用记录
     * */
    private String rowUseFlagField;

    /**
     * rowUseFlagField未赋值时，rowUseFlagField会使用ROW_USE_FLAG_FIELD_DEFAULT
     * */
    private final static String ROW_USE_FLAG_FIELD_DEFAULT = "CHARTROW";

    /**
     * 自定义图标样式
     * 支持在默认样式的基础上自定新的样式控制或者覆盖默认的样式
     * 标准json数据格式，例如："{title:{text:'图标标题'}}"
     * */
    private String customOptions;

    public String getUniqueId() {
        // 若uniqueId未赋值，则自动生成唯一值
        if (StringUtils.isEmpty(uniqueId))
            this.uniqueId = UUIDGenerator.generate();

        return uniqueId;
    }

    public void setUniqueId(String uniqueId) {
        this.uniqueId = uniqueId;
    }

    public List<HashMap> getSeriesList() {
        return seriesList;
    }

    public void setSeriesList(List<HashMap> seriesList) {
        this.seriesList = seriesList;
    }

    public String getSeriesStr() {
        return seriesStr;
    }

    public void setSeriesStr(String seriesStr) {
        this.seriesStr = seriesStr;

        if (StringUtils.isNotEmpty(seriesStr) && this.seriesList == null) {
            List<HashMap> serieslist = new ArrayList<HashMap>();
            String[] seriesStrList = seriesStr.split(";");
            for (int i = 0; i < seriesStrList.length; i++) {
                String series = seriesStrList[i];
                HashMap hashMap = new HashMap();

                String[] seriesList = series.split(",");
                hashMap.put("seriesField", seriesList[0]);
                hashMap.put("seriesName", seriesList[1]);
                if (StringUtils.isEmpty(seriesList[2])) {
                    hashMap.put("seriesUnit", unit);
                } else {
                    hashMap.put("seriesUnit", seriesList[2]);
                }

                serieslist.add(hashMap);
            }
            this.seriesList = serieslist;
        }
    }

    public String getUnit() {
        return unit;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }

    public String getCategoriesField() {
        return categoriesField;
    }

    public void setCategoriesField(String categoriesField) {
        this.categoriesField = categoriesField;
    }

    public String getChartType() {
        return chartType;
    }

    public void setChartType(String chartType) {
        this.chartType = chartType;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getRowUseFlagField() {
        // 若rowUseFlagField未赋值，则使用默认值ROW_USE_FLAG_FIELD_DEFAULT
        if (StringUtils.isEmpty(rowUseFlagField))
            this.rowUseFlagField = ROW_USE_FLAG_FIELD_DEFAULT;

        return rowUseFlagField;
    }

    public void setRowUseFlagField(String rowUseFlagField) {
        this.rowUseFlagField = rowUseFlagField;
    }

    public String getCustomOptions() {
        return customOptions;
    }

    public void setCustomOptions(String customOptions) {
        this.customOptions = customOptions;
    }

    public ChartBaseParamVo() {
        super();
    }

	public int compareTo(cn.gtmap.landtax.entity.ChartBaseParamVo arg0) {
		if (arg0 == null) {
			return 1;
		}else {
			return this.getUniqueId().compareTo(arg0.getUniqueId());
		}

	}
}
