﻿-- 土地证号一致，面积差值比例小于20%的做自动挂接处理
-- 查询结果放入临时表
CREATE TABLE TEMP_SY_ZD AS 
SELECT t.SY_ID, MAX(t.DJH) AS DJH
FROM (
      SELECT t.SY_ID, t1.DJH, RANK() OVER(PARTITION BY t.SY_ID ORDER BY DECODE(NVL(t1.SCMJ,0), 0, 0, ABS(NVL(t.TDMJ,0) - NVL(t1.SCMJ,0))/NVL(t1.SCMJ,0))) AS PM
      FROM (
            SELECT SY_ID, TDZH, TDMJ, SUBSTR(TDZH, ST1 + 1, ST2 - St1 - 1) AS NF, SUBSTR(TDZH, ST3 + 1, ST4 - ST3 - 1) AS DM
            FROM (
                  SELECT SY_ID, TDZH, TDMJ, ST1, ST2, DECODE(SIGN(INSTR(TDZH, '第')), 0, ST2, INSTR(TDZH, '第')) ST3, DECODE(SIGN(INSTR(TDZH, '号')), 0, ST2, LENGTH(TDZH)) ST4
                  FROM (
                        SELECT SY_ID, TDZH, TDMJ, DECODE(SIGN(INSTR(TDZH, '（')), 0, INSTR(TDZH, '('), DECODE(SIGN(INSTR(TDZH, '（')), 0, 1, INSTR(TDZH, '（'))) AS ST1, 
                               DECODE(SIGN(INSTR(TDZH, '）')), 0, INSTR(TDZH, ')'), DECODE(SIGN(INSTR(TDZH, '）')), 0, 1, INSTR(TDZH, '）'))) AS ST2
                        FROM  SW_DJ_TD
                       )
                 )
           ) t 
           LEFT JOIN (
            SELECT DJH, TDZH, SCMJ, SUBSTR(TDZH, ST1 + 1, ST2 - St1 - 1) AS NF, SUBSTR(TDZH, ST3 + 1, ST4 - ST3 - 1) AS DM
            FROM (
                  SELECT DJH, TDZH, SCMJ, ST1, ST2, DECODE(SIGN(INSTR(TDZH, '第')), 0, ST2, INSTR(TDZH, '第')) ST3, DECODE(SIGN(INSTR(TDZH, '号')), 0, ST2, LENGTH(TDZH)) ST4
                  FROM (
                        SELECT DJH, TDZH, SCMJ, DECODE(SIGN(INSTR(TDZH, '（')), 0, INSTR(TDZH, '('), DECODE(SIGN(INSTR(TDZH, '（')), 0, 1, INSTR(TDZH, '（'))) AS ST1, 
                               DECODE(SIGN(INSTR(TDZH, '）')), 0, INSTR(TDZH, ')'), DECODE(SIGN(INSTR(TDZH, '）')), 0, 1, INSTR(TDZH, '）'))) AS ST2
                        FROM  (SELECT TO_CHAR(TDZH) AS TDZH, DJH, SCMJ FROM ZD_SJGJ)
                       )
                 )
           ) t1 ON (t.NF = t1.NF AND t.DM = t1.DM)
      WHERE t1.NF IS NOT NULL AND DECODE(NVL(t1.SCMJ,0), 0, 0, ABS(NVL(t.TDMJ,0) - NVL(t1.SCMJ,0))/NVL(t1.SCMJ,0))<0.2
     ) t
WHERE PM=1
GROUP BY t.SY_ID;
-- 处理
UPDATE SW_DJ_SY t SET (t.SJLY, t.GT_BM, t.GTLY, t.UPDATE_RQ, t.BZ) = (SELECT '1' AS SJLY, t1.DJH, '1' AS GTLY, SYSDATE AS UPDATE_RQ, '土地证号一致，面积差值比例小于20%的做自动挂接处理' AS BZ FROM TEMP_SY_ZD t1 WHERE t.SY_ID=t1.SY_ID) 
WHERE t.GT_BM IS NULL AND t.SYZT='1' AND EXISTS (SELECT '1' AS SJLY, t1.DJH, '1' AS GTLY FROM TEMP_SY_ZD t1 WHERE t.SY_ID=t1.SY_ID);
-- 删除临时表
DROP TABLE TEMP_SY_ZD;

-- 权利人证件号码一致，面积差值比例小于20%的做自动挂接处理
-- 查询结果放入临时表
CREATE TABLE TEMP_SY_ZD AS 
SELECT t.SY_ID, MAX(t.DJH) AS DJH
FROM (
      SELECT t.SY_ID, t3.DJH, RANK() OVER(PARTITION BY t.SY_ID ORDER BY DECODE(NVL(t3.SCMJ,0), 0, 0, ABS(NVL(t2.TDMJ,0) - NVL(t3.SCMJ,0))/NVL(t3.SCMJ,0))) AS PM
      FROM SW_DJ_SY t
           LEFT JOIN SW_DJ_JBB t1 ON t.SWGLM=t1.SWGLM
           LEFT JOIN SW_DJ_TD t2 ON t.SY_ID=t2.SY_ID
           LEFT JOIN ZD_SJGJ t3 ON (t1.FDDBRZJHM=t3.FDDBRZJHM)
      WHERE t3.FDDBRZJHM IS NOT NULL AND DECODE(NVL(t3.SCMJ,0), 0, 0, ABS(NVL(t2.TDMJ,0) - NVL(t3.SCMJ,0))/NVL(t3.SCMJ,0))<0.2
     ) t
WHERE PM=1
GROUP BY t.SY_ID;
-- 处理
UPDATE SW_DJ_SY t SET (t.SJLY, t.GT_BM, t.GTLY, t.UPDATE_RQ, t.BZ) = (SELECT '1' AS SJLY, t1.DJH, '1' AS GTLY, SYSDATE AS UPDATE_RQ, '权利人证件号码一致，面积差值比例小于20%的做自动挂接处理' AS BZ FROM TEMP_SY_ZD t1 WHERE t.SY_ID=t1.SY_ID) 
WHERE t.GT_BM IS NULL AND t.SYZT='1' AND EXISTS (SELECT * FROM TEMP_SY_ZD t1 WHERE t.SY_ID=t1.SY_ID);
-- 删除临时表
DROP TABLE TEMP_SY_ZD;

-- 纳税人名称跟权利人名称一致，面积差值比例小于20%的做自动挂接处理
-- 查询结果放入临时表
CREATE TABLE TEMP_SY_ZD AS 
SELECT t.SY_ID, MAX(t.DJH) AS DJH
FROM (
      SELECT t.SY_ID, t3.DJH, RANK() OVER(PARTITION BY t.SY_ID ORDER BY DECODE(NVL(t3.SCMJ,0), 0, 0, ABS(NVL(t2.TDMJ,0) - NVL(t3.SCMJ,0))/NVL(t3.SCMJ,0))) AS PM
      FROM SW_DJ_SY t
           LEFT JOIN SW_DJ_JBB t1 ON t.SWGLM=t1.SWGLM
           LEFT JOIN SW_DJ_TD t2 ON t.SY_ID=t2.SY_ID
           LEFT JOIN ZD_SJGJ t3 ON (t1.NSRMC=t3.QLRMC)
      WHERE t3.QLRMC IS NOT NULL AND DECODE(NVL(t3.SCMJ,0), 0, 0, ABS(NVL(t2.TDMJ,0) - NVL(t3.SCMJ,0))/NVL(t3.SCMJ,0))<0.2
     ) t
WHERE PM=1
GROUP BY t.SY_ID;
-- 处理
UPDATE SW_DJ_SY t SET (t.SJLY, t.GT_BM, t.GTLY, t.UPDATE_RQ, t.BZ) = (SELECT '1' AS SJLY, t1.DJH, '1' AS GTLY, SYSDATE AS UPDATE_RQ, '纳税人名称跟权利人名称一致，面积差值比例小于20%的做自动挂接处理' AS BZ FROM TEMP_SY_ZD t1 WHERE t.SY_ID=t1.SY_ID) 
WHERE t.GT_BM IS NULL AND t.SYZT='1' AND EXISTS (SELECT '1' AS SJLY, t1.DJH, '1' AS GTLY FROM TEMP_SY_ZD t1 WHERE t.SY_ID=t1.SY_ID);
-- 删除临时表
DROP TABLE TEMP_SY_ZD;

-- 土地证号跟土地坐落缺失，确认无法挂接
UPDATE SW_DJ_SY t SET (t.SJLY, t.UPDATE_RQ, t.BZ) = (SELECT '4' AS SJLY, SYSDATE AS UPDATE_RQ, '土地证号跟土地坐落缺失，确认无法挂接' AS BZ FROM DUAL)
WHERE t.SJLY='0' AND t.SYZT='1' AND EXISTS (SELECT t1.* FROM SW_DJ_TD t1 WHERE t1.SY_ID=t.SY_ID AND (t1.TDZL IS NULL OR t1.TDZL='') AND (t1.TDZH IS NULL OR t1.TDZH=''));

-- 土地证号缺失、土地坐落跟纳税人名称有匹配记录，面积不在容差范围内，确认无法挂接
UPDATE SW_DJ_SY t SET (t.SJLY, t.UPDATE_RQ, t.BZ) = (SELECT '4' AS SJLY, SYSDATE AS UPDATE_RQ, '土地证号缺失、土地坐落跟纳税人名称有匹配记录，面积不在容差范围内，确认无法挂接' AS BZ FROM DUAL)
WHERE t.SJLY='0' AND t.SYZT='1' AND EXISTS (SELECT t1.SY_ID 
                                            FROM SW_DJ_TD t1 
                                            WHERE t1.SY_ID=t.SY_ID AND EXISTS (SELECT t2.DJH FROM ZD_SJGJ t2 WHERE t1.TDZL=t2.TDZL)
                                           )
      AND NOT EXISTS (SELECT t3.SWGLM FROM SW_DJ_JBB t3 WHERE t.SWGLM=t3.SWGLM AND EXISTS (SELECT t4.DJH FROM ZD_SJGJ t4 WHERE t3.NSRMC=t4.QLRMC));

-- 法定代表人证件号码一致，纳税人名称跟权利人名称不一致，确认无法挂接
UPDATE SW_DJ_SY t SET (t.SJLY, t.UPDATE_RQ, t.BZ) = (SELECT '4' AS SJLY, SYSDATE AS UPDATE_RQ, '土地证号缺失、土地坐落跟纳税人名称有匹配记录，面积不在容差范围内，确认无法挂接' AS BZ FROM DUAL)
WHERE t.SJLY='0' AND t.SYZT='1' 
      AND EXISTS (SELECT t3.SWGLM FROM SW_DJ_JBB t3 WHERE t.SWGLM=t3.SWGLM AND NOT EXISTS (SELECT t4.DJH FROM ZD_SJGJ t4 WHERE t3.NSRMC=t4.QLRMC AND t3.FDDBRZJHM=t4.FDDBRZJHM) AND EXISTS (SELECT t4.DJH FROM ZD_SJGJ t4 WHERE t3.FDDBRZJHM=t4.FDDBRZJHM))
      AND EXISTS (SELECT t.SY_ID FROM SW_DJ_TD t2 WHERE t.SY_ID=t2.SY_ID);
