/**
 * Created by gzx on 14-4-2.
 */

$(document).ready(function(){
    //重点税源级别比例
    var options = {
        chart: {
            renderTo: 'container',
            type: 'column',
            margin: 75,
            options3d: {
                enabled: true,
                alpha: 0,
                beta: 0,
                depth: 50,
                viewDistance: 25
            }
        },
        title: {
            text: '重点税源级别比例',
            x: 0 //center
        },
        xAxis: {
            //categories: ['1','2','3','4','5','6','7']
        },
        yAxis:[{
            tickPixelInterval:50,
            lineWidth: 1,
            labels: {
                formatter: function() {
                    return this.value;
                },
                style: {
                    color: '#89A54E'
                }
            },
            title: {
                text: '户数',
                style: {
                    color: '#89A54E'
                }
            }
        }, { // Secondary yAxis
            lineWidth: 1,
            title: {
                text: '百分比',
                style: {
                    color: '#89A54E'
                }
            },
            labels: {
                formatter: function() {
                    return this.value +'%';
                }
            },
            opposite: true
        }],
        plotOptions: {
            column: {
                depth: 25,
                dataLabels:{
                    enabled:true //是否显示数据标签
                }
            }
        },
        series: [{}]
    };
    //重点税源收入比例
    var opt = {
        chart: {
            renderTo: 'container',  //饼状图关联html元素id值
            type: 'pie',
            options3d: {
                enabled: true,
                alpha: 40,
                beta: 10
            }
        },
        title: {
            text: '重点税源收入比例'  //图表标题
        },
        tooltip: {
            pointFormat: '{series.name}: <b>{point.percentage:.1f}%</b>'
        },
        credits:{
            enabled:false
        },
        plotOptions: {
            pie: {
                allowPointSelect: true, //允许选中，点击选中的扇形区可以分离出来显示
                cursor: 'pointer',  //当鼠标指向扇形区时变为手型（可点击）
                depth: 35,
                //showInLegend: true,  //如果要显示图例，可将该项设置为true
                dataLabels: {
                    enabled: true,  //设置数据标签可见，即显示每个扇形区对应的数据
                    color: '#000000',  //数据显示颜色
                    connectorColor: '#999',  //设置数据域扇形区的连接线的颜色
                    style:{
                        fontSize: '12px'  //数据显示的大小
                    }
                    //pointFormat: '{series.name}: <b>{point.percentage:.1f}%</b>'
                },
                showInLegend: true
            }
        },
        //数据列选项
        series: [{
            type: 'pie',
            name: '纳税额',
            data: []
        }]
    };
    //重点税源税收收入结构
    var op = {
        chart: {
            renderTo: 'container',
            type: 'column',
            margin: 75,
            options3d: {
                enabled: true,
                alpha: 20,
                beta: 0,
                depth: 50,
                viewDistance: 25
            }
        },
        title: {
            text: '重点税源税收收入结构',
            x: 0 //center
        },
        credits:{
            enabled:false
        },
        xAxis: {
            categories: ['申报','入库','欠缴','查补']
        },
        yAxis:[{
            tickPixelInterval:50,
            lineWidth: 1,
            labels: {
                style: {
                    color: '#89A54E'
                }
            },
            title: {
                text: '万元',
                style: {
                    color: '#89A54E'
                }
            }
        }],
        plotOptions: {
            column: {
                depth: 25,
                dataLabels:{
                    enabled:true //是否显示数据标签
                }
            }
        },
        series: [{}]
    };
    //城镇土地使用税税源汇总示意图
    var opti = {
        chart: {
            renderTo: 'container',
            type: 'column',
            margin: 75,
            options3d: {
                enabled: true,
                alpha: 20,
                beta: 0,
                depth: 50,
                viewDistance: 25
            }
        },
        title: {
            text: '城镇土地使用税税源汇总示意图',
            x: 0 //center
        },
        credits:{
            enabled:false
        },
        xAxis: {
            categories: ['占地面积','应税面积','应纳税额','免税面积','免税税额']
        },
        yAxis:[{
            tickPixelInterval:50,
            lineWidth: 1,
            labels: {
                style: {
                    color: '#89A54E'
                }
            },
            title: {
                text: '万平方米、万元',
                align: 'high',
                style: {
                    color: '#89A54E'
                }
            }
        }],
        plotOptions: {
            column: {
                depth: 25,
                dataLabels:{
                    enabled:true//是否显示数据标签
                }
            }
        },
        series: [{
            dataLabels:{//在柱子的顶部显示值
                enabled:true,
                formatter:function(){
                    if(this.y>0){
                        return Highcharts.numberFormat(this.y);
                    }
                }
            }
        }]
    };
    //房产税税源汇总示意图
    var optio = {
        chart: {
            renderTo: 'container',
            type: 'column',
            margin: 75,
            options3d: {
                enabled: true,
                alpha: 20,
                beta: 0,
                depth: 50,
                viewDistance: 25
            }
        },
        title: {
            text: '城镇土地使用税税源汇总示意图',
            x: 0 //center
        },
        credits:{
            enabled:false
        },
        xAxis: {
            categories: ['应税原值','租金','应纳税额','免税原值','免税税额']
        },
        yAxis:[{
            tickPixelInterval:50,
            lineWidth: 1,
            labels: {
                style: {
                    color: '#89A54E'
                }
            },
            title: {
                text: '万元',
                style: {
                    color: '#89A54E'
                }
            }
        }],
        plotOptions: {
            column: {
                depth: 25
            }
        },
        series: [{}]
    };

    $("#keyStatics").click(function(){
        var divObj = document.getElementById("zdsy");
        divObj.parentNode.removeChild(divObj);
        var tabObj = document.getElementById("tab_val");
        tabObj.parentNode.removeChild(tabObj);
    });
    //重点税源级别比例
    $("#jbbl").click(function(){
        $.ajax({
            url:"/landtax/zdsy/getZdsyjb",
            async:false,
            dataType: "json",
            type:"post",
            success:function(value){

                options.series[0] = value.data[0];
                options.series[1] = value.data[2];
                options.xAxis.categories = value.data[1].data;
                options.series[0].yAxis = 0;
                options.series[1].yAxis = 1;

                var chart = new Highcharts.Chart(options);
            },
            error:function(){
                alert("加载错误！");
            }
        });
    });
    //重点税源收入比例
    $("#srbl").click(function(){

        $.ajax({
            url:"/landtax/zdsy/getZdsysrbl",
            async:false,
            dataType: "json",
            type:"post",
            success:function(value){
                opt.series[0].data[0] = value.data[0];
                opt.series[0].data[1] = value.data[1];
                opt.series[0].data[2] = value.data[2];

                opt.series[0].data[1].sliced = true;
                opt.series[0].data[1].selected = true;
                //opt.series.data[1] = value.data[0];
                var chart = new Highcharts.Chart(opt);
            },
            error:function(){
                alert("加载错误！");
            }
        });
    });
    //重点税源税收收入结构
    $("#sssr").click(function(){
        $.ajax({
            url:"/landtax/zdsy/getSssr",
            async:false,
            dataType: "json",
            type:"post",
            success:function(value){
                op.series[0] = value.data[0];
                var chart = new Highcharts.Chart(op);
            },
            error:function(){
                alert("加载错误！");
            }
        });
        $("#tittle").html("");

    });
    //城镇土地使用税税源汇总示意图
    $("#syshz").click(function(){
        $.ajax({
            url:"/landtax/zdsy/getSyshz",
            async:false,
            dataType: "json",
            type:"post",
            success:function(value){
                opti.series[0] = value.data[0];
                var chart = new Highcharts.Chart(opti);
            },
            error:function(){
                alert("加载错误！");
            }
        });
        $("#tittle").html("");

    });
    //房产税税源汇总示意图
    $("#fcshz").click(function(){
        $.ajax({
            url:"/landtax/zdsy/getFcshz",
            async:false,
            dataType: "json",
            type:"post",
            success:function(value){
                optio.series[0] = value.data[0];
                var chart = new Highcharts.Chart(optio);
            },
            error:function(){
                alert("加载错误！");
            }
        });
        $("#tittle").html("");

    });

});