/**
 * 封装了jqGrid
 * colModel自定义参数说明：
 * 属性：mergeBy；值：列名；说明：该属性表示列值需要合并，合并参照属性值对应的列值
 * 属性：needExport；值：ture或者false；说明：字段是否需要导出，默认隐藏字段不导出，显示字段导出
 * option属性说明：
 * 属性：setgroupHeaders；说明：设置二级表头，具体参照jqGrid的标准配置方法
 */
(function($){
    var defaults={
        grid_selector:'#grid-table',
        datatype:'json',
        rowNum:20,
        height:400,
        autoHeight:true,
        datatype: "json",
        viewrecords: true,
        mtype:'POST',
        altRows: true,
        autowidth: true ,
        shrinkToFit: false,
        del: false,
        asdd: false,
        edit: false,
        search: false,
        pager: '#grid-pager',
        jsonReader: {
            root: "content",
            total: "totalPages",
            page: "number",
            records: "totalElements",
            repeatitems: false

        },
        loadComplete: function () {
            var table = this;
            setTimeout(function () {
                updatePagerIcons(table);
                enableTooltips(table);
            }, 0);
        },
        multiselect: false,
        onSelectRow: function (rowId, status, e) {

            var rowData = $(this).jqGrid('getRowData', rowId);
        }
    };

    var grid, gridOptions;

    function afterCompleteFunction(){
//获取列表数据
        var rowDatas = grid.jqGrid('getAllRowDatas');
        for(i=0;i<rowDatas.length;i++){
            var rowData = rowDatas[i];
            if(rowData.recVer=='1'){
//获取每行下的TD更改CSS
//第一种写法
                //$("#"+rowData.crmCustContractId).find("td").css("background-color", "pink");
//第2种写法
                $("#"+rowData.crmCustContractId + " td").css("background-color","pink");
//alert($("#"+rowData.crmCustContractId).find("td")[0]);
            }
        }
        return true;
    }

    function initGrid(options) {
        grid=jQuery(options.grid_selector).jqGrid(options);
        jQuery(window).resize(function(){
            //jQuery("#gview_grid-table").height(jQuery(window).height()-190);
            //jQuery(".ui-jqgrid-bdiv").height(jQuery(window).height()-218);
        });
    }

    function alarmFormatter(cellvalue, options, rowdata)
    {
        if (cellvalue != "0")
            return '<img class="alarmimg" src="../Images/128x128/RedLight.png" alt="' + cellvalue + '" />';
        else
            return '<img class="alarmimg" src="../Images/128x128/GreenLight.png" alt="' + cellvalue + '" />';
    }

    function updatePagerIcons(table) {
        var replacement ={
            'ui-icon-seek-first' : 'ace-icon fa fa-angle-double-left bigger-140',
            'ui-icon-seek-prev' : 'ace-icon fa fa-angle-left bigger-140',
            'ui-icon-seek-next' : 'ace-icon fa fa-angle-right bigger-140',
            'ui-icon-seek-end' : 'ace-icon fa fa-angle-double-right bigger-140'
        };
        $('.ui-pg-table:not(.navtable) > tbody > tr > .ui-pg-button > .ui-icon').each(function () {
            var icon = $(this);
            var $class = $.trim(icon.attr('class').replace('ui-icon', ''));

            if ($class in replacement) icon.attr('class', 'ui-icon ' + replacement[$class]);
        })
    }

    function enableTooltips(table) {
        $('.navtable .ui-pg-button').tooltip({container: 'body'});
        $(table).find('.ui-pg-div').tooltip({container: 'body'});
    }

    function modifySize(){
        //jQuery("#gview_grid-table").height(jQuery(window).height()-190);
        //jQuery(".ui-jqgrid-bdiv").height(jQuery(window).height()-218);
    }

    $.fn.gGrid = function(options){
        //var drawHeight = jQuery(window).height()-218;
        var drawHeight = parseInt((this).css("height"))-140;
        if(drawHeight==-140){
            drawHeight =  jQuery(window).height()-218;
        }
        var drawRowNum = Math.floor(drawHeight/33);
        var options = $.extend(false,defaults,options);
        if(options.autoHeight){
            options.rowNum =  drawRowNum;
            options.height = drawHeight;
        }
        //return this.each(function(){
            var gridDefAtt = $(this).attr('data-definition');
            options.gridDefinitionUrl = (gridDefAtt!=null&&gridDefAtt!='')?gridDefAtt:options.gridDefinition;
            if(options.gridDefinitionUrl!=null&&options.gridDefinitionUrl!=''){

                $.ajax({
                    url: options.gridDefinitionUrl,
                    dataType: 'json',
                    async : false,
                    success: function (data) {
                        gridOptions = data;

                        if(options.url==null || options.url==""){
                            options.url  = data.baseUrl;
                        }
                        options.colNames = data.colNames;
                        options.colModel = data.colModel;

                        initGrid(options);

                        // 合并列头
                        if (data.setgroupHeaders != null)
                            grid.jqGrid('setGroupHeaders', data.setgroupHeaders);
                    }
                });
                return grid;
            }
        //});
    };

    $.fn.getOptions = function(){
        return gridOptions;
    }

    $.fn.getGrid = function(){
        return grid;
    }

    $.fn.getCheckId  = function(bh) {
        var selectedId = grid.jqGrid("getGridParam", "selrow");
        var text="";
        var ids =grid.jqGrid('getGridParam','selarrrow');
        for (var i = 0; i < ids.length; i++) {
            var rowData = grid.jqGrid('getRowData', i + 1);
            if (rowData[bh]==null || rowData[bh]==""){
                continue;
            }
            if(text=="")
                text = text +"'" + rowData[bh]+"'" ;
            else
                text = text +","+ "'" + rowData[bh]+"'" ;
        }
         return text;
    };

    $.fn.getSelectedData  = function(field) {
        var text="";
        var ids =grid.jqGrid('getGridParam','selarrrow');
        for (var i = 0; i < ids.length; i++) {
            var rowData = grid.jqGrid('getRowData', ids[i]);
            if (rowData[field]==null || rowData[field]==""){
                continue;
            }
            text+=rowData[field]+",";
        }
        return text;
    };

    $.fn.refreshGrid = function(data,page){
        grid.jqGrid('setGridParam', {
            postData: data,
            page: page!=null?page:1
        }).trigger("reloadGrid");
    };

    $.fn.reloadGrid = function(url,data,page){
        grid.jqGrid('setGridParam', {
            url:url,
            postData: data,
            page: page!=null?page:1
        }).trigger("reloadGrid");
    }

    // 合并单元格
    $.fn.mergeRowCell = function(){
        var colModel = gridOptions.colModel;
        for (var i = 0; i < colModel.length; i++) {
            if (colModel[i].mergeBy != null) {
                mergerCell(colModel[i].name, colModel[i].mergeBy);
            }
        }
    }

    function mergerCell (mergeName, byName) {
        //得到显示到界面的id集合
        var mya = grid.jqGrid('getDataIDs');
        //当前显示多少条
        var length = mya.length;
        for (var i = 0; i < length; i++) {
            //从上到下获取一条信息
            var before = grid.jqGrid('getRowData', mya[i]);
            //定义合并行数
            var rowSpanTaxCount = 1;
            for (j = i + 1; j <= length; j++) {
                //和上边的信息对比 如果值一样就合并行数+1 然后设置rowspan 让当前单元格隐藏
                var end = grid.jqGrid('getRowData', mya[j]);
                if (before[byName] == end[byName]) {
                    rowSpanTaxCount++;
                    grid.setCell(mya[j], mergeName, '', { display: 'none' });
                } else {
                    rowSpanTaxCount = 1;
                    break;
                }
                grid.setCell(mya[i], mergeName, '', null,{ rowspan: rowSpanTaxCount });
            }
        }
    }
})(jQuery);

