/**
 * Created by gzx on 14-4-2.
 */

$(document).ready(function(){
    //重点税源
    var options = {
        chart : {
            renderTo : 'leftChart'
        },
        title: {
            text: '重点税源月收入、增幅',
            x: -100 //center
        },
        xAxis: {
            categories: ['1','2','3','4','5','6','7','8','9','10', '11', '12']
        },
        yAxis:[{
            tickPixelInterval:50,
            lineWidth: 1,
            labels: {
                formatter: function() {
                    return this.value;
                },
                style: {
                    color: '#89A54E'
                }
            },
            title: {
                text: '月收入(万元)',
                style: {
                    color: '#89A54E'
                }
            }
        }, { // Secondary yAxis
            lineWidth: 1,
            title: {
                text: '增幅(%)',
                style: {
                    color: '#89A54E'
                }
            },
            labels: {
                formatter: function() {
                    return this.value +'%';
                }
            },
            opposite: true
        }],
        credits:{
            enabled:false
        },
        legend: {
            //layout: 'vertical',
            borderWidth: 0,
            layout:'horizontal'

        },
        plotOptions: {
            line: {
                dataLabels: {
                    enabled: true
                }
               // enableMouseTracking: false
            }
        },
        series: [{}]
    }

    var opt = {
        chart : {
            renderTo : 'rightChart'
        },
        title: {
            text: '重点税源年收入、增幅',
            x: -100 //center
        },
        xAxis: {
            categories: ['2009','2010','2011','2012','2013']
        },
        yAxis:[{
            tickPixelInterval:50,
            lineWidth: 1,
            labels: {
                formatter: function() {
                    return this.value;
                },
                style: {
                    color: '#89A54E'
                }
            },
            title: {
                text: '年收入(万元)',
                style: {
                    color: '#89A54E'
                }
            }
        }, { // Secondary yAxis
            lineWidth: 1,
            title: {
                text: '增幅(%)',
                style: {
                    color: '#89A54E'
                }
            },
            labels: {
                formatter: function() {
                    return this.value +'%';
                }
            },
            opposite: true
        }],
        credits:{
            enabled:false
        },
        legend: {
            //layout: 'vertical',
            borderWidth: 0,
            layout:'horizontal'

        },
        plotOptions: {
            line: {
                dataLabels: {
                    enabled: true
                }
                // enableMouseTracking: false
            }
        },
        series: [{}]
    }



    $("#keytax").click(function(){
        $.ajax({
            url:"/landtax/aiddecision/getZdsyysr",
            async:false,
            dataType: "json",
            type:"post",
            success:function(value){
                //alert(value);
                options.series[0] = value.data[0];
                options.series[1] = value.data[1];
                options.series[0].yAxis = 0;
                options.series[1].yAxis = 1;

                opt.series[0] = value.data[2];
                opt.series[1] = value.data[3];
                opt.series[0].yAxis = 0;
                opt.series[1].yAxis = 1;

                var chart = new Highcharts.Chart(options);

                var ch= new Highcharts.Chart(opt);
            },
            error:function(){
                alert("加载错误！");
            }
        });

        $("#tittle").html("<span style='font-size: 20px;font-weight: bolder;'>重点税源</span>");

    });


});