function renderGridNumber(value, p, r) {
    return Ext.String.format('{0}', Ext.util.Format.number(value,'0.0000').replace(',', '.'));
}
function renderGridDate(value, p, r) {
    return Ext.String.format('{0}', Ext.Date.dateFormat(new Date(value),'Y-m-d'));
}

function parseURL(url) {
    var a = document.createElement('a');
    a.href = url;
    return {
        source: url,
        protocol: a.protocol.replace(':', ''),
        host: a.hostname,
        port: a.port,
        query: a.search,
        params: (function () {
            var ret = {},
                seg = a.search.replace(/^\?/, '').split('&'),
                len = seg.length, i = 0, s;
            for (; i < len; i++) {
                if (!seg[i]) { continue; }
                s = seg[i].split('=');
                ret[s[0]] = s[1];
            }
            return ret;

        })(),
        file: (a.pathname.match(/\/([^\/?#]+)$/i) || [, ''])[1],
        hash: a.hash.replace('#', ''),
        path: a.pathname.replace(/^([^\/])/, '/$1'),
        relative: (a.href.match(/tps?:\/\/[^\/]+(.+)/) || [, ''])[1],
        segments: a.pathname.replace(/^\//, '').split('/')
    };
}

//替换myUrl中的同名参数值
function replaceUrlParams(myUrl, newParams) {
    for (var x in newParams) {
        var hasInMyUrlParams = false;
        for (var y in myUrl.params) {
            if (x.toLowerCase() == y.toLowerCase()) {
                myUrl.params[y] = newParams[x];
                hasInMyUrlParams = true;
                break;
            }
        }
        //原来没有的参数则追加
        if (!hasInMyUrlParams) {
            myUrl.params[x] = newParams[x];
        }
    }
    var _result = myUrl.protocol + "://" + myUrl.host + ":" + myUrl.port + myUrl.path + "?";

    for (var p in myUrl.params) {
        _result += (p + "=" + myUrl.params[p] + "&");
    }

    if (_result.substr(_result.length - 1) == "&") {
        _result = _result.substr(0, _result.length - 1);
    }

    if (myUrl.hash != "") {
        _result += "#" + myUrl.hash;
    }
    return _result;
}

function reloadWindow(){
    window.location.reload();
}

/**
 * 将form序列化为json对象方法
 */
$(function(){

    $.fn.serializeObject = function(){
        var json = {}
        var form = $(this);
        form.find('input, select, textarea').each(function(){
            var val
            if (!this.name) return;

            if ('radio' === this.type) {
                if (json[this.name]) { return; }

                json[this.name] = this.checked ? this.value : '';
            } else if ('checkbox' === this.type) {
                val = json[this.name];

                if (!this.checked) {
                    if (!val) { json[this.name] = ''; }
                } else {
                    json[this.name] =
                            typeof val === 'string' ? [val, this.value]:
                        $.isArray(val) ? $.merge(val, [this.value]) :
                            this.value;
                }
            } else {
                if(this.value=='---请选择---'){
                    json[this.name] = '';
                }else{
                    json[this.name] = this.value;
                }
            }
        })
        return json;
    }

    $.fn.serializeJson = function(){
        var valueJson = {};
        var operatorJson = {};
        var form = $(this);
        form.find('input, select').each(function(){
            var val;
            if (!this.name) return;

            if ('radio' === this.type) {
                if (valueJson[this.name]) { return; }

                valueJson[this.name] = this.checked ? this.value : '';
            } else if ('checkbox' === this.type) {
                val = valueJson[this.name];

                if (!this.checked) {
                    if (!val) { valueJson[this.name] = ''; }
                } else {
                    valueJson[this.name] =
                            typeof val === 'string' ? [val, this.value] :
                        $.isArray(val) ? $.merge(val, [this.value]) :
                            this.value;
                }
            } else if ('select-multiple' === this.type) {
                if ($(this).val() != null)
                    valueJson[this.name] = $(this).val().toString();
            } else {
                valueJson[this.name] = this.value;
            }

            // 添加操作符
            if (valueJson[this.name]) {
                var operatorSign;
                if (this.hasAttribute('operator')) {
                    operatorSign = this.getAttribute('operator')
                } else {
                    operatorSign = 'operator-LK';
                }
                var operator = 'like';
                if (operatorSign == 'operator-EQ') {
                    operator = '=';
                } else if (operatorSign == 'operator-LT') {
                    operator = '<';
                } else if (operatorSign == 'operator-GT') {
                    operator = '>';
                } else if (operatorSign == 'operator-LE') {
                    operator = '<=';
                } else if (operatorSign == 'operator-GE') {
                    operator = '>=';
                } else if (operatorSign == 'operator-LK') {
                    operator = 'like';
                } else if (operatorSign == 'operator-LLK') {
                    operator = 'llike';
                } else if (operatorSign == 'operator-RLK') {
                    operator = 'rlike';
                } else if (operatorSign == 'operator-IN') {
                    operator = 'in';
                }
                operatorJson[this.name] = operator;
            }
        })

        var json = {};
        json["query"] = '[' + JSON.stringify(valueJson) + ',' + JSON.stringify(operatorJson) + ']';
        return json;
    }
});

/**
 *rmb小写转大写（小写的值,转大写的字段id）
 */
function changeDx(num,name){
    var title = "人民币";
    if(f_check_number(num,title)){
        var strOutput = "",
            strUnit = '仟佰拾亿仟佰拾万仟佰拾元角分';
        num=(num.value*100).toString();
        var intPos = num.indexOf('.');
        if (intPos >= 0){
            num = num.substring(0, intPos) + num.substr(intPos + 1, 2);
        }
        strUnit = strUnit.substr(strUnit.length - num.length);
        for (var i=0; i < num.length; i++){
            strOutput += '零壹贰叁肆伍陆柒捌玖'.substr(num.substr(i,1),1) + strUnit.substr(i,1);
        }
        var dx = strOutput.replace(/零角零分$/, '整').replace(/零[仟佰拾]/g, '零').replace(/零{2,}/g, '零').replace(/零([亿|万])/g, '$1').replace(/零+元/, '元').replace(/亿零{0,3}万/, '亿').replace(/^元/, "零元");
        $("#" + name).val(dx);
    }
}

/**
 *rmb小写转大写（小写的值,转大写的字段id）
 */
function changeDxWy(num,name){
    var title = "人民币";
    if(f_check_number(num,title)){
        var strOutput = "",
            strUnit = '仟佰拾亿仟佰拾万仟佰拾元角分';
        num=(num.value*100*10000).toString();
        var intPos = num.indexOf('.');
        if (intPos >= 0){
            num = num.substring(0, intPos) + num.substr(intPos + 1, 2);
        }
        strUnit = strUnit.substr(strUnit.length - num.length);
        for (var i=0; i < num.length; i++){
            strOutput += '零壹贰叁肆伍陆柒捌玖'.substr(num.substr(i,1),1) + strUnit.substr(i,1);
        }
        var dx = strOutput.replace(/零角零分$/, '整').replace(/零[仟佰拾]/g, '零').replace(/零{2,}/g, '零').replace(/零([亿|万])/g, '$1').replace(/零+元/, '元').replace(/亿零{0,3}万/, '亿').replace(/^元/, "零元");
        $("#" + name).val(dx);
    }
}

/*
 * 判断是否为数字，是则返回true,否则返回false
 */
function f_check_number(obj,code){
    if(obj && obj.value){
        if (/^\-?[0-9]*\.?[0-9]*$/.test(obj.value)){
            return true;
        }else{
            obj.value="";
            f_alert(code,"请输入数字");
            //obj.focus();
            return false;
        }
    }
    return false;
}
function f_alert(code,str){
    var msg = "";
    if(code && code != ""){
        msg = code+":"+str;
    }else{
        msg = str;
    }
    msg = msg.replace(/\\n/g,"\n");
    alert(msg);
}
/*
 * 打印
 * ModalUrl：模版地址，可以是网络或者本地地址
 * DataUrl：数据源
 * DesignMode:是否使用设计模式，默认为不使用
 **/
function printSheet(ModalUrl,DataUrl,DesignMode){
    var designMode = (DesignMode==null||DesignMode==""||DesignMode == undefined)?"false":DesignMode;
    window.location.href = "eprt://v2|designMode="+designMode+"|frURL="+ModalUrl+"|dataURL="+DataUrl+"|updateUrl=http://oa.gtis.com.cn:80/platform/pluging/update.ini";
}

function getURL() {
    var ip = window.location.host;
    var url = window.location.protocol+"//"+ip;
    return url;
}

String.prototype.startWith=function(str){
    if(str==null||str==""||this.length==0||str.length>this.length)
        return false;
    if(this.substr(0,str.length)==str)
        return true;
    else
        return false;
    return true;
}

Date.prototype.Format = function(fmt) { // author: meizz
    var o = {
        "M+" : this.getMonth() + 1, // 月份
        "d+" : this.getDate(), // 日
        "h+" : this.getHours(), // 小时
        "m+" : this.getMinutes(), // 分
        "s+" : this.getSeconds(), // 秒
        "q+" : Math.floor((this.getMonth() + 3) / 3), // 季度
        "S" : this.getMilliseconds() // 毫秒
    };
    if (/(y+)/.test(fmt)){
        fmt = fmt.replace(RegExp.$1, (this.getFullYear() + "").substr(4 - RegExp.$1.length));
    }

    for (var k in o){
        if (new RegExp("(" + k + ")").test(fmt)){
            fmt = fmt.replace(RegExp.$1, (RegExp.$1.length == 1) ? (o[k]): (("00" + o[k]).substr(("" + o[k]).length)));
        }
    }
    return fmt;
}
//js计算去除误差*************************
function accMul(arg1,arg2)
{
    var m=0,s1=arg1.toString(),s2=arg2.toString();
    try{m+=s1.split(".")[1].length}catch(e){}
    try{m+=s2.split(".")[1].length}catch(e){}
    return Number(s1.replace(".",""))*Number(s2.replace(".",""))/Math.pow(10,m)
}
function accAdd(arg1,arg2){
    var r1,r2,m;
    try{r1=arg1.toString().split(".")[1].length}catch(e){r1=0}
    try{r2=arg2.toString().split(".")[1].length}catch(e){r2=0}
    m=Math.pow(10,Math.max(r1,r2))
    return (accMul(arg1,m)+accMul(arg2,m))/m
}
function accSub(arg1,arg2){
    var r1,r2,m;
    try{r1=arg1.toString().split(".")[1].length}catch(e){r1=0}
    try{r2=arg2.toString().split(".")[1].length}catch(e){r2=0}
    m=Math.pow(10,Math.max(r1,r2))
    return (arg1*m-arg2*m)/m
}
function accDiv(arg1,arg2){
    var t1=0,t2=0,r1,r2;
    try{t1=arg1.toString().split(".")[1].length}catch(e){}
    try{t2=arg2.toString().split(".")[1].length}catch(e){}
    with(Math){
        r1=Number(arg1.toString().replace(".",""))
        r2=Number(arg2.toString().replace(".",""))
        return (r1/r2)*pow(10,t2-t1);
    }
}
function fixedByText(id,point){
    var num = $("#"+id).text();
    if(num!=null && num!='')
        num = Number(num).toFixed(point);
    $("#"+id).text(num);
}

function fixedByValue(id,point){
    var num = $("#"+id).val();
    if(num!=null && num!='')
        num = Number(num).toFixed(point);
    $("#"+id).val(num);
}

function numFormat (num,point) {
    if(num==''){
        return '';
    }
    return (Number(num).toFixed(point) + '').replace(/\d{1,3}(?=(\d{3})+(\.\d*)?$)/g, '$&,');
}

function numFormatByText (id,point) {
    var num = $("#"+id).text();
    if(num!=null && num!='')
        num = numFormat(num,point);
    $("#"+id).text(num);
}

function numFormatByValue (id,point) {
    var num = $("#"+id).val();
    if(num!=null && num!='')
        num = numFormat(num,point);
    $("#"+id).val(num);
}


function initializeSelect(JQuery){
    var selectDataType = '';
    JQuery('select').each(function(){
        var dataType = JQuery(this).attr('data-url');
        if(dataType != null && dataType != ''){
            selectDataType += dataType + ',';
        }
    });
    if(selectDataType != null && selectDataType != ''){
        JQuery.getJSON(getContextPath()+'/dic?name=' + selectDataType, function(data){
            for(var key in data){
                // 加载下拉选项
                var targetElements = JQuery('select[data-url = "' + key + '"]');
                for (var i = 0; i < targetElements.length; i++) {
                    var targetElement = JQuery(targetElements[i]);
                    targetElement.empty();
                    if (JQuery('select[data-url = "' + key + '"][multiple="multiple"]').length == 0)
                        targetElement.append("<option value=''>---请选择---</option>");
                    var value = targetElement.attr('value');
                    for (var valueKey in data[key]) {
                        targetElement.append("<option value='" + valueKey + "'" + (value === valueKey ? " selected " : "") + ">" + data[key][valueKey] + "</option>");
                    }

                    // 检查是否多选框
                    if (JQuery('select[data-url = "' + key + '"][multiple="multiple"]').length > 0) {
                        $('select[multiple="multiple"]').multiselect({
                            noneSelectedText: "---请选择---",
                            checkAllText: "全选",
                            selectedList: 3
                        });
                    }

                    // 检查是否需要添加对应名称项
                    if (targetElement.attr("selectName") != undefined) {
                        var tempName = targetElement.find("option:selected").text();
                        if ('' == targetElement.find("option:selected").val()) {
                            tempName = "";
                        }
                        var selectName = targetElement.attr("selectName");
                        targetElement.after("<input type='hidden' name='" + selectName + "' value='" + tempName + "'></input>");

                        targetElement.bind("change", function () {
                            var tempVal = JQuery(this).find("option:selected").val();
                            if ('' != tempVal) {
                                var inputName = JQuery(this).attr("selectName");
                                var tempName = JQuery(this).find("option:selected").text();
                                $("input[name='" + inputName + "']").val(tempName);
                            }
                        })
                    }
                    // 出发chang事件
                    targetElement.change();
                }
            }
        });
    }
}

function checkIsDate(strDate){
    re = /^(\d{4})-(\d{2})-(\d{2})$/g;
    if(re.test(strDate)) { // 判断日期格式符合YYYY-MM-DD标准
        var dateElement = new Date(RegExp.$1, parseInt(RegExp.$2, 10) - 1, RegExp.$3);
        if(!((dateElement.getFullYear() == parseInt(RegExp.$1)) && ((dateElement.getMonth() + 1) == parseInt(RegExp.$2, 10)) && (dateElement.getDate() == parseInt(RegExp.$3)))) { //判断日期逻辑
            return false;
        } else {
            return true;
        }
    } else {
        return false;
    }
}

function getContextPath() {
    var contextPath = document.location.pathname;
    var index =contextPath.substr(1).indexOf("/");
    contextPath = contextPath.substr(0,index+1);
    delete index;
    return contextPath;
}


var progress=0;
var isStop = false;
function doProgress(jQuery){
    if(!isStop){
        if (progress <= 100) {
            setTimeout("doProgress(jQuery)", 100);
            SetProgress(progress,jQuery);
            progress++;
        }else{
            progress=0;
            setTimeout("doProgress(jQuery)", 100);
        }
    }

}
function SetProgress(ress,jQuery) {
    if (ress){
        jQuery("#jdtBar").css("width", String(ress) + "%");
    }
}
function showJdt(jQuery, bShow) {
    if (bShow) {
        $("#jdt").show();
        isStop = false;
        progress = 15;
        doProgress(jQuery);
    } else {
        isStop =true;
        $("#jdt").hide();
    }
}


