﻿define(["jquery","dojo/_base/declare",
    "dojo/_base/lang","dojo/on","mapUtils","mustache","mapLOC","esri/layers/LayerInfo","dojo/domReady!"
], function($,declare,lang,on,mapUtils,Mustache,mapLOC,LayerInfo) {
   return declare([],{
       map:null,
       moduleConfig:null,
       templateId:'thematicMapTpl',
       template:null,
       title:'专题图',
       contentId:'thematicList',
       constructor:function(options){
           declare.safeMixin(this,options);
           this.template = $('#'+this.templateId).html();
           Mustache.parse(this.template);
       },
       initialize:function(){
           $('#'+this.contentId).empty();

           var thematicServiceId = null;
           if(this.map.xzqdm!=null&&this.map.xzqdm!=''){
               thematicServiceId = this.moduleConfig[this.map.xzqdm].thematicSerivceId;
           }else{
               thematicServiceId = this.moduleConfig.default.thematicSerivceId;
           }

           var layerInfos=[];
           var defaultVisibleThematicLayers = [];
           layerInfos = this._getThematicLayerInfos(thematicServiceId);
           for(var i=0;i<layerInfos.length;i++){
               var layerInfo = layerInfos[i];
               if(layerInfo.defaultVisibility){
                   defaultVisibleThematicLayers.push(layerInfo.id);
               }else if(layerInfo.name.indexOf('专题图')>-1){
                   var tempItem = Mustache.render(this.template, {serviceId:layerInfo.id,serviceName:layerInfo.name,serviceVisible:layerInfo.defaultVisibility});
                   $('#'+this.contentId).append(tempItem);
                   on($('#thematic'+layerInfo.id),'click',lang.hitch(this,function(thematicServiceId,event){
                       var currentVisible = false;
                       var tmpVisible = ($(event.target).attr('data-visible'));
                       if(tmpVisible!=null&&tmpVisible==='true')
                           currentVisible = true;
                       var targetVisible = !currentVisible;

                       $('#'+this.contentId+'>li>a[data-visible="true"]').each(function () {
                           $(this).attr('data-visible',false);
                       });

                       $(event.target).attr('data-visible',targetVisible);
                       //mapUtils.setMapLayerChecked(layerId,targetVisible);
                       var content = $(event.target).text();
                       if(targetVisible){
                           $(event.target).empty();
                           $(event.target).append('<i class="ace-icon fa fa-check"></i>'+content);
                       }else{
                           $(event.target).empty();
                           $(event.target).append(content);
                       }
                       var visibleLayerIds = [];
                       $('#'+this.contentId+'>li>a[data-visible="true"]').each(function () {
                           var tempId = parseInt($(this).attr('data-service-id'));
                           visibleLayerIds.push(tempId);
                       });
                       if(defaultVisibleThematicLayers.length>0)
                           visibleLayerIds= visibleLayerIds.concat(defaultVisibleThematicLayers);
                       mapUtils.setMapSerivceVisibleLayers(thematicServiceId,visibleLayerIds);
                   },thematicServiceId));
               }
           }

           //for(var i=0;i<layerIds.length;i++) {
           //    var layerId = layerIds[i].layerIndex;
           //    var layerName = layerIds[i].layerName;
           //    var layerVisible = layerIds[i].layerVisible;
           //
           //
           //    var tempItem = Mustache.render(this.template, {serviceId:layerId,serviceName:layerName,serviceVisible:layerVisible});
           //    $('#'+this.contentId).append(tempItem);
           //    on($('#thematic'+layerId),'click',lang.hitch(this,function(thematicServiceId,event){
           //        var currentVisible = false;
           //        var tmpVisible = ($(event.target).attr('data-visible'));
           //        if(tmpVisible!=null&&tmpVisible==='true')
           //           currentVisible = true;
           //        var targetVisible = !currentVisible;
           //
           //        $(event.target).attr('data-visible',targetVisible);
           //        //mapUtils.setMapLayerChecked(layerId,targetVisible);
           //        var content = $(event.target).text();
           //        if(targetVisible){
           //            $(event.target).empty();
           //            $(event.target).append('<i class="ace-icon fa fa-check"></i>'+content);
           //        }else{
           //            $(event.target).empty();
           //            $(event.target).append(content);
           //        }
           //        var visibleLayerIds = [];
           //        $('#'+this.contentId+'>li>a[data-visible="true"]').each(function () {
           //            var tempId = parseInt($(this).attr('data-service-id'));
           //            visibleLayerIds.push(tempId);
           //        });
           //        if(visibleLayerIds.length==0)
           //            visibleLayerIds.push(-1);
           //        mapUtils.setMapSerivceVisibleLayers(thematicServiceId,visibleLayerIds);
           //    },thematicServiceId));
           //}
       },
       _getThematicLayerInfos: function (mapServiceId) {
           return mapUtils.getLayer(mapServiceId).layerInfos;
       }
   });
});