/**
 * Author:  yingxiufeng
 * Project: landtax
 * Date:    2015/8/7 15:01
 * File:    mapPrint
 * (c) Copyright gtmap Corp.2015
 */
define(["dojo/_base/declare",
    'dojo/_base/lang',
    "esri/map",
    "esri/tasks/PrintTemplate",
    "esri/tasks/PrintParameters",
    "esri/tasks/PrintTask"
], function (declare, lang, Map, PrintTemplate, PrintParameters, PrintTask) {
    var _printUrl, _format, _printTpl, _printParam, _printTask;
    var print = declare([], {
        map: null,
        config: {},
        constructor: function (args) {
            declare.safeMixin(this, args);
            _printUrl = this.config.printUrl;
            _format = this.config["format"];
            _printParam = new PrintParameters();
            _printTpl = new PrintTemplate();
            _printTask = new PrintTask(_printUrl);
        },
        printMapHanlder: function () {
            debugger;
            if(_printUrl==null||_printUrl==undefined){
                console.error("print url is not set.");
                return;
            }
            _printTpl.exportOptions = {
                width: 500,
                height: 400,
                dpi: 96
            };
            _printTpl.format = _format;
            _printTpl.layout = "MAP_ONLY";
            _printTpl.preserveScale = false;

            _printParam.template = _printTpl;
            _printParam.map = this.map;

            _printTask.execute(_printParam,lang.hitch(this,_printCompleteHanlder),lang.hitch(this,_printErrorHanlder));

        }

    });
    var _printCompleteHanlder=function(url){
        window.open(url,'_blank');
    };
    var _printErrorHanlder=function(error){
        alert(error.message);
    };
    return print;
});