﻿define(["dojo/_base/declare",'dojo/_base/lang','esri/graphic', 'esri/toolbars/draw','esri/tasks/QueryTask','esri/tasks/query','esri/symbols/SimpleFillSymbol',
	'esri/symbols/SimpleLineSymbol','esri/tasks/GeometryService','esri/tasks/AreasAndLengthsParameters','esri/tasks/LengthsParameters',
    'esri/geometry/Point',
	"dojo/on"], function(declare,lang,Graphic, Draw,
	QueryTask,Query,SimpleFillSymbol,SimpleLineSymbol,GeometryService,AreasAndLengthsParameters,LengthsParameters,Point,on) {

    return declare([],{
        _drawTool:null,
        _anchorPoint:null,
        map:null,
        geometryService:null,
        moduleConfig:null,
        constructor:function(args){
            declare.safeMixin(this,args);
        },
        measureMapHandler:function() {
            this._clearMapGraphics();
            this._drawTool = new Draw(this.map);
            on(this._drawTool, "draw-end", lang.hitch(this,this._measureDrawEnd));
            this._drawTool.activate(Draw.POLYGON);
        },
        measureLineMapHandler:function() {
            this._clearMapGraphics();
            this._drawTool = new Draw(this.map);
            on(this._drawTool, "draw-end", lang.hitch(this,this._measureDrawEnd));
            this._drawTool.activate(Draw.POLYLINE);
        },
        _measureDrawEnd:function(evt){
            var geometry = evt.geometry;
            this._clearMapGraphics();
            var symbol;
            switch (geometry.type) {
                case "polyline":
                    symbol = new SimpleLineSymbol(SimpleLineSymbol.STYLE_DASH, new dojo.Color([255, 0, 0]), 1);
                    debugger;
                    this._anchorPoint=new Point(geometry.paths[0][geometry.paths[0].length-1][0],geometry.paths[0][geometry.paths[0].length-1][1]);
                    break;
                case "polygon":
                    symbol = new SimpleFillSymbol(SimpleFillSymbol.STYLE_SOLID, new SimpleLineSymbol(SimpleLineSymbol.STYLE_DASHDOT, new dojo.Color([255, 0, 0]), 2), new dojo.Color([255, 255, 0, 0.25]));
                    this._anchorPoint = geometry.getExtent().getCenter();
                    break;
            }
            var graphic = new Graphic(geometry, symbol);
            this.map.graphics.add(graphic);
            var areasAndLengthParams = new AreasAndLengthsParameters();
            var lengthsParameters=new LengthsParameters();
            if(this.unit==null||this.unit==='meter'){
                areasAndLengthParams.lengthUnit = GeometryService.UNIT_METER;
                areasAndLengthParams.areaUnit = GeometryService.UNIT_SQUARE_METERS;
                lengthsParameters.lengthUnit = GeometryService.UNIT_METER;
            }else if(this.unit==='km'){
                areasAndLengthParams.lengthUnit = GeometryService.UNIT_KILOMETER;
                areasAndLengthParams.areaUnit = GeometryService.UNIT_SQUARE_KILOMETERS;
                lengthsParameters.lengthUnit = GeometryService.UNIT_KILOMETER;
            }

            on(this.geometryService, 'error', this._measureError);
            debugger;
            if(geometry.type==="polygon")
                this.geometryService.simplify([geometry],lang.hitch(this,this._simplifyHandle,areasAndLengthParams));
            else{
                lengthsParameters.polylines = [geometry];
                this.geometryService.lengths(lengthsParameters,lang.hitch(this,this._measureResultLength),this._measureError);
            }


        },
        _simplifyHandle:function(areasAndLengthParams,simplifiedGeometries){
            areasAndLengthParams.polygons = simplifiedGeometries;
            this.geometryService.areasAndLengths(areasAndLengthParams,lang.hitch(this,this._measureResult),this._measureError);
        },
        _measureResult: function(areasAndLengths){
            var lengthUnitLabel = "";
            var areaUnitLabel="";
            if(this.moduleConfig.unit==null||this.moduleConfig.unit==='meter'){
                lengthUnitLabel="米";
                areaUnitLabel="平方米"
            }else if(this.moduleConfig.unit==='km'){
                lengthUnitLabel="千米";
                areaUnitLabel="平方千米"
            }
            var content = "面积为："+areasAndLengths.areas[0].toFixed(2)+areaUnitLabel+"<br/>长度为："+areasAndLengths.lengths[0].toFixed(2)+lengthUnitLabel;
            if(this._anchorPoint!=null){
                this.map.infoWindow.setTitle("量算");
                var screenPoint = this.map.toScreen(this._anchorPoint);
                this.map.infoWindow.setContent(content);
                this.map.infoWindow.show(this._anchorPoint,this.map.getInfoWindowAnchor(screenPoint));
            }
        },
        _measureResultLength: function(lengths){
            var lengthUnitLabel = "";
            if(this.moduleConfig.unit==null||this.moduleConfig.unit==='meter'){
                lengthUnitLabel="米";
            }else if(this.moduleConfig.unit==='km'){
                lengthUnitLabel="千米";
            }
            var content = "长度为："+lengths.lengths[0].toFixed(2)+lengthUnitLabel;
            if(this._anchorPoint!=null){
                this.map.infoWindow.setTitle("量算");
                var screenPoint = this.map.toScreen(this._anchorPoint);
                this.map.infoWindow.setContent(content);
                this.map.infoWindow.show(this._anchorPoint,this.map.getInfoWindowAnchor(screenPoint));
            }
        },
        _measureError: function(evt){
            alert(evt.error);
        },
        _clearMapGraphics:function(){
            this.map.graphics.clear();
            if (this.map.infoWindow.isShowing)
                this.map.infoWindow.hide();
            if (this._drawTool)
                this._drawTool.deactivate();
        }
    });




});