﻿define(["jquery","dojo/_base/declare", "dojo/_base/lang", "esri/map", "esri/layers/FeatureLayer",
    "esri/Color", "dojo/number", "dojo/dom-style",
    "dijit/popup", "esri/dijit/OverviewMap", "esri/layers/ArcGISTiledMapServiceLayer", "esri/layers/ArcGISDynamicMapServiceLayer",
    'esri/tasks/GeometryService', "dojo/on","mapMeasure","mapPrint","mapIdentify","mapUtils","geometryUtils","mapSearch",'mustache','jqueryUI',
    'taxSearch','zdSearch',"zdIdentify","mapMarker","mapLOC","widgetUtils","mapThematic","dojo/domReady!"
], function ($,declare, lang, Map, FeatureLayer, Color, number, domStyle, dijitPopup, OverviewMap, ArcGISTiledMapServiceLayer, ArcGISDynamicMapServiceLayer,
             GeometryService, on,mapMeasure,mapPrint,mapIdentify,mapUtils,geometryUtils,mapSearch,Mustache,jqueryUI,taxSearch,zdSearch,zdIdentify,mapMarker,mapLOC,widgetUtils,mapThematic) {
    return declare([], {
        geometryService: null,
        map: null,
        options:{
            mapConfig:null,
            geometryServiceConfig:null,
            printServiceConfig:null,
            modulesConfig:null,
            xzqdm:null
        },
        thematicMap:null,
        locMap:null,
        constructor: function (options) {
            declare.safeMixin(this.options,options);
            var mapOptions = {
                logo: false,
                sliderStyle: 'small',
                sliderOrientation: 'vertical',
                sliderPosition: "top-left"
            };
            if (this.options.mapConfig.lods != undefined && this.options.mapConfig.lods.length > 0) {
                mapOptions["lods"] = this.options.mapConfig.lods;
            }
            this.map = new Map("map", mapOptions);
            this.map.xzqdm = this.options.xzqdm;
            mapUtils.setMap(this.map);
            geometryUtils.setMap(this.map);
            on(this.map,'load',lang.hitch(this,this._mapOnload));
            this.geometryService = new GeometryService(this.options.geometryServiceConfig.url);
            var mapLayers = this.options.mapConfig;
            this.addLayers(mapLayers);
        },
        addLayers: function (mapLayers) {
            if (mapLayers.baseLayers != null) {
            }
            if (mapLayers.operationalLayers != null) {
                this._reloadTaxAndThematicMap(mapLayers,this.options.xzqdm);
            }
        },
        loadModules: function (modules,map) {
            console.log("start loading map modules...");
            $.each(modules,function(index,module){
                if(module.id==='mapEdit'){
                    try {
                        var mPath=mapPath+"/modules/"+module.id;
                        var widgetIds=new Array();
                        require([module.id,"dojo/text!"+mPath+"/index.html",
                        "dojo/text!"+mPath+"/infoTpl.html","dojo/text!"+mPath+"/editPanel.html"],function(Main,index,infoTpl,editPanel){

                            //加载模块的html到菜单栏上;
                            var html=Mustache.render(index,module);
                            $(".toollist").append(html);

                            //初始化module
                            var main = new Main(map,module.config,infoTpl);
                            //点击菜单 打开 编辑面板
                            var panelHtml=Mustache.render(editPanel,module.config);

                            $('#editTool').on('click',function(){
                                if (widgetIds.in_array(module.id))return;
                                $("#widget-container").append(panelHtml);
                                $("#widget-container").fadeIn(300);
                                widgetIds.push(module.id);
                                $(".widget-toolbar a").each(function(){
                                    $(this).on('click', function () {
                                        var $widgetBox=$("#editBox");
                                        var $widgetContainer=$("#widget-container");
                                        switch ($(this).data('action'))
                                        {
                                            case 'close'://关闭面板
                                                mapUtils.clearMapGraphics(); //清除地图上的绘制图形
                                                widgetIds.remove_single(module.id);
                                                $widgetBox.remove();
                                                $widgetContainer.fadeOut(220);
                                                break;
                                            case 'collapse'://收缩/展开面板

                                                if ($widgetBox.hasClass('collapsed'))
                                                {
                                                    $widgetBox.removeClass('collapsed');
                                                    $(this).children("i").removeClass('fa-chevron-down');
                                                    $(this).children("i").addClass('fa-chevron-up');
                                                }
                                                else {
                                                    $(this).children("i").removeClass('fa-chevron-up');
                                                    $(this).children("i").addClass('fa-chevron-down');
                                                    $widgetBox.addClass('collapsed');
                                                }
                                                break;
                                            case 'reload'://刷新面板
                                                if ($widgetBox.hasClass('collapsed'))return;
                                                $widgetBox.append('<div class="widget-box-overlay"><i class="' + ace.vars.icon + 'loading-icon fa fa-spinner fa-spin fa-4x white" style="padding:30px;"></i></div>');
                                                $widgetBox.addClass("position-relative");
                                                setTimeout(function () {
                                                    mapUtils.clearMapGraphics(); //清除地图上的绘制图形
                                                    $("#contentPanel")[0].innerHTML = "";
                                                    $widgetBox.find(".widget-box-overlay").remove();
                                                    $widgetBox.removeClass("position-relative");
                                                }, 1500);
                                                break;
                                        }
                                    });

                                });
                                //点击 新增 导入等按钮
                                $(".widget-main p a").each(function(){
                                    $(this).on('click',function(){
                                        var type=$(this).data('action');
                                        //当前选中的图层  从配置中取出该图层的相关配置
                                        var selLayer=$("#layersSelector")[0].value;
                                        var layers = module.config.layers;
                                        var singleConfig = undefined;
                                        for(var i=0;i<layers.length;i++){
                                            var layerAlias = layers[i].layerAlias;
                                            for(var j=0;j<layerAlias.length;j++){
                                                if(layerAlias[j]&&layerAlias[j].layerAlia==selLayer){
                                                    singleConfig=layers[i];
                                                }
                                            }

                                        }
                                        var $contentPanel = $("#contentPanel");
                                        switch (type){
                                            case 'import':
                                                var infoHtml=Mustache.render(infoTpl,{import:true,script:true});
                                                mapUtils.clearMapGraphics();
                                                $contentPanel[0].innerHTML="";//清除已有的内容
                                                $contentPanel.append(infoHtml);
                                                break;
                                            case 'insert':
                                            case 'update':
                                            case 'delete':
                                                if(singleConfig===undefined)alert("异常，请检查配置!");
                                                main.setConfig(singleConfig);
                                                if (!main.activate) {
                                                    main.open(); //如果未打开 则打开此功能
                                                }
                                                main.startEdit(type); //启动地图编辑
                                                break;
                                        }
                                    });
                                });

                            });
                        });
                    } catch (e) {
                        console.error("load module error"+e.info);
                    }
                }

            });
        },
        _mapOnload:function(event){
            var overviewMapDijit = new OverviewMap({
                map: this.map,
                attachTo:'bottom-right'
            });
            overviewMapDijit.startup();

            this.loadModules(this.options.modulesConfig,this.map);



            var measureModuleConfig = mapUtils.getModuleConfig(this.options.modulesConfig,'measure');
            var tmpMeasureTool = new mapMeasure({map:this.map,geometryService:this.geometryService,moduleConfig:measureModuleConfig});
            $('#measureLineTool').click(function(){
                tmpMeasureTool.measureLineMapHandler();
            });
            $('#measureTool').click(function(){
                tmpMeasureTool.measureMapHandler();
            });
            //print
            var printModuleConfig = mapUtils.getModuleConfig(this.options.modulesConfig,'print');
            if(printModuleConfig!=undefined){
                var printMapTool = new mapPrint({map:this.map,config:printModuleConfig});
                $('#printTool').click(function(){
                    printMapTool.printMapHanlder();
                });
            }

            var identifyModuleConfig = mapUtils.getModuleConfig(this.options.modulesConfig,'identify');
            var tmpMapIdentify = new mapIdentify({map:this.map,moduleConfig:identifyModuleConfig});
            $('#infoTool').click(function(){
                tmpMapIdentify.identifyTool();
            });

            var taxMapModuleConfig = mapUtils.getModuleConfig(this.options.modulesConfig,'tax');
            var tmpSyQuery = new taxSearch({map:this.map,moduleConfig:taxMapModuleConfig});
            tmpSyQuery.setMapFilterByRegion(taxMapModuleConfig.mapFilterByRegion);
            tmpSyQuery.setOperationalLayersConfig(this.options.mapConfig.operationalLayers);
            on($('#syQuery'),'click',lang.hitch(this,function(event){
                var queryParam = this._serializeForm($('#taxSearchForm'));
                queryParam.page=1;
                tmpSyQuery.searchTax(queryParam);
            }));

            $('#clearQuery').click(function(){
                $('#queryContent').empty();
                $('#resultCount').empty();
                $('#contentPaginator').empty();
                $('#taxSearchForm')[0].reset();
                mapUtils.clearMapGraphics();
            });


            var tmpZdQuery = new zdSearch({map:this.map,moduleConfig:taxMapModuleConfig});
            tmpZdQuery.setMapFilterByRegion(taxMapModuleConfig.mapFilterByRegion);
            tmpZdQuery.setOperationalLayersConfig(this.options.mapConfig.operationalLayers);

            on($('#zdQueryBtn'),'click',lang.hitch(this,function(event){
                var queryParam = this._serializeForm($('#zdSearchForm'));
                queryParam.page=1;
                tmpZdQuery.searchZd(queryParam);
            }));

            $('#zdClearQuery').click(function(){
                $('#zdQueryContent').empty();
                $('#zdResultCount').empty();
                $('#zdContentPaginator').empty();
                $('#zdSearchForm')[0].reset();
                mapUtils.clearMapGraphics();
            });


            on($('.region'),'click',lang.hitch(this,function(event){

                var tmpXzqdm = $(event.target).attr('data-xzqdm');
                var tmpXzqmc = $(event.target).text();
                $('#currentXzqmc').empty();
                $('#currentXzqmc').append(tmpXzqmc+'<i class="ace-icon fa fa-caret-down"></i>');
                var mapLayers = this.options.mapConfig;
                this._reloadTaxAndThematicMap(mapLayers,tmpXzqdm);
                if(this.thematicMap!=null)
                    this.thematicMap.initialize();
                if(this.locMap!=null)
                    this.locMap.refreshLOC();
            }));



            var tmpZdIdentify= new zdIdentify({map:this.map,moduleConfig:taxMapModuleConfig});
            $('#zdInfoTool').click(function(){
                //tmpMapIdentify.destroyIdentifyTool();
                tmpZdIdentify.identifyTool();
            });
            var mapMarkerModuleConfig = mapUtils.getModuleConfig(this.options.modulesConfig,'marker');
            var tmpMapMarker= new mapMarker({map:this.map,moduleConfig:mapMarkerModuleConfig});
            $('#bookmark').click(function(){
                tmpMapMarker.doMarker();
            });

            this.locMap = new mapLOC({map:this.map,moduleConfig:null});
            on($('#sidebar .nav-tabs>li>a[href="#layer"] '),'click',lang.hitch(this,function(event){
                this.locMap.refreshLOC();
            }));

            /**
             * 宗地定位
             */
            if(djh.length > 0){
                $('#zdDjh').val(djh);
                widgetUtils.changeToTab(1);
                tmpZdQuery.setAutoLocation(true);
                $('#zdQueryBtn').trigger('click');

            }

            if(proid.length > 0){
                $('#proid').val(proid);
                widgetUtils.changeToTab(1);
                tmpZdQuery.setAutoLocation(true);
                $('#zdQueryBtn').trigger('click');
            }
        },
        _serializeForm:function(form){
            var json = {};
            form.find('input, select').each(function(){
                var val
                if (!this.name) return;

                if ('radio' === this.type) {
                    if (json[this.name]) { return; }

                    json[this.name] = this.checked ? this.value : '';
                } else if ('checkbox' === this.type) {
                    val = json[this.name];

                    if (!this.checked) {
                        if (!val) { json[this.name] = ''; }
                    } else {
                        json[this.name] =
                                typeof val === 'string' ? [val, this.value] :
                            $.isArray(val) ? $.merge(val, [this.value]) :
                                this.value;
                    }
                } else {
                    json[this.name] = this.value;
                }
            });
            return json;
        },
        _reloadTaxAndThematicMap:function(mapLayers,xzqdm){
            var taxMapModuleConfig = mapUtils.getModuleConfig(this.options.modulesConfig,'tax');
            var mapLayersConfig=[];
            var mapLayersConfigIds = [];
            var mapSrid=null;
            if(taxMapModuleConfig==null){
                mapLayersConfig=mapLayers.operationalLayers;
            }else{
                if(!taxMapModuleConfig.mapFilterByRegion){  //图层都合并，不按照行政区代码进行分开发布,该部分不完善，后期需完善
                    mapLayersConfig=mapLayers.operationalLayers;
                    this.map.filterByRegion = false;
                }else{
                    //如果各区县数据是分开发布服务，需根据行政区切换地图服务
                    this.map.filterByRegion = true;
                    var tmpMapServiceIds=null;
                    if(xzqdm==null||xzqdm==''){
                        tmpMapServiceIds = taxMapModuleConfig.default.mapServiceIds;
                        mapSrid = taxMapModuleConfig.default.srid;
                    }else{
                        tmpMapServiceIds =  taxMapModuleConfig[xzqdm].mapServiceIds;
                        mapSrid = taxMapModuleConfig[xzqdm].srid;
                    }
                    var mapLayersConfigSize = mapLayersConfig.length;
                    for (var i in mapLayers.operationalLayers) {
                        var tmpLayerConfig = mapLayers.operationalLayers[i];
                        var tmpLayerId = tmpLayerConfig.id;
                        if(tmpMapServiceIds.indexOf(tmpLayerId)>-1){
                            mapLayersConfig[mapLayersConfigSize+tmpMapServiceIds.indexOf(tmpLayerId)] =tmpLayerConfig;
                        }
                    }
                    this.map.xzqdm=xzqdm;
                    mapLayersConfigIds = mapLayersConfigIds.concat(tmpMapServiceIds);
                }
            }


            //按行政区加载专题地图
            var thematicMapModuleConfig = mapUtils.getModuleConfig(this.options.modulesConfig,'thematicMap');
            if(thematicMapModuleConfig!=null&&this.thematicMap==null){
                this.thematicMap = new mapThematic({map:this.map,moduleConfig:thematicMapModuleConfig});
            }
            if(thematicMapModuleConfig!=null&&thematicMapModuleConfig.mapFilterByRegion){
                var tmpMapServiceId=null;
                if(xzqdm==null||xzqdm==''){
                    tmpMapServiceId = thematicMapModuleConfig.default.thematicSerivceId;
                    mapSrid = thematicMapModuleConfig.default.srid;

                }else{
                    tmpMapServiceId =  thematicMapModuleConfig[xzqdm].thematicSerivceId;
                    mapSrid = thematicMapModuleConfig[xzqdm].srid;
                }
                var thematicLayerOnload = function(thematicMap,event){
                    thematicMap.initialize();
                };
                if($.inArray(tmpMapServiceId,mapLayersConfigIds)==-1){
                    var mapLayersConfigSize = mapLayersConfig.length;
                    for (var i in mapLayers.operationalLayers) {
                        var tmpLayerConfig = mapLayers.operationalLayers[i];
                        var tmpLayerId = tmpLayerConfig.id;
                        if(tmpMapServiceId==tmpLayerId){
                            tmpLayerConfig.loadedCallback = thematicLayerOnload;
                            tmpLayerConfig.loadedCallbackParams = this.thematicMap;
                            mapLayersConfig[mapLayersConfigSize]=tmpLayerConfig;
                            mapLayersConfigIds.push(tmpMapServiceId);
                            break;
                        }
                    }
                }else{
                    mapLayersConfig[$.inArray(tmpMapServiceId,mapLayersConfigIds)].loadedCallback = thematicLayerOnload;
                    mapLayersConfig[$.inArray(tmpMapServiceId,mapLayersConfigIds)].loadedCallbackParams = this.thematicMap;
                }

                $('#zttList').css('display','block');

            }

            mapUtils.reloadMapLayers(mapSrid,mapLayersConfig);
        }
    });
});


