﻿define(["jquery","dojo/_base/declare",
    "dojo/_base/lang","dojo/topic","mapInit","dojo/domReady!"
], function($,declare,lang,topic,mapInit) {
   return declare([],{
       url:null,
       _mapConfig:null,
       _geometryServiceConfig:null,
       _printServiceConfig:null,
       _modulesConfig:null,
       _mapInit:null,
       constructor:function(options){
           declare.safeMixin(this,options);
           $.getJSON(this.url,lang.hitch(this,function(result){
               var xzqdm = $('#xzqdm').val();
               this._mapConfig = result.map;
               this._geometryServiceConfig = result.geometryService;
               this._printServiceConfig = result.printService;
               this._modulesConfig = result.modules;
               this._mapInit = new mapInit({mapConfig:this._mapConfig,geometryServiceConfig:this._geometryServiceConfig,printServiceConfig:this._printServiceConfig,
                   modulesConfig:this._modulesConfig,xzqdm:xzqdm});
           }));
       },
       addMsgListener:function(){
           $msg=$("#message-container");
           var timeOut;
           $msg.on("click", ".close", function (evt) {
               hideMsg();
               evt.stopPropagation();
               return false;
           });
           topic.subscribe("module/message", function (evt) {
               $msg.fadeIn(220);
               $msg.find('.message').text(evt.message);
               clearTimeout(timeOut);
               timeOut = setTimeout(hideMsg, 5000);
           });
       }
   });

    var $msg;
    function hideMsg(){
        $msg.slideUp(320);
        $msg.find(".message").text("");
    }
});