<#assign jsContent>
    <@com.script name="static/js/tax/grid.js"></@com.script>
    <@com.script name="static/js/public.js"></@com.script>
    <@com.script name="static/thirdparty/bootstrap/js/bootstrap-typeahead.min.js"></@com.script>
</#assign>

<#assign cssContent>
    <@com.style name="static/css/pageForm.css"></@com.style>
    <@com.style name="static/thirdparty/ace/css/font-awesome.min.css"></@com.style>
    <@com.style name="static/thirdparty/ace/css/ace-fonts.css"></@com.style>
    <@com.style name="static/thirdparty/ace/css/ace.min.css"></@com.style>
    <@com.style name="static/thirdparty/ace/css/ace-skins.min.css"></@com.style>
    <@com.style name="static/thirdparty/ace/css/ace-rtl.min.css"></@com.style>
</#assign>

<@com.html title="${reportName!}" import="jquery,jqueryEasyUI,multiselect,jqgrid,bootstrap,bootbox,datetimepicker" js=jsContent css=cssContent >
    <div class="main-container" id="main-container">
        <script type="text/javascript">
            try {
                ace.settings.check('main-container', 'fixed')
            } catch (e) {
            }
        </script>

        <div class="main-container-inner" id="basetj">
            <div class="page-content">
                <div class="row">
                    <div class="widget-box transparent">
                        <div class="widget-body">
                            <div class="widget-main">
                                <div class="row">
                                    <div class="col-xs-12">
                                        <div class="col-xs-12">
                                            <div class="pull-left">
                                                <form id="queryForm">
                                                    <#if headPageFile?? && headPageFile != "">
                                                        <#include "../${headPageFile!}" />
                                                    </#if>
                                                    <div class="pull-left col-sm-12" style="margin-top: 5px">
                                                        <fieldset class="searchInput form-inline">
                                                            <#if headPageFile?? && headPageFile != "">
                                                            <button type="button" class="btn btn-info btn-sm" id="btnQuery" >
                                                                <i class="ace-icon fa fa-search bigger-110"></i>
                                                                查询
                                                            </button>
                                                            </#if>
                                                            <#if needExport?? || autoExport??>
                                                            <button type="button" class="btn btn-success btn-sm" id="btnExportExcel">
                                                                <i class="ace-icon glyphicon glyphicon-share bigger-110"></i>
                                                                导出
                                                            </button>
                                                            </#if>
                                                            <button type="button" class="btn btn-success btn-sm" id="btnDoZdbg">
                                                                <i class="ace-icon glyphicon glyphicon-share bigger-110"></i>
                                                                宗地数据更新
                                                            </button>


                                                        </fieldset>
                                                    </div>
                                                </form>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <p></p>
                                <row>
                                    <div class="col-xs-12" >
                                        <div id="gGrid" data-definition="${base}/static/json/${colJson}.json">
                                            <table id="grid-table"></table>
                                            <div id="grid-pager"></div>
                                        </div>
                                    </div>
                                </row>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="modal fade" id="doZdbgModal" tabindex="-1" role="dialog"
         aria-labelledby="myModalLabel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header" style="background: #f7f7f7;background-image:linear-gradient(to bottom, #fff 0, #eee 100%);background-repeat:repeat-x;">
                    <button type="button" class="close"
                            data-dismiss="modal" aria-hidden="true">
                        &times;
                    </button>
                    <h4 class="modal-title" id="myModalLabel">
                        <i class="fa fa-pencil-square" style="color: #669fc7;">请选择宗地数据更新终止日期：</i>
                    </h4>
                </div>
                <div class="modal-body alert alert-info" style="margin: 10px;">
                    <#include "zdbgGjcx.ftl"/>
                    <br/>
                    <br/>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-default"
                            data-dismiss="modal">取消
                    </button>
                    <button type="button" class="btn btn-primary" id="btnOk" onclick="">
                        确定
                    </button>
                </div>
            </div>
        </div>
    </div>

    <#include "../jdt/jdt.ftl"/>

    <#assign jsContent>
        <@com.script name="static/thirdparty/ace/js/ace-extra.min.js"></@com.script>
        <@com.script name="static/thirdparty/ace/js/ace-elements.min.js"></@com.script>
        <@com.script name="static/thirdparty/ace/js/ace.min.js"></@com.script>
    </#assign>
</@com.html>

<script type="text/javascript">
    var grid;

//    window.onbeforeunload = function () {
//        if(event.clientX > document.body.clientWidth && event.clientY < 0 || event.altKey) {
//            window.event.returnValue = "确定要关闭页吗？";
//        } else {
//            window.event.returnValue = "确定要刷新页吗？";
//        }
//    }

    $(function () {
        bootbox.setDefaults({
            locale: "zh_CN"
        });

        var scrollHeight = 8;
        var minRows = 5;
        var rowHeigth = 33;

        var drawHeight = jQuery(window).height() - 140 - $('#basetj')[0].clientHeight;
        var drawRowNum = Math.floor(drawHeight / rowHeigth);
        drawHeight = drawRowNum * rowHeigth + scrollHeight;

        if (drawHeight < minRows * rowHeigth) {
            drawHeight = minRows * rowHeigth + scrollHeight;
            drawRowNum = minRows;
        }
        grid = $('#gGrid').gGrid({
            rownumbers: true,
            rownumWidth: 40,
            footerrow: false,
            autoHeight: false,
            multiselect: false,
            height: drawHeight,
            rowNum: drawRowNum,
            caption: "${reportName!}",
            url:'/landtax/zdbg/zdbgJson?tag=${tag!}',
            gridComplete: function() {
                //在gridComplete调用行合并方法
                $('#gGrid').mergeRowCell();
            }
        });

        $('#btnExportExcel').click(function () {
            if ("${needExport!}" != null && "${needExport!}" != "") {
                exportExcel(1);
            } else {
                exportExcel(2);
            }
        });

        $(":input").focus(
                function(){
                    if(this.value=="" ||this.value==null){this.placeholder=""};
                }
        );

        $(":input").blur(
                function(){
                    if(this.value==""||this.value==null){this.placeholder=(this.getAttribute("aliasName") == null) ? "" : this.getAttribute("aliasName");};
                }
        );
        initializeSelect($);
    });

    $('#btnQuery').click(function () {
        var params = $('#queryForm').serializeJson();
        queryCommand(params);
    });

    $('#btnDoZdbg').on("click", function() {
        $.ajax({
            type: 'post',
            async: false,
            url: "${base}/zdbg/getZdbgStartRq",
            dataType: 'json',
            success: function (date) {
                if (date.msg.length > 0) {
                    var startRq = new Date(date.msg);
                    $('#STARTRQ').datetimepicker('setDate', startRq);
                    $('#STARTRQ').change();
                }

                $("#doZdbgModal").modal("show");
            },
            error:function (data, status, e){
                alert("error");
            }
        });
    });

    $('#btnOk').click(function () {
        var startRq, endRq;
        endRq = $("#ENDRQ").val();

        if (endRq.length == 0) {
            bootbox.alert("已更新至最新！");
            return;
        }
        if (endRq.length == 0) {
            bootbox.alert("请选择更新终止日期！");
            return;
        }
        $("#doZdbgModal").modal("hide");

        doZdbg(startRq, endRq);
    });

    function queryCommand (params) {
        $('#gGrid').refreshGrid(params);
    }

    function exportExcel(param){
        var queryParam = $('#queryForm').serializeJson();
        var gridOptions = $('#gGrid').getOptions();
        var actionURL;
        if (param == 1) {
            actionURL = '${base}/tj/exportExcelTj?tag=${tag}&customParams=${customParams!}&query=' + queryParam["query"];
        } else {
            actionURL = '${base}/tj/exportExcelTjEx?tag=${tag}&customParams=${customParams!}&query=' + queryParam["query"] + '&gridOptions=' + JSON.stringify(gridOptions);
        }
        window.open(actionURL,"exportWin", "left=50,top=50,height=600px,width=750px,resizable=yes,status=yes,toolbar=no, menubar=no,location=no");
    }

    // 根据选择日期更新
    function doZdbg(startRq, endRq) {
        bootbox.confirm("是否确定将宗地数据更新至" + endRq + "?", function(result) {
            if(result){
                showJdt($, true);
                $.ajax({
                    type: 'post',
                    url: "${base}/zdbg/doZdbg",
                    data:{startDate: startRq, endDate: endRq},
                    dataType: 'json',
                    success: function (date) {
                        showJdt($, false);
                        bootbox.alert("宗地数据更新完成！", function () {
                            reloadWindow();
                        });
                    }
                });
            }
        });
    }

    function turnToUrl(id, baseUrl, paramNames, paramValues, paramOperators) {
        paramNames = paramNames.split(",");
        paramValues = paramValues.split(",");

        if (paramOperators == null)
            paramOperators = '';
        paramOperators = paramOperators.split(",");

        var paramCnt = paramNames.length;
        var paramName, paramValue, paramOperator, paramStr, i;
        var valueJson = {};
        var operatorJson = {};
        var hasCustomParams = false;
        id = (id.split("="))[1];
        for (i = 0; i < paramCnt; i++) {
            paramName = paramNames[i].trim();
            paramValue = grid.jqGrid('getRowData', id)[paramValues[i].trim()];
            if (paramValue == null)
                paramValue = paramValues[i].trim();

            if (i < paramOperators.length) {
                paramOperator = paramOperators[i].trim();
            } else {
                paramOperator = '';
            }
            if (paramOperator == '') {
                if (paramStr != '')
                    paramStr += '&';
                paramStr += paramName + '=' + paramValue;
            } else {
                hasCustomParams = true;
                valueJson[paramName] = paramValue;
                operatorJson[paramName] = paramOperators[i];
            }
        }

        if (hasCustomParams) {
            if (paramStr != '')
                paramStr += '&';
            paramStr += 'customParams=' + '[' + JSON.stringify(valueJson) + ',' + JSON.stringify(operatorJson) + ']';
        }
        window.open("${base!}/" + baseUrl + "?" + paramStr, "")
    }

</script>