<#assign jsContent>

    <@com.script name="static/js/tax/grid.js"></@com.script>
    <@com.script name="static/js/public.js"></@com.script>
    <@com.script name="static/js/tax/swDjSy-save-validate.js"></@com.script>
    <@com.script name="static/thirdparty/bootstrap/js/bootstrap-typeahead.min.js"></@com.script>


</#assign>
<#assign cssContent>
    <@com.style name="static/css/pageForm.css"></@com.style>
    <@com.style name="static/thirdparty/ace/css/font-awesome.min.css"></@com.style>
    <@com.style name="static/thirdparty/ace/css/ace-fonts.css"></@com.style>
    <@com.style name="static/thirdparty/ace/css/ace.min.css"></@com.style>
    <@com.style name="static/thirdparty/ace/css/ace-skins.min.css"></@com.style>
    <@com.style name="static/thirdparty/ace/css/ace-rtl.min.css"></@com.style>

</#assign>
<@com.html title="数据挂接" import="jquery,jqgrid,bootstrap,bootbox,datetimepicker" js=jsContent css=cssContent >
<div class="main-container" id="main-container">
    <script type="text/javascript">
        try {
            ace.settings.check('main-container', 'fixed')
        } catch (e) {
        }
    </script>
    <div class="page-content no-padding-bottom">
    <div class="row">
        <div class="widget-box transparent">
            <div class="widget-body">
                <div class="widget-main">
                    <div class="row">
                        <div class="col-sm-12 " id="searchPanel" style="color:#888;">
                            <form id="advancedQueryForm">
                                <div >
                                    <div class="col-xs-3 no-padding-left">
                                        <label>挂接方式</label>
                                        <select class="ace" name="gjfs" id="gjfs" >
                                            <option value="1"> 自动挂接</option>
                                            <option value="2">人工挂接</option>
                                            <option value="0">取消挂接</option>
                                        </select>
                                    </div>
                                    <div class="col-xs-9 no-padding-left">
                                        <label>税源类型</label>
                                        <select class="ace" name="sylx" id="sylx" >
                                            <option value="1"> 土地税</option>
                                            <option value="2">房产税</option>
                                            <option value="3">纳税人</option>
                                        </select>
                                    </div>
                                </div>
                                <div id="inputQuery" style="display: none">
                                    <div class="col-xs-3 no-padding-left">
                                        <div>纳税人名称(权利人名称)</div>
                                        <input type="text" placeholder="" name="mc" id="mc"
                                               class="form-control input-mask-date" aliasName="纳税人名称(权利人名称)">
                                    </div>
                                    <div class="col-xs-3 no-padding-left">
                                        <div>土地证号</div>
                                        <input type="text" placeholder="" name="zh" id="zh"
                                               class="form-control input-mask-date" aliasName="土地证号">
                                    </div>
                                    <div class="col-xs-3 no-padding-left">
                                        <div>土地坐落</div>
                                        <input type="text" placeholder="" name="tdzl" id="tdzl"
                                               class="form-control input-mask-date" aliasName="土地坐落">
                                    </div>
                                    <div class="col-xs-3 no-padding-left" id="glbmDiv">
                                        <div>管理编码</div>
                                        <input type="text" placeholder="" name="glbm" id="glbm"
                                               class="form-control input-mask-date" aliasName="管理编码">
                                    </div>
                                </div>
                                <div id="checkQuery" style="display: inline">
                                    <div class="col-xs-3 no-padding-left">
                                        <div>　</div>
                                        <input type="checkbox" name="mc" id="mcCheck" value="1" class="ace" checked="true">
                                        <span class="lbl" onclick="checkBoxClick('mcCheck')">纳税人名称(权利人名称)</span>
                                    </div>
                                    <div class="col-xs-3 no-padding-left">
                                        <div>　</div>
                                        <input type="checkbox" name="zh" id="zhCheck" value="1" class="ace">
                                        <span class="lbl" onclick="checkBoxClick('zhCheck')">土地使用号(土地证号)</span>
                                    </div>
                                    <div class="col-xs-3 no-padding-left">
                                        <div>　</div>
                                        <input type="checkbox" name="tdzl" id="tdzlCheck" value="1" class="ace">
                                        <span class="lbl" onclick="checkBoxClick('tdzlCheck')">土地坐落</span>
                                    </div>
                                    <div class="col-xs-3 no-padding-left">
                                    </div>
                                </div>
                                <div class="col-xs-6 no-padding-left">
                                    <div>　</div>
                                    <input type="radio"  class="ace" value="1" name="syzd" id="issy"/>
                                    <span class="lbl" onclick="radioClick('issy')">查询税源数据</span>
                                    <input type="radio"  value="1" class="ace" name="syzd" id="iszd" checked/>
                                    <span class="lbl" onclick="radioClick('iszd')">查询国土数据</span>
                                    <label id="showMsg"></label>

                                    <button class="btn btn-info btn-sm" id="btnAdvancedQuery" type="button">
                                        <i class="ace-icon fa fa-search bigger-110"></i>
                                        查询
                                    </button>
                                    <button class="btn btn-info btn-sm" id="btnClearQuery" type="button">
                                        <i class="ace-icon fa fa-search bigger-110"></i>
                                        清空查询条件
                                    </button>
                                </div>
                                <div class="col-xs-3 no-padding-left" >

                                </div>
                                <div class="col-xs-3 no-padding-left" >
                                    <div>　</div>
                                    <button class="btn btn-danger btn-sm pull-right" id="qxgj" type="button" style="display: none">
                                        <i class="ace-icon glyphicon glyphicon-remove bigger-110"></i>
                                        取消挂接
                                    </button>
                                    <button class="btn btn-danger btn-sm pull-right" id="qrwfgj" type="button" style="display: inline">
                                        <i class="ace-icon glyphicon glyphicon-remove bigger-110"></i>
                                        确认无法挂接
                                    </button>
                                    <button class="btn btn-success btn-sm pull-right" id="qrgj" type="button" style="display: inline">
                                        <i class="ace-icon fa fa-external-link bigger-110"></i>
                                        确认挂接
                                    </button>
                                </div>
                            </form>
                        </div>
                    </div>
                    <p></p>
                    <row>
                        <div class="col-xs-12 no-padding-left">
                            <div id="syGrid" data-definition="${base}/static/json/sjgj/rggjSytz.json" style="height: 350px;overflow-y:auto;overflow-x:auto;">
                                <table id="grid-table-sy"></table>
                                <div id="grid-pager-sy"></div>
                            </div>
                        </div>
                    </row>
                    <row>
                        <div class="col-xs-12 no-padding-left">
                            <div id="zdGrid" data-definition="${base}/static/json/sjgj/rggjZdtz.json" style="height:350px;overflow-y:auto;overflow-x:auto;">
                                <table id="grid-table-zd" ></table>
                                <div id="grid-pager-zd"></div>
                            </div>
                        </div>
                    </row>
                </div>
            </div>
        </div>
    </div>

    </div>
  </div>
<script>
    $(function(){
        bootbox.setDefaults({
            locale: "zh_CN"
        });


        var syGrid = $('#syGrid').gGrid({
            grid_selector:'#grid-table-sy',
            rownumbers: true,
            multiselect: false,
            rownumWidth: 40,
            caption:'税源数据',
            pager: '#grid-pager-sy',
            url: "/landtax/sjgj/syJson",
            gridComplete: function () {
                // 选中第一行
                $(this).jqGrid('setSelection', "1");

                if ($('#sylx').val() == '1') {
                    $(this).jqGrid('showCol','swDjTd.tdsyzh');
                    $(this).jqGrid('showCol','swDjTd.tdzl');
                    $(this).jqGrid('showCol','swDjTd.scmj');
                    $(this).jqGrid('showCol','swDjTd.tdId');

                    $(this).jqGrid('hideCol','swDjFc.fczh');
                    $(this).jqGrid('hideCol','swDjFc.fczl');
                    $(this).jqGrid('hideCol','swDjFc.fcmj');
                    $(this).jqGrid('hideCol','swDjFc.fcId');
                } else if ($('#sylx').val() == '2') {
                    $(this).jqGrid('hideCol','swDjTd.tdsyzh');
                    $(this).jqGrid('hideCol','swDjTd.tdzl');
                    $(this).jqGrid('hideCol','swDjTd.scmj');
                    $(this).jqGrid('hideCol','swDjTd.tdId');

                    $(this).jqGrid('showCol','swDjFc.fczh');
                    $(this).jqGrid('showCol','swDjFc.fczl');
                    $(this).jqGrid('showCol','swDjFc.fcmj');
                    $(this).jqGrid('showCol','swDjFc.fcId');
                } else {
                    $(this).jqGrid('hideCol','swDjTd.tdsyzh');
                    $(this).jqGrid('hideCol','swDjTd.tdzl');
                    $(this).jqGrid('hideCol','swDjTd.scmj');
                    $(this).jqGrid('hideCol','swDjTd.tdId');

                    $(this).jqGrid('hideCol','swDjFc.fczh');
                    $(this).jqGrid('hideCol','swDjFc.fczl');
                    $(this).jqGrid('hideCol','swDjFc.fcmj');
                    $(this).jqGrid('hideCol','swDjFc.fcId');
                }
            },
            onSelectRow: function(id){
                //获取选择税源信息
                if ($('#gjfs').val() == '1') {
                    var params = getQueryParams(syGrid);
                    var syId = getSelectedData(syGrid, "syId");
                    if (syId == '' || syId == null) {

                    } else {
                        zdGrid.jqGrid('setGridParam', {
                            postData: params,
                            page: 1
                        }).trigger("reloadGrid");
                    }
                }
            }

        });
        var zdGrid = $('#zdGrid').gGrid({
            grid_selector:'#grid-table-zd',
            rownumbers: true,
            multiselect: false,
            rownumWidth: 40,
            caption:'国土宗地数据',
            pager: '#grid-pager-zd',
            url: "/landtax/sjgj/zdJson",
            gridComplete: function () {
                $(this).jqGrid('setSelection', "1");
            }
        });

        // 挂接类型的chang事件
        $('#gjfs').on('change', function () {
            var gjfs = $('#gjfs').val();

            $('#glbmDiv')[0].style.display = 'none';
            $('#glbm').val('');

            if (gjfs == '1') {
                $('#qrgj')[0].style.display = 'inline';
                $('#qrwfgj')[0].style.display = 'inline';
                $('#qxgj')[0].style.display = 'none';

                $('#inputQuery')[0].style.display = 'none';
                $('#checkQuery')[0].style.display = 'inline';

            } else if (gjfs == '2') {
                $('#qrgj')[0].style.display = 'inline';
                $('#qrwfgj')[0].style.display = 'inline';
                $('#qxgj')[0].style.display = 'none';

                $('#inputQuery')[0].style.display = 'inline';
                $('#checkQuery')[0].style.display = 'none';

                if ($('#sylx').val() == '3') {
                    $('#glbmDiv')[0].style.display = 'inline';
                }
            } else if (gjfs == '0') {
                $('#qrgj')[0].style.display = 'none';
                $('#qrwfgj')[0].style.display = 'none';
                $('#qxgj')[0].style.display = 'inline';

                $('#inputQuery')[0].style.display = 'inline';
                $('#checkQuery')[0].style.display = 'none';
            }

            var params = getQueryParams(syGrid);
            syGrid.jqGrid('setGridParam', {
                postData: params,
                page: 1
            }).trigger("reloadGrid");
        });

        $('#sylx').on('change', function () {
            var sylx = $('#sylx').val();

            $('#glbmDiv')[0].style.display = 'none';
            $('#glbm').val('');

            if (sylx == '3') {
                if ($('#sylx').val() == '3') {
                    $('#glbmDiv')[0].style.display = 'inline';
                }
            }

            var params = getQueryParams(syGrid);
            syGrid.jqGrid('setGridParam', {
                postData: params,
                page: 1
            }).trigger("reloadGrid");
        });

        $('#btnAdvancedQuery').click(function(){
            var params = getQueryParams(syGrid);

            if($('#issy').is(':checked')){
                syGrid.jqGrid('setGridParam', {
                    postData: params,
                    page: 1
                }).trigger("reloadGrid");

            } else if($('#iszd').is(':checked')) {
                //获取选择税源信息
                var syId = getSelectedData(syGrid, "syId");
                if (syId == '' || syId == null) {
                    bootbox.alert("请选择一条税源数据");
                } else {
                    zdGrid.jqGrid('setGridParam', {
                        postData: params,
                        page: 1
                    }).trigger("reloadGrid");
                }
            }
        });

        $('#btnClearQuery').click(function(){
            $('#mcCheck')[0].checked = false;
            $('#tdzlCheck')[0].checked = false;
            $('#zhCheck')[0].checked = false;

            $('#mc').val('');
            $('#tdzl').val('');
            $('#zh').val('');
        });

        $('#qrgj').click(function(){
            var gjfs = $('#gjfs').val();
            //获取选择的宗地信息
            var djh = getSelectedData(zdGrid,"djh");
            //获取选择税源信息
            var syId = getSelectedData(syGrid,"syId");

            if(syId=='' || syId==null){
                bootbox.alert("请选择需要挂接的税源");
            } else if(djh=='' || djh ==null){
                bootbox.alert("请选择需要挂接的宗地");
            } else{
                //开始挂接
                bootbox.confirm("即将挂接选中的税源数据跟国土宗地数据，是否继续?", function(result) {
                    if(result){
                        $.ajax({
                            type: 'post',
                            url: "${base}/sjgj/doGj",
                            data:{syId:syId, djh:djh, gjfs: gjfs, sylx: $('#sylx').val()},
                            dataType: 'json',
                            success: function (data) {
                                if ($('#sylx').val() == '3') {
                                    bootbox.alert(data.msg, function () {
                                        zdGrid.trigger("reloadGrid");
                                    });
                                } else {
                                    bootbox.alert(data.msg, function () {
                                        syGrid.trigger("reloadGrid");
                                    });
                                }
                            }
                        });

                    }
                });
            }
        });

        $('#qxgj').click(function(){
            var gjfs = $('#gjfs').val();
            //获取选择的宗地信息
            var djh = getSelectedData(syGrid,"djh");
            //获取选择税源信息
            var syId = getSelectedData(syGrid,"syId");

            if(syId=='' || syId==null){
                bootbox.alert("请选择需要取消挂接的税源");
            } else{
                //开始挂接
                bootbox.confirm("即将取消选中税源数据与国土宗地数据的挂接关系，是否继续?", function(result) {
                    if(result){
                        $.ajax({
                            type: 'post',
                            url: "${base}/sjgj/doGj",
                            data:{syId:syId, djh:djh, gjfs: gjfs},
                            dataType: 'json',
                            success: function (data) {
                                bootbox.alert(data.msg,function(){
                                    var params = getQueryParams(syGrid);
                                    syGrid.trigger("reloadGrid");
                                    zdGrid.jqGrid('setGridParam', {
                                        postData: params,
                                        page: 1
                                    }).trigger("reloadGrid");
                                });
                            }
                        });

                    }
                });
            }
        });

        $('#qrwfgj').click(function(){
            var gjfs = "4";
            //获取选择税源信息
            var syId = getSelectedData(syGrid,"syId");

            if(syId=='' || syId==null){
                bootbox.alert("请选择无法挂接的税源");
            } else{
                //开始挂接
                bootbox.confirm("即将标记选中税源数据为无法挂接，是否继续?", function(result) {
                    if(result){
                        $.ajax({
                            type: 'post',
                            url: "${base}/sjgj/doGj",
                            data:{syId:syId, gjfs: gjfs},
                            dataType: 'json',
                            success: function (data) {
                                bootbox.alert(data.msg,function(){
                                    var params = getQueryParams(syGrid);
                                    syGrid.trigger("reloadGrid");
                                    zdGrid.jqGrid('setGridParam', {
                                        postData: params,
                                        page: 1
                                    }).trigger("reloadGrid");
                                });
                            }
                        });

                    }
                });
            }
        });
    })
    function getSelectedData(grid,field) {
        var text="";
        var id =grid.jqGrid('getGridParam','selrow');
        var rowData = grid.jqGrid('getRowData', id);
        if (rowData[field]!=""){
            text = rowData[field];
        }
        return text;
    };

    function getQueryParams(syGrid){
        var params;
        var gjfs = $('#gjfs').val();
        if (gjfs == '1') {
            params = $('#checkQuery').serializeObject();
            if($('#iszd').is(':checked')) {
                if (params["mc"] == '1') {
                    params["mc"] = getSelectedData(syGrid, "swDjJbb.nsrmc");
                }
                if (params["tdzl"] == '1') {
                    params["tdzl"] = getSelectedData(syGrid, "swDjTd.tdzl");
                }
                if (params["zh"] == '1') {
                    params["zh"] = getSelectedData(syGrid, "swDjTd.tdzh");
                }
            }
        } else if (gjfs == '2') {
            params = $('#inputQuery').serializeObject();
        } else if (gjfs == '0') {
            params = $('#inputQuery').serializeObject();
            params["djh"] = getSelectedData(syGrid, "zd.djh");
        }
        params["gjfs"] = gjfs;
        params["sylx"] = $('#sylx').val();

        return params;
    }

    function checkBoxClick(id) {
        var cb = $('#' + id)[0];
        if (cb.checked == true) {
            cb.checked = false;
        } else {
            cb.checked = true;
        }
    }
    function radioClick(id) {
        var radio = $('#' + id)[0];
        radio.checked = true;
    }
</script>

    <#assign jsContent>
        <@com.script name="static/thirdparty/ace/js/ace-extra.min.js"></@com.script>
        <@com.script name="static/thirdparty/ace/js/ace-elements.min.js"></@com.script>
        <@com.script name="static/thirdparty/ace/js/ace.min.js"></@com.script>

    </#assign>
</@com.html>