<#assign jsContent>

</#assign>
<#assign cssContent>
    <@com.style name="static/css/pageForm.css"></@com.style>
    <@com.style name="static/thirdparty/ace/css/font-awesome.min.css"></@com.style>
    <@com.style name="static/thirdparty/ace/css/ace-fonts.css"></@com.style>
    <@com.style name="static/thirdparty/ace/css/ace.min.css"></@com.style>
    <@com.style name="static/thirdparty/ace/css/ace-skins.min.css"></@com.style>
    <@com.style name="static/thirdparty/ace/css/ace-rtl.min.css"></@com.style>
    <@com.script name="static/js/tax/swDjSy-save-validate.js"></@com.script>
    <@com.script name="static/thirdparty/bootstrap/js/bootstrap-typeahead.min.js"></@com.script>
    <@com.script name="static/js/public.js"></@com.script>
</#assign>
<@com.html title="税源列表" import="jquery,bootstrap,bootbox,datetimepicker" js=jsContent css=cssContent >
<div class="main-container" id="main-container">
    <script type="text/javascript">
        try {
            ace.settings.check('main-container', 'fixed')
        } catch (e) {
        }
    </script>

    <div class="main-container-inner" id="syxx">
        <div id="pageContent" style="width: 1100px">
            <div id="pageTitle">
            ${djh!}宗地税源列表
            </div>
            <table width="100%" class="table table-striped table-bordered table-hover">
                <thead>
                <tr>
                    <th>管理编码</th>
                    <th>土地使用号</th>
                    <th>纳税人名称</th>
                    <th>权利人名称</th>
                    <th>土地坐落</th>
                    <th>第三方提供面积</th>
                </tr>
                </thead>
                <tbody>
                    <#list syxx as item>
                    <tr>
                        <td>${item.glbm!}</td>
                        <td><a href="${base}/ts/taxMap?tdId=${item.tdId!}&fcId=${item.fcId!}&djh=${item.djh!}&noSave=true">${item.dbh!}</a></td>
                        <td>${item.nsrmc!}</td>
                        <td>${item.qlrmc!}</td>
                        <td>${item.tdzl!}</td>
                        <td>${item.scmj!}</td>
                    </tr>
                    </#list>

                </tbody>

            </table>
        </div>

    </div>
    <div class="main-container-inner" id="updateSy" style="display:none;">

    </div>
</div>
    <#assign jsContent>
        <@com.script name="static/thirdparty/ace/js/ace-extra.min.js"></@com.script>
        <@com.script name="static/thirdparty/ace/js/ace-elements.min.js"></@com.script>
        <@com.script name="static/thirdparty/ace/js/ace.min.js"></@com.script>
    </#assign>

<script type="text/javascript">
    $(function(){
        bootbox.setDefaults({
            locale: "zh_CN"
        });
    })
    function updateRec(tdId,fcId,djh){
        var userId = '${userId!}';
        if(userId=='0'){
            $.ajax({
                type: 'post',
                url: "${base}/ts/taxMap",
                data:{tdId:tdId,fcId:fcId,djh:djh},
                dataType: 'text',
                success: function (data) {
                    $('#updateSy').empty();
                    $('#updateSy').append(data);
                    $("#syxx").toggle(300);
                    $("#updateSy").toggle(300);
                },
                error: function (XmlHttpRequest, textStatus, errorThrown) {
                    alert('读取税源信息有误！');
                }
            });
        }else{
            alert("请联系管理员");
        }

        /*
        alert("功能暂无下放");
        */

    }
    function deleteRec(syId){
        var userId = '${userId!}';
        if(userId=='0'){
            bootbox.confirm("确认删除吗?", function(result) {
                if(result){
                    $.ajax({
                        type: 'post',
                        url: "${base}/ts/delSwDjSyNoWorkflow?syId="+syId,
                        dataType: 'json',
                        success: function (data) {
                            if(data=='1'){
                                bootbox.alert("删除成功",function(){
                                    window.location.reload();
                                });

                            }else{
                                bootbox.alert("删除失败");
                            }
                        }
                    });
                }
            });
        }else{
            alert("请联系管理员");
        }


    /*
   alert("功能暂无下放")
*/
}

function goback(){
    bootbox.confirm("数据未保存，确认返回吗?", function(result) {
        if(result){
            $("#syxx").toggle(300);
            $("#updateSy").toggle(300);
        }
    });

};

function goSave(){
    var flag = false;
    var sgzt = $("#sgzt").val();
    if(sgzt=='01'){
        flag = validateKgd();
    }else if(sgzt=='02'){
        flag = validateLzlg();
    }else if(sgzt=='03'){
        flag = validateKzhsy();
    }else if(sgzt=='04'){
        flag = validateGr();
    }else if(sgzt=='05'){
        flag = validateJgdw();
    }
    if(flag){
        bootbox.confirm("确认保存吗?", function(result) {
            if(result){
                $.ajax({
                    type: 'post',
                    url: "${base}/ts/save",
                        data:$("#saveForm").serialize(),
                        dataType: 'json',
                        success: function (data) {
                            bootbox.alert(data.msg,function(){
                                if(data.msg=="保存成功"){
                                   window.location.reload();
                                }
                            });

                        }
                    });

                }
            });
        }
    };
</script>
</@com.html>