<#assign jsContent>

    <@com.script name="static/js/tax/grid.js"></@com.script>
    <@com.script name="static/js/public.js"></@com.script>
    <@com.script name="static/js/tax/swDjSy-save-validate.js"></@com.script>
    <@com.script name="static/thirdparty/bootstrap/js/bootstrap-typeahead.min.js"></@com.script>
</#assign>
<#assign cssContent>
    <@com.style name="static/css/pageForm.css"></@com.style>
    <@com.style name="static/thirdparty/ace/css/font-awesome.min.css"></@com.style>
    <@com.style name="static/thirdparty/ace/css/ace-fonts.css"></@com.style>
    <@com.style name="static/thirdparty/ace/css/ace.min.css"></@com.style>
    <@com.style name="static/thirdparty/ace/css/ace-skins.min.css"></@com.style>
    <@com.style name="static/thirdparty/ace/css/ace-rtl.min.css"></@com.style>
</#assign>
<@com.html title="核查税源台帐" import="jquery,jqgrid,bootstrap,bootbox,datetimepicker" js=jsContent css=cssContent >
<div class="main-container" id="main-container">
    <script type="text/javascript">
        try {
            ace.settings.check('main-container', 'fixed')
        } catch (e) {
        }
    </script>
    <form>
        <input type="hidden" id="proid" value="${proid!}" name="proid">
    </form>

    <div class="main-container-inner" id="sytz">
        <div class="page-content">

            <div class="row">
                <div class="widget-box transparent">
                    <div class="widget-body">
                        <div class="widget-main">
                            <row>

                                <div id="pageTitle" style="padding-bottom: 0px; text-align: ">
                                    国土宗地列表
                                </div>
                                <div class="col-xs-12" >
                                    <#if isZdhc='false'>
                                        <div class="col-sm-6 pull-right" style="padding-top:10px;">
                                            <button class="btn btn-sm btn-success pull-right" type="button" onclick="addTds();" id="addTdxx">
                                                <i class="ace-icon fa fa-reply bigger-110"></i>
                                                新增宗地
                                            </button>
                                        </div>
                                    </#if>
                                    <table  class="table table-bordered">
                                        <thead>
                                        <tr>
                                            <th style="width:10%;">地籍号</th>
                                            <th>土地坐落</th>
                                            <th>土地用途</th>
                                            <th>国土发证宗地面积</th>
                                            <th>权利人名称</th>
                                            <th>操作</th>
                                        </tr>
                                        </thead>
                                        <tbody id="zdList">
                                        <#if zdList??>
                                            <#list zdList as zd>
                                                <tr name="zd">
                                                    <td>${zd.DJH!}</td>
                                                    <td>${zd.TDZL!}</td>
                                                    <td>${zd.TDYTMC!}</td>
                                                    <td>${zd.SYQMJ!}</td>
                                                    <td>${zd.QLRMC!}</td>
                                                    <td><div title='新增土地税源' class='pull-left'  style='margin-left: 5px'><a href="javascript:void(0)" onclick="addSyTd('${zd.DJH!}');">新增土地税源</a></div></td>
                                                </tr>
                                            </#list>
                                        </#if>
                                        </tbody>
                                    </table>
                                </div>

                                <div id="pageTitle">
                                    城镇土地税税源列表
                                </div>
                                <div class="col-xs-12" >
                                    <table  class="table table-bordered">
                                        <thead>
                                            <tr>
                                                <th>地籍号</th>
                                                <th>纳税人名称</th>
                                                <th>土地坐落</th>
                                                <th>土地证号</th>
                                                <th>实测面积</th>
                                                <th>修改时间</th>
                                                <th>修改人</th>
                                                <th>操作</th>
                                            </tr>
                                        </thead>
                                        <tbody id="swDjSyList">
                                            <#if swDjSyList??>
                                                <#list swDjSyList as swDjSy>
                                                    <#if swDjSy.syzt == '1' && swDjSy.swDjTd??>
                                                        <tr name="sy">
                                                            <td><#if swDjSy.zd??>${swDjSy.zd.djh!}</#if></td>
                                                            <td>
                                                                ${swDjSy.swDjJbb.nsrmc!}
                                                            </td>
                                                            <td>${swDjSy.swDjTd.tdzl!}</td>
                                                            <td>${swDjSy.swDjTd.tdsyzh!}</td>
                                                            <td>${swDjSy.swDjTd.scmj!}</td>
                                                            <td>${swDjSy.updateRq!}</td>
                                                            <td>${swDjSy.updateUsername!}</td>
                                                            <td>
                                                                <div title='查看' class='pull-left'  style='margin-left: 5px'><a href="javascript:void(0)" onclick="viewSy('${swDjSy.syId!}', '1');">查看</a></div>
                                                                <div title='税源编辑' class='pull-left'  style='margin-left: 5px'><a href="javascript:void(0)" onclick="updSy('${swDjSy.syId!}', '1');">税源编辑</a></div>
                                                                <div title='税源删除' class='pull-left'  style='margin-left: 5px'><a href="javascript:void(0)" onclick="delSy('${swDjSy.syId!}', '1');">税源删除</a></div>
                                                            </td>
                                                        </tr>
                                                    </#if>
                                                </#list>
                                            </#if>
                                        </tbody>
                                    </table>
                                </div>

                                <div id="pageTitle" style="padding-bottom: 0px; text-align: ">
                                    房产税税源列表
                                </div>
                                <div class="col-xs-12" >
                                    <div class="col-sm-6 pull-right" style="padding-top:10px;">
                                        <button class="btn btn-sm btn-success pull-right" type="button" onclick="addSyFc('<#if swDjJbb??>${swDjJbb.jbbId!}</#if>','<#if isZdhc?? && isZdhc='true'>${qlrId!}</#if>');"  style="margin-left: 5px;">
                                            <i class="ace-icon fa fa-reply bigger-110"></i>
                                            新增房产税
                                        </button>
                                    </div>
                                    <table  class="table table-striped table-bordered">
                                        <thead>
                                        <tr>
                                            <th>纳税人名称</th>
                                            <th>房产坐落</th>
                                            <th>房产面积</th>
                                            <th>年应纳税额</th>
                                            <th>修改时间</th>
                                            <th>修改人</th>
                                            <th>操作</th>
                                        </tr>
                                        </thead>

                                        <tbody>
                                            <#if swDjSyList??>
                                                <#list swDjSyList as swDjSy>
                                                    <#if swDjSy.syzt == '1' && swDjSy.swDjFc??>
                                                        <tr>
                                                            <td>${swDjSy.swDjJbb.nsrmc!}</td>
                                                            <td>${swDjSy.swDjFc.fczl!}</td>
                                                            <td>${swDjSy.swDjFc.fcmj!}</td>
                                                            <td>${swDjSy.swDjFc.nynse!}</td>
                                                            <td>${swDjSy.updateRq!}</td>
                                                            <td>${swDjSy.updateUsername!}</td>
                                                            <td>
                                                                <div title='查看' class='pull-left'  style='margin-left: 5px'><a href="javascript:void(0)" onclick="viewSy('${swDjSy.syId!}', '2');">查看</a></div>
                                                                <div title='税源编辑' class='pull-left'  style='margin-left: 5px'><a href="javascript:void(0)" onclick="updSy('${swDjSy.syId!}', '2');">税源编辑</a></div>
                                                                <div title='税源删除' class='pull-left'  style='margin-left: 5px'><a href="javascript:void(0)" onclick="delSy('${swDjSy.syId!}', '2');">税源删除</a></div>
                                                            </td>
                                                        </tr>
                                                    </#if>
                                                </#list>
                                            </#if>
                                        </tbody>
                                    </table>
                                </div>

                            </row>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div><!-- /.main-container-inner -->

    <div class="main-container-inner" id="syxx" toggleId="sytz" style="display:none;">

    </div>

    <div class="modal fade" id="addZdModal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true" style="width:100%;">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header" style="background: #f7f7f7;background-image:linear-gradient(to bottom, #fff 0, #eee 100%);background-repeat:repeat-x;">
                    <button type="button" class="close"
                            data-dismiss="modal" aria-hidden="true">
                        &times;
                    </button>
                    <h4 class="modal-title" id="myModalLabel">
                        <i class="fa fa-pencil-square" style="color: #669fc7;">请选择新增宗地：</i>
                    </h4>
                </div>

                <div>
                    <form id="queryZdForm">
                        <div class="pull-left col-sm-12 search-query" style="margin-top: 15px; margin-bottom: 5px;">
                            <div class="col-xs-4 no-padding-left">
                                <div>地籍号</div>
                                <input type="text" name="DJH" id="djh" operator="operator-LLK" class="form-control input-mask-date"/>
                            </div>
                            <div class="col-xs-4 no-padding-left">
                                <div>权利人名称</div>
                                <input type="text" name="QLRMC" operator="operator-LK" class="form-control input-mask-date"/>
                            </div>
                            <div class="col-xs-4 no-padding-left">
                                <div>土地坐落</div>
                                <input type="text" name="TDZL" operator="operator-LK" class="form-control input-mask-date"/>
                            </div>
                            <div class="col-xs-4 no-padding-left">
                                <button type="button" class="btn btn-info btn-sm" id="btnQuery" onclick="queryZdList()">
                                    <i class="ace-icon fa fa-search bigger-110"></i>
                                    查询
                                </button>
                            </div>
                        </div>
                    </form>
                    <div class="col-xs-12" >
                        <table  class="table table-striped table-bordered">
                            <thead>
                                <tr>
                                    <th style="width:20px;">操作</th>
                                    <th>地籍号</th>
                                    <th>土地坐落</th>
                                    <th>土地用途</th>
                                    <th>国土宗地面积</th>
                                    <th>权利人名称</th>
                                </tr>
                            </thead>

                            <tbody id="zdListForm">

                            </tbody>
                        </table>
                    </div>
                    <span style="color: #669fc7;"></span>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-default"
                            data-dismiss="modal">关闭
                    </button>
                    <button type="button" class="btn btn-primary" id="addTd" onclick="addTd()">
                        确认增加
                    </button>
                </div>
            </div><!-- /.modal-content -->
        </div><!-- /.modal -->
    </div>
    <div style="display: none"><input type="button" id="btnPrintSingle"></div>

</div>
    <script type="text/javascript">
        var zdList = new Array();
        $(function() {
            bootbox.setDefaults({
                locale: "zh_CN"
            });

            $("tr:odd[name='zd']").css("background-color", "#f9f9f9");
            $("tr:odd[name='sy']").css("background-color", "#f9f9f9");

            zdList = [];
            <#list zdList as zd>
                zdList.push("${zd.DJH!}");
            </#list>



            $("tr[name='zd']").on("click", function() {
                $("tr:odd[name='zd']").css("background-color", "#f9f9f9");
                $("tr:even[name='zd']").css("background-color", "#ffffff");
                $(this).css("background-color", "#DDDDDD");

                $("tr:odd[name='sy']").css("background-color", "#f9f9f9");
                $("tr:even[name='sy']").css("background-color", "#ffffff");
                var selectDjh = this.children[0].innerText;
                for (var i = 0; i < $("tr[name='sy']").length; i++) {
                    var djh= $("tr[name='sy']")[i].children[0].innerText;
                    if (selectDjh == djh) {
                        $($("tr[name='sy']")[i]).css("background-color", "#DDDDDD")
                    }

                }
            });

            $("tr[name='sy']").on("click", function() {
                $("tr:odd[name='sy']").css("background-color", "#f9f9f9");
                $("tr:even[name='sy']").css("background-color", "#ffffff");
                $(this).css("background-color", "#DDDDDD");

                $("tr:odd[name='zd']").css("background-color", "#f9f9f9");
                $("tr:even[name='zd']").css("background-color", "#ffffff");

                var selectDjh = this.children[0].innerText;
                for (var i = 0; i < $("tr[name='zd']").length; i++) {
                    var djh= $("tr[name='zd']")[i].children[0].innerText;
                    if (selectDjh == djh) {
                        $($("tr[name='zd']")[i]).css("background-color", "#DDDDDD")
                    }

                }
            });

        });

        function addTds(){
            $("#addZdModal").modal("show");
        }

        function addTd() {
            var jbbId='${swDjJbb.jbbId!}';
            var djh;
            if ($(":checked[name='zdSelectR']") != null) {
                djh = $(":checked[name='zdSelectR']").val();
                if (zdList.indexOf(djh) >= 0) {
                    bootbox.alert("该纳税人已存在该宗地！");
                    return;
                }

                $("#addZdModal").modal("hide");
                for (var i in $('#zdListForm')[0].children) {
                    $('#zdListForm')[0].children[i].remove;
                }
            } else {
                bootbox.alert("请选择新增的宗地！");
                return;
            }


            $.ajax({
                type: 'post',
                url: "${base}/syhc/addZd?djh=" +djh+"&jbbId="+jbbId,
                dataType: 'json',
                success: function (data) {
                    bootbox.alert(data.msg, function () {
                        if (data.msg == " 创建成功！") {
                            window.location.reload();
                        }
                    })
                },

            });
        }

        function queryZdList() {
            var params = $('#queryZdForm').serializeJson();
            $.ajax({
                type: 'post',
                url: "${base}/tj/tjList?tag=zdList&query=" + params["query"],
                dataType: 'json',
                success: function (data) {
                    /*
                    for (var i in $('#zdListForm')[0].children) {
                        $('#zdListForm')[0].children[i].remove;
                    }
                    */
                    $('#zdListForm').empty();
                    for (var j in data) {
                        if (j >= 10) {
                            bootbox.alert("查询结果过多（" + data.length + "），只显示10条记录！");
                            break;
                        }

                        var zd = data[j];

                        var tr = document.createElement("tr");
                        tr.setAttribute("onclick", "this.children[0].children[0].checked = true");
                        var input;
                        var td;
                        input = document.createElement("input");
                        input.setAttribute("type", "radio");
                        input.setAttribute("name", "zdSelectR");
                        input.setAttribute("value", zd.DJH);
                        td = document.createElement("td");
                        td.appendChild(input);
                        tr.appendChild(td);

                        td = document.createElement("td");
                        td.innerText = zd.DJH;
                        tr.appendChild(td);

                        td = document.createElement("td");
                        td.innerText = zd.TDZL;
                        tr.appendChild(td);

                        td = document.createElement("td");
                        td.innerText = zd.TDYTMC;
                        tr.appendChild(td);

                        td = document.createElement("td");
                        td.innerText = zd.SCMJ;
                        tr.appendChild(td);

                        td = document.createElement("td");
                        td.innerText = zd.QLRMC;
                        tr.appendChild(td);

                        $('#zdListForm')[0].appendChild(tr);
                    }
                }
            });
        }

        function addSyTd(djh){
            var jbbId='${swDjJbb.jbbId!}';

            $.ajax({
                type: 'post',
                url: "${base}/ts/tdSyxxInput",
                data: {djh: djh,jbbId:jbbId,sylx:'1',noPrint:'1',noExport:'1'},
                dataType: 'text',
                success: function (data) {
                    $('#syxx').empty();
                    $('#syxx').append(data);
                    $("#syxx").toggle(300);
                    $("#sytz").toggle(300);
                },
            });
        }

        function addSyFc(jbbId,qlrId){
            var url = "${base}/ts/tdSyxxInput";
            if(qlrId!=undefined && qlrId !=''){
                url = url +　'?qlrId='+qlrId;
            }
            $.ajax({
                type: 'post',
                url: url,
                data: {jbbId:jbbId, sylx: '2',noPrint:'1',noExport:'1'},
                dataType: 'text',
                success: function (data) {
                    $('#syxx').empty();
                    $('#syxx').append(data);
                    $("#syxx").toggle(300);
                    $("#sytz").toggle(300);
                },
            });
        }

        function updSy(syId, sylx){
            $.ajax({
                type: 'post',
                url: "${base}/ts/tdSyxxInput",
                data:{syId: syId, sylx: sylx,noPrint:'1',noExport:'1'},
                dataType: 'text',
                success: function (data) {
                    $('#syxx').empty();
                    $('#syxx').append(data);
                    $("#syxx").toggle(300);
                    $("#sytz").toggle(300);
                },
                error: function (XmlHttpRequest, textStatus, errorThrown) {
                    alert('读取税源信息有误！');
                }
            });
        }

        function viewSy(syId, sylx){
            $.ajax({
                type: 'post',
                url: "${base}/ts/tdSyxxInput",
                data: {noSave:'1',noPrint:'1',noExport:'1',syId:syId,sylx:sylx,},
                dataType: 'text',
                success: function (data) {
                    $('#syxx').empty();
                    $('#syxx').append(data);
                    $("#syxx").toggle(300);
                    $("#sytz").toggle(300);
                },
            });
        }

        function delSy(syId){
            bootbox.confirm("确认删除吗?", function(result) {
                if(result){
                    $.ajax({
                        type: 'post',
                        url: "${base}/ts/delSy?syId="+syId,
                        dataType: 'json',
                        success: function (data) {
                            bootbox.alert("删除成功！",function(){

                                    window.location.reload();

                            })
                        }
                    });
                }
            });
        }
</script>

    <#assign jsContent>
        <@com.script name="static/thirdparty/ace/js/ace-extra.min.js"></@com.script>
        <@com.script name="static/thirdparty/ace/js/ace-elements.min.js"></@com.script>
        <@com.script name="static/thirdparty/ace/js/ace.min.js"></@com.script>


    </#assign>
</@com.html>