/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.landtax.web.tj;

import cn.gtmap.landtax.entity.ChartBaseParamVo;
import cn.gtmap.landtax.entity.TjBaseParamVo;
import cn.gtmap.landtax.print.PrintGridExcelUtil;
import cn.gtmap.landtax.printexcel.access.ExcelBean;
import cn.gtmap.landtax.service.DwxxService;
import cn.gtmap.landtax.service.TjService;
import cn.gtmap.landtax.service.impl.DicServiceImpl;
import cn.gtmap.landtax.util.CommonUtil;
import cn.gtmap.landtax.util.QueryCondition;
import com.alibaba.fastjson.JSONObject;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/tj"})
public class TjController {
    @Autowired
    TjService tjService;
    @Autowired
    DicServiceImpl dicServiceImpl;
    @Autowired
    DwxxService dwxxService;

    @RequestMapping(value={"baseTj"})
    public String baseTj(Model model, String tag, String customParams) {
        model.addAttribute("tag", (Object)tag);
        model.addAttribute("customParams", (Object)customParams);
        TjBaseParamVo tjBaseParamVo = this.tjService.getTjBaseParam(tag);
        model.addAttribute("tjBaseParamVo", (Object)tjBaseParamVo);
        if (tjBaseParamVo != null) {
            model.addAttribute("colJson", (Object)tjBaseParamVo.getColJson());
            model.addAttribute("headPageFile", (Object)tjBaseParamVo.getHeadPageFile());
            model.addAttribute("reportName", (Object)tjBaseParamVo.getReportName());
            if (StringUtils.isNotBlank((String)tjBaseParamVo.getExcelTemplate()) && StringUtils.isNotBlank((String)tjBaseParamVo.getExcelXml()) && StringUtils.isNotBlank((String)tjBaseParamVo.getExportFieldList())) {
                model.addAttribute("needExport", (Object)"true");
            }
            if (tjBaseParamVo.isNeedExport()) {
                model.addAttribute("autoExport", (Object)"true");
            }
        }
        return "landtax/tj/baseTj";
    }

    @RequestMapping(value={"baseChart"})
    public String baseChart(Model model, String tag, String customParams) {
        TjBaseParamVo tjBaseParamVo = this.tjService.getTjBaseParam(tag);
        model.addAttribute("tjBaseParamVo", (Object)tjBaseParamVo);
        model.addAttribute("customParams", (Object)customParams);
        return "landtax/tj/baseChart";
    }

    @RequestMapping(value={"tjJson"})
    @ResponseBody
    public Page tjJson(Model model, Pageable request, String tag, String query, String customParams) {
        List queryConditionList = CommonUtil.initQueryCondition((String)query);
        queryConditionList = this.addCustomParams(queryConditionList, customParams);
        Page page = this.tjService.getTjJson(request, tag, queryConditionList);
        return page;
    }

    @RequestMapping(value={"chartJson"})
    @ResponseBody
    public Object chartJson(Model model, Pageable request, String tag, String query, String customParams, String uniqueId) {
        TjBaseParamVo tjBaseParamVo = this.tjService.getTjBaseParam(tag);
        ChartBaseParamVo chartBaseParamVo = (ChartBaseParamVo)tjBaseParamVo.getChartBaseParamVoList().get(0);
        for (ChartBaseParamVo chartBaseParamVoTemp : tjBaseParamVo.getChartBaseParamVoList()) {
            if (!chartBaseParamVoTemp.getUniqueId().equals(uniqueId)) continue;
            chartBaseParamVo = chartBaseParamVoTemp;
            break;
        }
        List queryConditionList = CommonUtil.initQueryCondition((String)query);
        queryConditionList = this.addCustomParams(queryConditionList, customParams);
        List tjList = this.tjService.getTjList(tag, queryConditionList);
        String chartRowField = chartBaseParamVo.getRowUseFlagField();
        ArrayList<String> categoriesList = new ArrayList<String>();
        for (HashMap hashMap : tjList) {
            if (hashMap.get(chartRowField) != null && !hashMap.get(chartRowField).toString().equals("1")) continue;
            categoriesList.add(hashMap.get(chartBaseParamVo.getCategoriesField()).toString());
        }
        ArrayList seriesList = new ArrayList();
        List seriesNameList = chartBaseParamVo.getSeriesList();
        for (int i = 0; i < seriesNameList.size(); ++i) {
            String seriesField = ((HashMap)seriesNameList.get(i)).get("seriesField").toString();
            String seriesName = ((HashMap)seriesNameList.get(i)).get("seriesName").toString();
            String seriesUnit = ((HashMap)seriesNameList.get(i)).get("seriesUnit").toString();
            ArrayList list = new ArrayList();
            for (HashMap hashMap : tjList) {
                if (hashMap.get(chartRowField) != null && !hashMap.get(chartRowField).toString().equals("1")) continue;
                HashMap hashMapTemp = new HashMap();
                hashMapTemp.put("name", hashMap.get(chartBaseParamVo.getCategoriesField()));
                hashMapTemp.put("y", hashMap.get(seriesField) == null ? Integer.valueOf(0) : hashMap.get(seriesField));
                list.add(hashMapTemp);
            }
            HashMap<String, Object> seriesMap = new HashMap<String, Object>();
            seriesMap.put("name", seriesName);
            seriesMap.put("data", list);
            seriesMap.put("unit", seriesUnit);
            seriesList.add(seriesMap);
        }
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("categories", categoriesList);
        resultMap.put("series", seriesList);
        resultMap.put("chartBaseParamVo", chartBaseParamVo);
        resultMap.put("customOptions", chartBaseParamVo.getCustomOptions());
        return resultMap;
    }

    @RequestMapping(value={"tjList"})
    @ResponseBody
    public List tjList(Model model, Pageable request, String tag, String query, String customParams) {
        List queryConditionList = CommonUtil.initQueryCondition((String)query);
        queryConditionList = this.addCustomParams(queryConditionList, customParams);
        List list = this.tjService.getTjList(tag, queryConditionList);
        return list;
    }

    @RequestMapping(value={"exportExcelTj"})
    public String exportExcelTj(HttpServletRequest request, String tag, String query, String customParams) throws Exception {
        try {
            TjBaseParamVo tjBaseParamVo = this.tjService.getTjBaseParam(tag);
            if (tjBaseParamVo == null) {
                return null;
            }
            String[] fieldList = tjBaseParamVo.getExportFieldList().split(",");
            List queryConditionList = CommonUtil.initQueryCondition((String)query);
            queryConditionList = this.addCustomParams(queryConditionList, customParams);
            List list = this.tjService.getTjList(tag, queryConditionList);
            HashMap map = new HashMap();
            ArrayList<String[]> retList = new ArrayList<String[]>();
            int sheetIndex = 0;
            long sheetRecordCount = 50000L;
            for (int i = 0; i < list.size(); ++i) {
                HashMap tempVo = (HashMap)list.get(i);
                if (tempVo != null) {
                    String[] strs = new String[fieldList.length];
                    for (int j = 0; j < fieldList.length; ++j) {
                        if (tempVo.get(fieldList[j].toString()) != null) {
                            strs[j] = tempVo.get(fieldList[j].toString()).toString();
                            continue;
                        }
                        if (!fieldList[j].toString().equals("XH")) continue;
                        strs[j] = String.valueOf(i + 1);
                    }
                    retList.add(strs);
                }
                if ((long)retList.size() < sheetRecordCount) continue;
                map.put("group" + String.valueOf(++sheetIndex), retList);
                retList = new ArrayList();
            }
            if (retList.size() > 0) {
                map.put("group" + String.valueOf(++sheetIndex), retList);
                retList = new ArrayList();
            }
            ExcelBean eb = new ExcelBean();
            request.setAttribute("date", (Object)("" + new SimpleDateFormat("yyyy\u5e74MM\u6708dd\u65e5").format(new Date())));
            request.setAttribute("year", (Object)("" + new SimpleDateFormat("yyyy").format(new Date())));
            eb.setGroupMap(map);
            eb.setExcelTemplate(tjBaseParamVo.getExcelTemplate());
            eb.setExcelXml(tjBaseParamVo.getExcelXml());
            eb.printExcel(request);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "common/downExcel";
    }

    @RequestMapping(value={"exportExcelTjEx"})
    public String exportExcelTjEx(HttpServletRequest request, String tag, String query, String customParams, String gridOptions) {
        try {
            TjBaseParamVo tjBaseParamVo = this.tjService.getTjBaseParam(tag);
            if (tjBaseParamVo == null) {
                return null;
            }
            List queryConditionList = CommonUtil.initQueryCondition((String)query);
            queryConditionList = this.addCustomParams(queryConditionList, customParams);
            List list = this.tjService.getTjList(tag, queryConditionList);
            new JSONObject();
            JSONObject jsonObject = JSONObject.parseObject((String)gridOptions);
            PrintGridExcelUtil printGridExcel = new PrintGridExcelUtil();
            printGridExcel.setTitle(tjBaseParamVo.getReportName());
            printGridExcel.setGridOptions(jsonObject);
            printGridExcel.printGridExcel(request, list);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "common/downExcel";
    }

    private List<QueryCondition> addCustomParams(List<QueryCondition> queryConditionList, String customParams) {
        if (queryConditionList == null) {
            queryConditionList = new ArrayList<QueryCondition>();
        }
        if (StringUtils.isNotBlank((String)customParams)) {
            List customQueryConditionList = CommonUtil.initQueryCondition((String)customParams);
            for (int i = 0; i < customQueryConditionList.size(); ++i) {
                queryConditionList.add((QueryCondition)customQueryConditionList.get(i));
            }
        }
        return queryConditionList;
    }
}

