/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.landtax.web.fzjc;

import cn.gtmap.landtax.entity.TjBaseParamVo;
import cn.gtmap.landtax.model.dictionary.ResponseMessage;
import cn.gtmap.landtax.service.TjService;
import cn.gtmap.landtax.service.ZdbgService;
import cn.gtmap.landtax.support.jpa.BaseRepository;
import cn.gtmap.landtax.support.spring.BaseController;
import cn.gtmap.landtax.util.CommonUtil;
import cn.gtmap.landtax.util.DateUtils;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.persistence.Query;
import org.apache.commons.lang.StringUtils;
import org.hibernate.SQLQuery;
import org.hibernate.transform.ResultTransformer;
import org.hibernate.transform.Transformers;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/zdbg"})
public class ZdbgController
extends BaseController {
    @Autowired
    ZdbgService zdBgService;
    @Autowired
    TjService tjService;
    @Autowired
    BaseRepository baseRepository;

    @RequestMapping(value={"index"})
    public String test(Model model) throws Exception {
        Date startDate = DateUtils.now();
        Date endDate = DateUtils.addYears((Date)startDate, (int)-1);
        String tag = "zdbgList";
        model.addAttribute("tag", (Object)tag);
        TjBaseParamVo tjBaseParamVo = this.tjService.getTjBaseParam(tag);
        if (tjBaseParamVo != null) {
            model.addAttribute("colJson", (Object)tjBaseParamVo.getColJson());
            model.addAttribute("headPageFile", (Object)tjBaseParamVo.getHeadPageFile());
            model.addAttribute("reportName", (Object)tjBaseParamVo.getReportName());
            if (StringUtils.isNotBlank((String)tjBaseParamVo.getExcelTemplate()) && StringUtils.isNotBlank((String)tjBaseParamVo.getExcelXml()) && StringUtils.isNotBlank((String)tjBaseParamVo.getExportFieldList())) {
                model.addAttribute("needExport", (Object)"true");
            }
            if (tjBaseParamVo.isNeedExport()) {
                model.addAttribute("autoExport", (Object)"true");
            }
        }
        return "landtax/zd/zdbg";
    }

    @RequestMapping(value={"doZdbg"})
    @ResponseBody
    public Object doZdbg(Model model, Date startDate, Date endDate) {
        String dobgid = this.zdBgService.analyZdBgData(startDate, endDate);
        this.zdBgService.refreshZdSwRelation(dobgid);
        ResponseMessage responseMessage = new ResponseMessage();
        return responseMessage;
    }

    @RequestMapping(value={"zdbgJson"})
    @ResponseBody
    public Object zdbgJson(Model model, Pageable request, String tag, String query) {
        List queryConditionList = CommonUtil.initQueryCondition((String)query);
        Page page = this.tjService.getTjJson(request, tag, queryConditionList);
        return page;
    }

    @RequestMapping(value={"getZdbgStartRq"})
    @ResponseBody
    public Object getZdbgStartRq(Model model) throws Exception {
        String sql = "SELECT MAX(BG_END) AS LASTENDRQ FROM S_SJ_ZDBG_DOBG";
        Query query = this.baseRepository.getEntityManager().createNativeQuery(sql);
        ((SQLQuery)query.unwrap(SQLQuery.class)).setResultTransformer((ResultTransformer)Transformers.ALIAS_TO_ENTITY_MAP);
        List list = query.getResultList();
        String startRq = "";
        if (((HashMap)list.get(0)).get("LASTENDRQ") != null) {
            Date lastEndRq = (Date)((HashMap)list.get(0)).get("LASTENDRQ");
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(lastEndRq);
            calendar.add(6, 1);
            startRq = simpleDateFormat.format(calendar.getTime());
        }
        ResponseMessage responseMessage = new ResponseMessage();
        responseMessage.setMsg(startRq);
        return responseMessage;
    }
}

