/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.landtax.web.fzjc;

import cn.gtmap.landtax.entity.Zd;
import cn.gtmap.landtax.entity.ZdTemp;
import cn.gtmap.landtax.model.dictionary.ResponseMessage;
import cn.gtmap.landtax.service.DwxxService;
import cn.gtmap.landtax.service.ZdService;
import cn.gtmap.landtax.support.jpa.BaseRepository;
import com.alibaba.fastjson.JSON;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/zd"})
public class ZdController {
    @Autowired
    private DwxxService dwxxService;
    @Autowired
    ZdService zdService;
    @Autowired
    BaseRepository baseRepository;

    @RequestMapping(value={"list"})
    public String zdList(Model model) {
        List allQxList = this.dwxxService.getAllQxList();
        model.addAttribute("allQxList", (Object)allQxList);
        return "landtax/fzjc/zdtz";
    }

    @RequestMapping(value={"zdJson"})
    @ResponseBody
    public Object zdjson(Pageable pageable, Zd zdQuery, String proid) {
        return this.zdService.getZdPage(zdQuery, pageable, proid);
    }

    @RequestMapping(value={"getJdByQx"})
    @ResponseBody
    public Object getJdByQx(Model model, String qx) {
        List jdList = this.dwxxService.getJdByQx(qx);
        return jdList;
    }

    @RequestMapping(value={"getJfByJd"})
    @ResponseBody
    public Object getJfByJd(Model model, String jd) {
        List jdList = this.dwxxService.getJfByJd(jd);
        return jdList;
    }

    @RequestMapping(value={"getSwDjSy"})
    @ResponseBody
    public Page getSwDjSy(Model model, String jd) {
        Page swDjSyPage = this.dwxxService.getSwdjSy(null);
        System.out.println(JSON.toJSONString((Object)swDjSyPage));
        return swDjSyPage;
    }

    @RequestMapping(value={"zdInput"})
    public String zdInput(Model model, String djh, String tag) throws Exception {
        Zd zd = (Zd)this.baseRepository.get(Zd.class, (Object)djh);
        List zdTempList = this.zdService.zdInput(djh);
        ZdTemp zdTemp = null;
        if (CollectionUtils.isNotEmpty((Collection)zdTempList)) {
            zdTemp = (ZdTemp)zdTempList.get(0);
        }
        if (zdTemp != null) {
            model.addAttribute("zdTemp", (Object)zdTemp);
        } else {
            model.addAttribute("zdTemp", (Object)zd);
        }
        model.addAttribute("tag", (Object)tag);
        model.addAttribute("zd", (Object)zd);
        return "landtax/fzjc/zdxxInput";
    }

    @RequestMapping(value={"zdSave"})
    @ResponseBody
    public Object zdSave(Model model, ZdTemp zdTemp) throws Exception {
        ResponseMessage responseMessage = new ResponseMessage();
        String msg = "";
        return responseMessage;
    }

    @RequestMapping(value={"zdQxXg"})
    @ResponseBody
    public Object zdQxXg(Model model, ZdTemp zdTemp) throws Exception {
        String msg = "";
        ResponseMessage responseMessage = new ResponseMessage();
        try {
            msg = this.zdService.zdQxXg(zdTemp);
            responseMessage.setMsg("\u6210\u529f\u53d6\u6d88\u4fee\u6539");
        }
        catch (Exception e) {
            e.printStackTrace();
            responseMessage.setMsg("\u51fa\u73b0\u5f02\u5e38\uff0c\u53d6\u6d88\u4fee\u6539\u5931\u8d25");
        }
        if (msg != null && msg != "") {
            responseMessage.setMsg(msg);
        }
        return responseMessage;
    }

    @RequestMapping(value={"zdTempSave"})
    @ResponseBody
    public Object zdTempSave(Model model, ZdTemp zdTemp) throws Exception {
        ResponseMessage responseMessage = new ResponseMessage();
        try {
            this.zdService.saveTempZd(zdTemp);
            responseMessage.setMsg("\u4fdd\u5b58\u6210\u529f");
        }
        catch (Exception e) {
            e.printStackTrace();
            responseMessage.setMsg("\u51fa\u73b0\u5f02\u5e38\uff0c\u4fdd\u5b58\u5931\u8d25");
        }
        return responseMessage;
    }

    @RequestMapping(value={"findZdByDjh"})
    @ResponseBody
    public Object findZdByDjh(Model model, String djh) {
        Zd zd = this.zdService.findZdByDjh(djh);
        return zd;
    }
}

