/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.landtax.util;

import cn.gtmap.landtax.entity.Project;
import cn.gtmap.landtax.util.IPlatUtil;
import cn.gtmap.landtax.util.WorkFlowXml;
import cn.gtmap.landtax.util.WorkFlowXmlUtil;
import com.gtis.fileCenter.ex.NodeNotFoundException;
import com.gtis.fileCenter.model.Node;
import com.gtis.fileCenter.model.Space;
import com.gtis.fileCenter.service.NodeService;
import com.gtis.plat.service.SysTaskService;
import com.gtis.plat.service.SysUserService;
import com.gtis.plat.service.SysWorkFlowDefineService;
import com.gtis.plat.service.SysWorkFlowInstanceService;
import com.gtis.plat.service.WorkFlowCoreService;
import com.gtis.plat.vo.PfActivityVo;
import com.gtis.plat.vo.PfTaskVo;
import com.gtis.plat.vo.PfUserVo;
import com.gtis.plat.vo.PfWorkFlowDefineVo;
import com.gtis.plat.vo.PfWorkFlowInstanceVo;
import com.gtis.plat.wf.WorkFlowInfo;
import com.gtis.plat.wf.model.ActivityModel;
import com.gtis.plat.wf.model.PerformerModel;
import com.gtis.spring.Container;
import com.gtis.web.SessionUtil;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service(value="platUtil")
public class PlatUtil
implements IPlatUtil {
    @Autowired
    WorkFlowCoreService workFlowCoreService;
    @Autowired
    SysUserService sysUserService;
    @Autowired
    @Qualifier(value="SysWorkFlowDefineService")
    SysWorkFlowDefineService workFlowDefineService;
    @Autowired
    WorkFlowXmlUtil workFlowXmlUtil;
    SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public String createWorkFlowInstance(Project project, String userId, String proName) {
        String taskId = "";
        try {
            PfTaskVo taskVo;
            String wdid = project.getWdid();
            this.checkAuthorCreateWorkflow(wdid, userId);
            PfWorkFlowInstanceVo wfVO = new PfWorkFlowInstanceVo();
            if (StringUtils.isNotBlank((String)project.getDay())) {
                wfVO.setTimeLimit(String.valueOf(project.getDay()));
            }
            if (StringUtils.isNotBlank((String)project.getCreateTime())) {
                wfVO.setCreateTime(this.simpleDateFormat.parse(project.getCreateTime()));
            } else {
                wfVO.setCreateTime(Calendar.getInstance().getTime());
            }
            wfVO.setWorkflowIntanceId(project.getProjectId());
            wfVO.setWorkflowDefinitionId(project.getWdid());
            wfVO.setProId(project.getProjectId());
            if (StringUtils.isBlank((String)project.getProjectName())) {
                wfVO.setWorkflowIntanceName(proName);
            } else {
                wfVO.setWorkflowIntanceName(project.getProjectName());
            }
            wfVO.setCreateUser(userId);
            wfVO.setRemark(project.getBz());
            WorkFlowInfo workFlowInfo = this.workFlowCoreService.createWorkFlowInstance(wfVO, userId);
            Iterator i$ = workFlowInfo.getTargetTasks().iterator();
            while (i$.hasNext()) {
                taskVo = (PfTaskVo)i$.next();
                if (!taskVo.getUserVo().getUserId().equals(userId) && userId != taskVo.getUserVo().getUserId()) continue;
                taskId = taskVo.getTaskId();
                break;
            }
            if ((taskId == null || taskId.equals("")) && (i$ = workFlowInfo.getTargetTasks().iterator()).hasNext()) {
                taskVo = (PfTaskVo)i$.next();
                taskId = taskVo.getTaskId();
            }
        }
        catch (Exception e) {
            System.out.println("\u521b\u5efa\u5de5\u4f5c\u6d41\u5b9e\u4f8b\u5931\u8d25");
            throw (RuntimeException)e;
        }
        return taskId;
    }

    private void checkAuthorCreateWorkflow(String wdid, String userId) {
        PfWorkFlowDefineVo pfWorkFlowDefineVo = this.workFlowDefineService.getWorkFlowDefine(wdid);
        WorkFlowXml workXml = this.workFlowXmlUtil.getWorkFlowDefineModel(pfWorkFlowDefineVo);
        ActivityModel beginModel = (ActivityModel)workXml.getActivityList().get(0);
        List performerList = beginModel.getPerformerList();
        ArrayList<String> performUserIdsList = new ArrayList<String>();
        Boolean flag = false;
        for (PerformerModel performerModel : performerList) {
            List users;
            if (!performerModel.getUserId().equals("")) {
                String userid = performerModel.getUserId();
                performUserIdsList.add(userid);
                continue;
            }
            if (!performerModel.getOrganId().equals("")) {
                users = this.sysUserService.getUserListByOragn(performerModel.getOrganId());
                for (PfUserVo user : users) {
                    performUserIdsList.add(user.getUserId());
                }
                continue;
            }
            if (performerModel.getRoleId().equals("")) continue;
            users = this.sysUserService.getUserListByRole(performerModel.getRoleId());
            for (PfUserVo user : users) {
                performUserIdsList.add(user.getUserId());
            }
        }
        for (String performUserId : performUserIdsList) {
            if (!performUserId.equals(userId)) continue;
            flag = true;
            break;
        }
        if (!flag.booleanValue()) {
            System.out.println("\u8be5\u7528\u6237\u4e0d\u5141\u8bb8\u521b\u5efa\u8be5\u6d41\u7a0b");
            throw new RuntimeException("\u8be5\u7528\u6237\u4e0d\u5141\u8bb8\u521b\u5efa\u8be5\u6d41\u7a0b");
        }
    }

    public void deleteWorkFlowInstance(String proid) throws Exception {
        if (StringUtils.isNotBlank((String)proid)) {
            this.workFlowCoreService.deleteWorkFlowInstance(SessionUtil.getCurrentUserId(), proid);
        }
    }

    public void editWorkFlowInstance(String projectId, String remark, String projectName) {
        SysWorkFlowInstanceService sysWorkFlowInstanceService = (SysWorkFlowInstanceService)Container.getBean((String)"SysWorkFlowInstanceService");
        PfWorkFlowInstanceVo wfInstanceVo = sysWorkFlowInstanceService.getWorkflowInstanceByProId(projectId);
        if (wfInstanceVo != null) {
            wfInstanceVo.setRemark(remark);
            sysWorkFlowInstanceService.updateWorkFlowInstanceRemark(wfInstanceVo);
            if (!projectName.equals("")) {
                wfInstanceVo.setWorkflowIntanceName(projectName);
                sysWorkFlowInstanceService.updateWorkFlowIntanceName(wfInstanceVo);
            }
        }
    }

    public void editWorkFlowInstanceName(String projectId, String projectName) {
        SysWorkFlowInstanceService sysWorkFlowInstanceService = (SysWorkFlowInstanceService)Container.getBean((String)"SysWorkFlowInstanceService");
        PfWorkFlowInstanceVo wfInstanceVo = sysWorkFlowInstanceService.getWorkflowInstanceByProId(projectId);
        wfInstanceVo.setWorkflowIntanceName(projectName);
        sysWorkFlowInstanceService.updateWorkFlowIntanceName(wfInstanceVo);
    }

    public String getActivityDesc(String projectId, String activityId) {
        SysWorkFlowInstanceService sysWorkFlowInstanceService = (SysWorkFlowInstanceService)Container.getBean((String)"SysWorkFlowInstanceService");
        Document document = null;
        try {
            document = DocumentHelper.parseText((String)sysWorkFlowInstanceService.getWorkflowInstanceXml(projectId));
        }
        catch (DocumentException e) {
            e.printStackTrace();
        }
        Element root = document.getRootElement();
        org.dom4j.Node node1 = root.selectSingleNode("//Package/WorkflowProcesses/WorkflowProcess/Activities/Activity[@Id='" + activityId + "']/Description");
        String activityDesc = node1.getText();
        if (activityDesc != null) {
            return activityDesc;
        }
        SysTaskService sysTaskService = (SysTaskService)Container.getBean((String)"SysTaskService");
        PfActivityVo pfActivityVo = sysTaskService.getActivity(activityId);
        if (pfActivityVo != null) {
            activityDesc = pfActivityVo.getActivityName();
        }
        return activityDesc;
    }

    public String getCNQX(String wdid) {
        SysWorkFlowDefineService sysWorkFlowDefineService = (SysWorkFlowDefineService)Container.getBean((String)"SysWorkFlowDefineService");
        PfWorkFlowDefineVo wfDefineVo = sysWorkFlowDefineService.getWorkFlowDefine(wdid);
        String cnqx = wfDefineVo.getTimeLimit();
        return cnqx;
    }

    public String getPfActivityNameByTaskId(String taskId) {
        String activitId;
        PfActivityVo pfActivityVo;
        PfTaskVo pfTask;
        SysTaskService sysTaskService = (SysTaskService)Container.getBean((String)"SysTaskService");
        String activityName = "";
        if (taskId != null && !taskId.equals("") && (pfTask = sysTaskService.getTask(taskId)) != null && (pfActivityVo = sysTaskService.getActivity(activitId = pfTask.getActivityId())) != null) {
            activityName = pfActivityVo.getActivityName();
        }
        return activityName;
    }

    public String getPfacdfIdByTaskId(String taskId) {
        String activitId;
        PfActivityVo pfActivityVo;
        PfTaskVo pfTask;
        SysTaskService sysTaskService = (SysTaskService)Container.getBean((String)"SysTaskService");
        String activityId = "";
        if (taskId != null && !taskId.equals("") && (pfTask = sysTaskService.getTask(taskId)) != null && (pfActivityVo = sysTaskService.getActivity(activitId = pfTask.getActivityId())) != null) {
            activityId = pfActivityVo.getActivityDefinitionId();
        }
        return activityId;
    }

    public String getTimeLimit(String wdid) {
        SysWorkFlowDefineService sysWorkFlowDefineService = (SysWorkFlowDefineService)Container.getBean((String)"SysWorkFlowDefineService");
        PfWorkFlowDefineVo wfDefineVo = sysWorkFlowDefineService.getWorkFlowDefine(wdid);
        return wfDefineVo.getTimeLimit();
    }

    public String getWfRemarkByProjectId(String projectId) {
        PfWorkFlowInstanceVo wfInstanceVo;
        SysWorkFlowInstanceService sysWorkFlowInstanceService = (SysWorkFlowInstanceService)Container.getBean((String)"SysWorkFlowInstanceService");
        SysWorkFlowDefineService sysWorkFlowDefineService = (SysWorkFlowDefineService)Container.getBean((String)"SysWorkFlowDefineService");
        PfWorkFlowDefineVo wfDefineVo = sysWorkFlowDefineService.getWorkFlowDefine((wfInstanceVo = sysWorkFlowInstanceService.getWorkflowInstanceByProId(projectId)).getWorkflowDefinitionId());
        String wfRemark = wfDefineVo.getRemark();
        if (wfRemark == null) {
            wfRemark = "";
        }
        return wfRemark;
    }

    public String getWfRemarkByWdid(String wdid) {
        SysWorkFlowDefineService sysWorkFlowDefineService = (SysWorkFlowDefineService)Container.getBean((String)"SysWorkFlowDefineService");
        PfWorkFlowDefineVo wfDefineVo = sysWorkFlowDefineService.getWorkFlowDefine(wdid);
        String wfRemark = wfDefineVo.getRemark();
        if (wfRemark == null) {
            wfRemark = "";
        }
        return wfRemark;
    }

    public String getPfActivityIdByTaskId(String taskId) {
        PfTaskVo pfTask;
        SysTaskService sysTaskService = (SysTaskService)Container.getBean((String)"SysTaskService");
        String activitId = "";
        if (taskId != null && !taskId.equals("") && (pfTask = sysTaskService.getTask(taskId)) != null) {
            activitId = pfTask.getActivityId();
        }
        return activitId;
    }

    public List<String> getFileId(String projectId) {
        ArrayList<String> listID = new ArrayList<String>();
        try {
            if (projectId != null && !projectId.equals("")) {
                List list = this.getProjectNode(projectId);
                for (Node node : list) {
                    listID.add(node.getId().toString());
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return listID;
    }

    public List<String> getFileId(String projectId, String desc) {
        return null;
    }

    public void saveNodeDescByProjectId(Integer fileId, String desc, String projectId) {
        try {
            NodeService nodeService = (NodeService)Container.getBean((String)"FileCenterNodeServiceImpl");
            Node node = nodeService.getNode(fileId);
            if (node != null && (node.getDescription() == null || node.getDescription().equals(""))) {
                List nodeList = this.getFileId(projectId, desc);
                if (nodeList.size() > 0) {
                    desc = desc + nodeList.size();
                }
                node.setName(desc + node.getName().substring(node.getName().lastIndexOf("."), node.getName().length()));
                node.setDescription(desc);
                nodeService.save(node);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void removeFile(Integer fileId) {
        try {
            NodeService nodeService = (NodeService)Container.getBean((String)"FileCenterNodeServiceImpl");
            nodeService.remove(fileId);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void saveNodeDesc(Integer fileId, String desc) {
        try {
            NodeService nodeService = (NodeService)Container.getBean((String)"FileCenterNodeServiceImpl");
            Node node = nodeService.getNode(fileId);
            if (node != null && (node.getDescription() == null || node.getDescription().equals(""))) {
                node.setDescription(desc);
                nodeService.save(node);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getToken() {
        String token = "whosyourdaddy";
        try {
            NodeService nodeService = (NodeService)Container.getBean((String)"FileCenterNodeServiceImpl");
            Space space = nodeService.getWorkSpace("WORK_FLOW_STUFF");
            if (space != null) {
                token = nodeService.getToken((Node)space);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return token;
    }

    private List<Node> getProjectNode(String projectId) {
        NodeService nodeService = (NodeService)Container.getBean((String)"FileCenterNodeServiceImpl");
        Space space = nodeService.getWorkSpace("WORK_FLOW_STUFF");
        Node tempNode = this.createFileFolder(space.getId(), projectId);
        List list = nodeService.getAllChildNodes(tempNode.getId());
        return list;
    }

    private Node createFileFolder(Integer parentId, String folderNodeName) {
        Node tempNode = null;
        NodeService nodeService = (NodeService)Container.getBean((String)"FileCenterNodeServiceImpl");
        try {
            tempNode = nodeService.getNode(parentId, folderNodeName, true);
        }
        catch (NodeNotFoundException e) {
            e.printStackTrace();
        }
        return tempNode;
    }

    public String getWorkFlowStuffId() {
        NodeService nodeService = (NodeService)Container.getBean((String)"FileCenterNodeServiceImpl");
        Space space = nodeService.getWorkSpace("WORK_FLOW_STUFF");
        return space.getId().toString();
    }

    public String getProjectFileId(String projectId) {
        NodeService nodeService = (NodeService)Container.getBean((String)"FileCenterNodeServiceImpl");
        Space space = nodeService.getWorkSpace("WORK_FLOW_STUFF");
        Node tempNode = this.createFileFolder(space.getId(), projectId);
        return tempNode.getId().toString();
    }

    public Integer createFileFolderByclmc(String parentId, String folderNodeName) {
        Node tempNode = null;
        NodeService nodeService = (NodeService)Container.getBean((String)"FileCenterNodeServiceImpl");
        try {
            tempNode = nodeService.getNode(Integer.valueOf(parentId), folderNodeName, true);
        }
        catch (NodeNotFoundException e) {
            e.printStackTrace();
        }
        return tempNode.getId();
    }

    public void updateFileName(String projectId) {
        NodeService nodeService = (NodeService)Container.getBean((String)"FileCenterNodeServiceImpl");
        Space space = nodeService.getWorkSpace("WORK_FLOW_STUFF", true);
        Node prjNode = nodeService.getNode(space.getId(), projectId, true);
        List childNodes = nodeService.getChildNodes(prjNode.getId());
        int i = 0;
        for (Node node : childNodes) {
            if (node.getType() == 0) {
                this.getFilesByFolder(node);
                continue;
            }
            if (node.getType() != 1) continue;
            String fileType = "";
            if (node.getName().lastIndexOf(46) != -1) {
                fileType = node.getName().substring(node.getName().lastIndexOf(46));
            }
            node.setName(prjNode.getName() + ++i + fileType);
            nodeService.save(node);
        }
    }

    public void getFilesByFolder(Node node) {
        NodeService nodeService = (NodeService)Container.getBean((String)"FileCenterNodeServiceImpl");
        List childNodes = nodeService.getChildNodes(node.getId());
        int i = 0;
        for (Node childNode : childNodes) {
            if (childNode.getType() == 0) {
                this.getFilesByFolder(childNode);
                continue;
            }
            if (childNode.getType() != 1) continue;
            String fileType = "";
            if (childNode.getName().lastIndexOf(46) != -1) {
                fileType = childNode.getName().substring(childNode.getName().lastIndexOf(46));
            }
            childNode.setName(node.getName() + ++i + fileType);
            nodeService.save(childNode);
        }
    }

    public boolean checkFloder(String projectId, String floderName) {
        NodeService nodeService = (NodeService)Container.getBean((String)"FileCenterNodeServiceImpl");
        Space space = nodeService.getWorkSpace("WORK_FLOW_STUFF", true);
        Node prjNode = nodeService.getNode(space.getId(), projectId, true);
        List childNodes = nodeService.getChildNodes(prjNode.getId());
        boolean i = false;
        for (Node node : childNodes) {
            int filesCounet;
            if (!node.getName().equals(floderName) || (filesCounet = nodeService.getAllChildFilesCount(node.getId())) <= 0) continue;
            return true;
        }
        return false;
    }

    public Integer getFilesCounet(String projectId, String floderName) {
        int filesCounet = 0;
        NodeService nodeService = (NodeService)Container.getBean((String)"FileCenterNodeServiceImpl");
        Space space = nodeService.getWorkSpace("WORK_FLOW_STUFF", true);
        Node prjNode = nodeService.getNode(space.getId(), projectId, true);
        List childNodes = nodeService.getChildNodes(prjNode.getId());
        boolean i = false;
        for (Node node : childNodes) {
            if (!node.getName().equals(floderName)) continue;
            filesCounet = nodeService.getAllChildFilesCount(node.getId());
        }
        return filesCounet;
    }

    public static String getTaskIdByProid(String proid) {
        String taskid = null;
        try {
            SysTaskService sysTaskService = (SysTaskService)Container.getBean((String)"TaskService");
            List list = sysTaskService.getTaskListByInstance(proid);
            if (list != null && list.size() > 0) {
                taskid = ((PfTaskVo)list.get(0)).getTaskId();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return taskid;
    }
}

