/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.landtax.support.jpa;

import cn.gtmap.landtax.support.jpa.CustomFetch;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.persistence.Entity;
import javax.persistence.ManyToOne;
import javax.persistence.OneToOne;
import org.apache.commons.collections.CollectionUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class BaseRepositoryCustomFetch {
    private String businessName;
    private static HashMap<String, List<String>> entityCustomFetchMap;

    public BaseRepositoryCustomFetch(String businessName) {
        this.businessName = businessName;
        entityCustomFetchMap = new HashMap();
        String packageName = "cn.gtmap." + businessName + ".entity";
        Set classNames = BaseRepositoryCustomFetch.getClassName((String)packageName, (boolean)false);
        if (classNames != null) {
            for (String className : classNames) {
                try {
                    Class<?> clazz = Class.forName(className).newInstance().getClass();
                    if (!clazz.isAnnotationPresent(Entity.class)) continue;
                    List fieldList = BaseRepositoryCustomFetch.getEntityFieldList(clazz);
                    for (Field field : fieldList) {
                        String type = field.getGenericType().toString();
                        if (!type.startsWith("class " + packageName) || !field.isAnnotationPresent(CustomFetch.class) || !field.isAnnotationPresent(ManyToOne.class) && !field.isAnnotationPresent(OneToOne.class)) continue;
                        this.setEntityCustomFetchMap(clazz.getSimpleName(), field.getType().getSimpleName());
                    }
                }
                catch (ClassNotFoundException e) {
                }
                catch (InstantiationException e) {
                }
                catch (IllegalAccessException e) {
                }
            }
        }
        entityCustomFetchMap.size();
    }

    private static List<Field> getEntityFieldList(Class clazz) {
        ArrayList<Field> fieldList = new ArrayList<Field>();
        Field[] fieldArr = null;
        fieldArr = clazz.getDeclaredFields();
        fieldList.addAll(Arrays.asList(fieldArr));
        for (Class superClazz = clazz.getSuperclass(); superClazz != null; superClazz = superClazz.getSuperclass()) {
            fieldArr = superClazz.getDeclaredFields();
            fieldList.addAll(Arrays.asList(fieldArr));
        }
        return fieldList;
    }

    private void setEntityCustomFetchMap(String entityName, String fetchEntityName) {
        if (CollectionUtils.isEmpty((Collection)((Collection)entityCustomFetchMap.get(entityName)))) {
            entityCustomFetchMap.remove(entityName);
            entityCustomFetchMap.put(entityName, new ArrayList());
        }
        if (((List)entityCustomFetchMap.get(entityName)).indexOf(fetchEntityName) == -1) {
            ((List)entityCustomFetchMap.get(entityName)).add(fetchEntityName);
        }
    }

    public List<String> getSubEntityFetchMap(String entityName) {
        if (entityCustomFetchMap == null) {
            return null;
        }
        return (List)entityCustomFetchMap.get(entityName);
    }

    public static Set<String> getClassName(String packageName, boolean isRecursion) {
        String packagePath;
        Set classNames = null;
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        URL url = loader.getResource(packagePath = packageName.replace(".", "/"));
        if (url != null) {
            String protocol = url.getProtocol();
            if (protocol.equals("file")) {
                classNames = BaseRepositoryCustomFetch.getClassNameFromDir((String)url.getPath(), (String)packageName, (boolean)isRecursion);
            } else if (protocol.equals("jar")) {
                JarFile jarFile = null;
                try {
                    jarFile = ((JarURLConnection)url.openConnection()).getJarFile();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (jarFile != null) {
                    BaseRepositoryCustomFetch.getClassNameFromJar(jarFile.entries(), (String)packageName, (boolean)isRecursion);
                }
            }
        } else {
            classNames = BaseRepositoryCustomFetch.getClassNameFromJars((URL[])((URLClassLoader)loader).getURLs(), (String)packageName, (boolean)isRecursion);
        }
        return classNames;
    }

    private static Set<String> getClassNameFromDir(String filePath, String packageName, boolean isRecursion) {
        File[] files;
        HashSet<String> className = new HashSet<String>();
        File file = new File(filePath);
        for (File childFile : files = file.listFiles()) {
            if (childFile.isDirectory()) {
                if (!isRecursion) continue;
                className.addAll(BaseRepositoryCustomFetch.getClassNameFromDir((String)childFile.getPath(), (String)(packageName + "." + childFile.getName()), (boolean)isRecursion));
                continue;
            }
            String fileName = childFile.getName();
            if (!fileName.endsWith(".class") || fileName.contains("$")) continue;
            className.add(packageName + "." + fileName.replace(".class", ""));
        }
        return className;
    }

    private static Set<String> getClassNameFromJar(Enumeration<JarEntry> jarEntries, String packageName, boolean isRecursion) {
        HashSet<String> classNames = new HashSet<String>();
        while (jarEntries.hasMoreElements()) {
            String entryName;
            JarEntry jarEntry = jarEntries.nextElement();
            if (jarEntry.isDirectory() || !(entryName = jarEntry.getName().replace("/", ".")).endsWith(".class") || entryName.contains("$") || !entryName.startsWith(packageName)) continue;
            entryName = entryName.replace(".class", "");
            if (isRecursion) {
                classNames.add(entryName);
                continue;
            }
            if (entryName.replace(packageName + ".", "").contains(".")) continue;
            classNames.add(entryName);
        }
        return classNames;
    }

    private static Set<String> getClassNameFromJars(URL[] urls, String packageName, boolean isRecursion) {
        HashSet<String> classNames = new HashSet<String>();
        for (int i = 0; i < urls.length; ++i) {
            String classPath = urls[i].getPath();
            if (classPath.endsWith("classes/")) continue;
            JarFile jarFile = null;
            try {
                jarFile = new JarFile(classPath.substring(classPath.indexOf("/")));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (jarFile == null) continue;
            classNames.addAll(BaseRepositoryCustomFetch.getClassNameFromJar(jarFile.entries(), (String)packageName, (boolean)isRecursion));
        }
        return classNames;
    }

    public String getBusinessName() {
        return this.businessName;
    }

    public void setBusinessName(String businessName) {
        this.businessName = businessName;
    }
}

