/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.landtax.service.impl;

import cn.gtmap.landtax.entity.SSjZdbgAnaly;
import cn.gtmap.landtax.entity.SSjZdqlr;
import cn.gtmap.landtax.entity.SwDjSy;
import cn.gtmap.landtax.entity.Zd;
import cn.gtmap.landtax.entity.ZdHistory;
import cn.gtmap.landtax.entity.ZdTemp;
import cn.gtmap.landtax.model.dictionary.Hcxmlx;
import cn.gtmap.landtax.service.HcxmService;
import cn.gtmap.landtax.service.WorkFlowService;
import cn.gtmap.landtax.service.ZdService;
import cn.gtmap.landtax.support.jpa.BaseRepository;
import cn.gtmap.landtax.util.CommonUtil;
import cn.gtmap.landtax.util.QueryCondition;
import com.gtis.common.util.UUIDGenerator;
import com.gtis.web.SessionUtil;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ZdServiceImpl
implements ZdService {
    @Autowired
    BaseRepository baseRepository;
    @Autowired
    HcxmService hcxmService;
    @Autowired
    WorkFlowService workFlowService;

    public List zdInput(String djh) throws Exception {
        ArrayList<QueryCondition> paramList = new ArrayList<QueryCondition>();
        paramList.add(new QueryCondition("djh", "=", (Object)djh));
        paramList.add(new QueryCondition("sjzt", "=", (Object)"1"));
        List zdTempList = this.baseRepository.list(ZdTemp.class, paramList);
        return zdTempList;
    }

    @Transactional
    public void updateZd(Zd zd) throws Exception {
        if (zd == null) {
            return;
        }
        if (StringUtils.isBlank((String)zd.getDjh())) {
            return;
        }
        Zd zdOld = (Zd)this.baseRepository.get(Zd.class, (Object)zd.getDjh());
        if (zdOld != null) {
            ZdHistory zdHistory = new ZdHistory();
            BeanUtils.copyProperties((Object)zdHistory, (Object)zdOld);
            zdHistory.setDjhNew(zd.getDjh());
            zdHistory.setUserid(SessionUtil.getCurrentUserId());
            zdHistory.setUsername(SessionUtil.getCurrentUser().getUsername());
            zdHistory.setGxrq(Calendar.getInstance().getTime());
            zdHistory.setHisId(UUIDGenerator.generate());
            this.baseRepository.save((Object)zdHistory);
            this.baseRepository.update((Object)zd);
        } else {
            this.baseRepository.save((Object)zd);
        }
    }

    @Transactional
    public String zdQxXg(ZdTemp zdTemp) throws Exception {
        String djh = zdTemp.getDjh();
        String msg = "";
        ArrayList<QueryCondition> paramList = new ArrayList<QueryCondition>();
        paramList.add(new QueryCondition("djh", "=", (Object)djh));
        paramList.add(new QueryCondition("sjzt", "=", (Object)"1"));
        List zdTempList = this.baseRepository.list(ZdTemp.class, paramList);
        ZdTemp zdTempS = null;
        if (CollectionUtils.isNotEmpty((Collection)zdTempList)) {
            zdTempS = (ZdTemp)zdTempList.get(0);
        }
        if (zdTempS != null) {
            zdTempS.setSjzt("2");
            this.baseRepository.update((Object)zdTempS);
        } else {
            msg = "\u5df2\u6210\u529f\u5165\u5e93\u6216\u5df2\u53d6\u6d88\u4fee\u6539";
        }
        return msg;
    }

    @Transactional
    public void saveTempZd(ZdTemp zdTemp) throws Exception {
        String UUID = UUIDGenerator.generate();
        String djh = zdTemp.getDjh();
        String userId = SessionUtil.getCurrentUserId();
        String username = SessionUtil.getCurrentUser().getUsername();
        Date zdxgrq = Calendar.getInstance().getTime();
        Zd zdOld = (Zd)this.baseRepository.get(Zd.class, (Object)djh);
        ArrayList<QueryCondition> paramlist = new ArrayList<QueryCondition>();
        paramlist.add(new QueryCondition("djh", "=", (Object)djh));
        paramlist.add(new QueryCondition("sjzt", "=", (Object)"1"));
        List listTemp = this.baseRepository.list(ZdTemp.class, paramlist);
        ZdTemp zdTempOld = null;
        if (CollectionUtils.isNotEmpty((Collection)listTemp)) {
            zdTempOld = (ZdTemp)listTemp.get(0);
        }
        if (zdTempOld != null) {
            zdTempOld = (ZdTemp)CommonUtil.copyPropertyForSave((Object)zdTemp, (Object)zdTempOld);
            zdTempOld.setUserid(userId);
            zdTempOld.setUsername(username);
            zdTempOld.setZdxgrq(zdxgrq);
            this.baseRepository.update((Object)zdTempOld);
        } else {
            zdTempOld = new ZdTemp();
            zdTempOld = (ZdTemp)CommonUtil.copyPropertyForSave((Object)zdOld, (Object)zdTempOld);
            zdTempOld = (ZdTemp)CommonUtil.copyPropertyForSave((Object)zdTemp, (Object)zdTempOld);
            zdTempOld.setSjzt("1");
            zdTempOld.setId(UUID);
            zdTempOld.setUserid(userId);
            zdTempOld.setUsername(username);
            zdTempOld.setZdxgrq(zdxgrq);
            this.baseRepository.save((Object)zdTempOld);
        }
    }

    @Transactional(readOnly=true, propagation=Propagation.NOT_SUPPORTED)
    public Zd findZdByDjh(String djh) {
        ArrayList<QueryCondition> queryConditionList = new ArrayList<QueryCondition>();
        queryConditionList.add(new QueryCondition("djh", "like", (Object)djh));
        List zdList = this.baseRepository.list(Zd.class, queryConditionList);
        Zd zd = null;
        if (CollectionUtils.isNotEmpty((Collection)zdList)) {
            zd = (Zd)zdList.get(0);
        }
        return zd;
    }

    @Transactional(readOnly=true, propagation=Propagation.NOT_SUPPORTED)
    public Object getZdPage(Zd zdQuery, Pageable pageable, String proid) {
        ArrayList<QueryCondition> queryConditionList = new ArrayList<QueryCondition>();
        if (StringUtils.isNotBlank((String)zdQuery.getDjh())) {
            queryConditionList.add(new QueryCondition("djh", "like", (Object)zdQuery.getDjh()));
        }
        if (StringUtils.isNotBlank((String)zdQuery.getTdzh())) {
            queryConditionList.add(new QueryCondition("tdzh", "like", (Object)zdQuery.getTdzh()));
        }
        if (StringUtils.isNotBlank((String)zdQuery.getQlrmc())) {
            queryConditionList.add(new QueryCondition("qlrmc", "like", (Object)zdQuery.getQlrmc()));
        }
        if (StringUtils.isNotBlank((String)zdQuery.getTdzl())) {
            queryConditionList.add(new QueryCondition("tdzl", "like", (Object)zdQuery.getTdzl()));
        }
        if (StringUtils.isNotBlank((String)proid)) {
            String hcxmlx = this.workFlowService.getHcxmlx(proid);
            String bdId = this.hcxmService.getCurSwHcXmRwRelByProid(proid).getBdId();
            try {
                ArrayList<QueryCondition> queryConditions = new ArrayList<QueryCondition>();
                if (Hcxmlx.ZDHC.toString().equals(hcxmlx)) {
                    String qlrmc = ((SSjZdqlr)this.baseRepository.get(SSjZdqlr.class, (Object)bdId)).getQlrmc();
                    queryConditions.add(new QueryCondition("qlrmc", "=", (Object)qlrmc));
                    List zdList = this.baseRepository.list(Zd.class, queryConditions);
                    String djhs = "";
                    String djh = "";
                    for (int i = 0; i < zdList.size(); ++i) {
                        djh = "'" + ((Zd)zdList.get(i)).getDjh() + "'";
                        if (StringUtils.isNotEmpty((String)djhs)) {
                            djhs = djhs + ",";
                        }
                        djhs = djhs + djh;
                    }
                    if (StringUtils.isNotEmpty((String)djhs)) {
                        queryConditionList.add(new QueryCondition("djh in (" + djhs + ")"));
                    }
                } else if (Hcxmlx.SYHC.toString().equals(hcxmlx) || Hcxmlx.MJBYZHC.toString().equals(hcxmlx)) {
                    queryConditions.add(new QueryCondition("swDjJbb.jbbId", "=", (Object)bdId));
                    List swDjSyList = this.baseRepository.list(SwDjSy.class, queryConditions);
                    String djhs = "";
                    String djh = "";
                    for (int i = 0; i < swDjSyList.size(); ++i) {
                        djh = "'" + ((SwDjSy)swDjSyList.get(i)).getZd().getDjh() + "'";
                        if (StringUtils.isNotEmpty((String)djhs)) {
                            djhs = djhs + ",";
                        }
                        djhs = djhs + djh;
                    }
                    queryConditionList.add(new QueryCondition("djh in (" + djhs + ")"));
                } else if (Hcxmlx.ZDGXHC.toString().equals(hcxmlx)) {
                    queryConditions.add(new QueryCondition("groupid", "=", (Object)bdId));
                    List sSjZdbgAnalyList = this.baseRepository.list(SSjZdbgAnaly.class, queryConditions);
                    String djhs = "";
                    String djh = "";
                    for (int i = 0; i < sSjZdbgAnalyList.size(); ++i) {
                        djh = "'" + ((SSjZdbgAnaly)sSjZdbgAnalyList.get(i)).getsSjZdbg().getDjhNew() + "'";
                        if (!((SSjZdbgAnaly)sSjZdbgAnalyList.get(i)).getBglx().endsWith("\u5e94\u7a0e\u5b97\u5730")) continue;
                        if (StringUtils.isNotEmpty((String)djhs)) {
                            djhs = djhs + ",";
                        }
                        djhs = djhs + djh;
                    }
                    if (StringUtils.isNotEmpty((String)djhs)) {
                        queryConditionList.add(new QueryCondition("djh in (" + djhs + ")"));
                    } else {
                        queryConditionList.add(new QueryCondition("1=2"));
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return this.baseRepository.find(Zd.class, queryConditionList, null, pageable);
    }
}

