/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.landtax.service.impl;

import cn.gtmap.landtax.entity.Project;
import cn.gtmap.landtax.entity.SSjZdqlr;
import cn.gtmap.landtax.entity.SwDjJbb;
import cn.gtmap.landtax.entity.SwDjSy;
import cn.gtmap.landtax.entity.SwDjSyTemp;
import cn.gtmap.landtax.entity.SwHcXm;
import cn.gtmap.landtax.entity.SwHcXmRwRel;
import cn.gtmap.landtax.model.dictionary.Blzt;
import cn.gtmap.landtax.model.dictionary.Hcxmlx;
import cn.gtmap.landtax.model.dictionary.Sjly;
import cn.gtmap.landtax.model.dictionary.Syzt;
import cn.gtmap.landtax.service.TaxService;
import cn.gtmap.landtax.service.WorkFlowService;
import cn.gtmap.landtax.support.jpa.BaseRepository;
import cn.gtmap.landtax.util.IPlatUtil;
import cn.gtmap.landtax.util.PlatUtil;
import cn.gtmap.landtax.util.QueryCondition;
import cn.gtmap.landtax.util.WorkFlowXml;
import cn.gtmap.landtax.util.WorkFlowXmlUtil;
import com.gtis.common.util.UUIDGenerator;
import com.gtis.plat.service.SysUserService;
import com.gtis.plat.service.WorkFlowCoreService;
import com.gtis.plat.vo.PfOrganVo;
import com.gtis.plat.vo.PfRoleVo;
import com.gtis.plat.vo.PfUserVo;
import com.gtis.plat.vo.PfWorkFlowInstanceVo;
import com.gtis.plat.wf.WorkFlowInfo;
import com.gtis.plat.wf.WorkFlowTransInfo;
import com.gtis.plat.wf.model.ActivityModel;
import com.gtis.plat.wf.model.PerformerModel;
import com.gtis.plat.wf.model.PerformerTaskModel;
import com.gtis.plat.wf.model.TransitionModel;
import com.gtis.web.SessionUtil;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class WorkFlowServiceImpl
implements WorkFlowService {
    @Autowired
    private BaseRepository baseRepository;
    @Autowired
    IPlatUtil platUtil;
    @Autowired
    private HashMap workFlowIdMap;
    @Autowired
    TaxService taxService;
    @Autowired
    WorkFlowCoreService workFlowCoreService;
    @Autowired
    SysUserService sysUserService;

    @Transactional
    public void wfDel(String proid) {
        SwHcXmRwRel swHcXmRwRel = this.getSwHcXmRwRelByWiid(proid);
        Set swDjSyTempSet = swHcXmRwRel.getSwDjSyTempSet();
        ArrayList swDjSyTempList = new ArrayList(swDjSyTempSet);
        for (SwDjSyTemp swDjSyTemp : swDjSyTempList) {
            this.baseRepository.delete((Object)swDjSyTemp);
        }
        this.doUpSwHcXmRwRel(swHcXmRwRel, Blzt.YSC.toString());
        this.doUpSwHcXm(swHcXmRwRel);
    }

    @Transactional
    public void wfEnd(String proid) {
        SwHcXmRwRel swHcXmRwRel = this.getSwHcXmRwRelByWiid(proid);
        Set swDjSyTempSet = swHcXmRwRel.getSwDjSyTempSet();
        ArrayList swDjSyTempList = new ArrayList(swDjSyTempSet);
        SwDjSy swDjSy = null;
        for (SwDjSyTemp swDjSyTemp : swDjSyTempList) {
            if (swDjSyTemp.getSyzt().equals(Syzt.ZC.toString())) {
                swDjSy = (SwDjSy)this.baseRepository.get(SwDjSy.class, (Object)swDjSyTemp.getSyId());
                if (swDjSy != null) {
                    if (!swDjSyTemp.getUpdateRq().after(swDjSy.getUpdateRq())) continue;
                    swDjSy = this.taxService.copyTempToSy(swDjSyTemp);
                    swDjSy.setSjly(Sjly.SYHC.toString());
                    this.taxService.updateSwDjSy(swDjSy);
                    continue;
                }
                swDjSy = this.taxService.copyTempToSy(swDjSyTemp);
                swDjSy.setSjly(Sjly.SYHC.toString());
                this.taxService.updateSwDjSy(swDjSy);
                continue;
            }
            if (swDjSyTemp.getSyzt().equals(Syzt.SC.toString())) {
                swDjSy = (SwDjSy)this.baseRepository.get(SwDjSy.class, (Object)swDjSyTemp.getSyId());
                if (swDjSy != null) {
                    if (!swDjSyTemp.getUpdateRq().after(swDjSy.getUpdateRq())) continue;
                    this.taxService.deleteSwDjSy(swDjSyTemp.getSyId());
                    continue;
                }
                this.baseRepository.delete((Object)swDjSyTemp);
                continue;
            }
            this.baseRepository.delete((Object)swDjSyTemp);
        }
        this.doUpSwHcXmRwRel(swHcXmRwRel, Blzt.YBJ.toString());
        this.doUpSwHcXm(swHcXmRwRel);
    }

    public String wfCreate(String hcxmlx, String id) {
        return this.wfCreate(hcxmlx, id, false);
    }

    @Transactional
    public String wfCreate(String hcxmlx, String id, boolean returnProid) {
        Project project = new Project();
        String wiid = UUIDGenerator.generate();
        project.setProjectId(wiid);
        String wwid = this.workFlowIdMap.get(hcxmlx).toString();
        project.setWdid(wwid);
        project.setBz("");
        String userId = SessionUtil.getCurrentUserId();
        String taskName = "";
        if (hcxmlx.equals(Hcxmlx.ZDHC.toString())) {
            SSjZdqlr sSjZdqlr = (SSjZdqlr)this.baseRepository.get(SSjZdqlr.class, (Object)id);
            taskName = sSjZdqlr.getQlrmc();
        } else {
            SwDjJbb swDjJbb = (SwDjJbb)this.baseRepository.get(SwDjJbb.class, (Object)id);
            taskName = swDjJbb.getNsrmc();
        }
        String taskId = "";
        try {
            taskId = this.platUtil.createWorkFlowInstance(project, userId, taskName);
        }
        catch (Exception e) {
            if (((RuntimeException)e).getMessage().equals("\u8be5\u7528\u6237\u4e0d\u5141\u8bb8\u521b\u5efa\u8be5\u6d41\u7a0b")) {
                taskId = "java.lang:" + ((RuntimeException)e).getMessage().substring(0, ((RuntimeException)e).getMessage().length());
                return taskId;
            }
            throw new RuntimeException();
        }
        SwHcXm swHcXm = new SwHcXm();
        swHcXm.setMc(Hcxmlx.getMcByDm((String)hcxmlx));
        swHcXm.setXmId(UUIDGenerator.generate());
        swHcXm.setCjrq(Calendar.getInstance().getTime());
        swHcXm.setCjrId(SessionUtil.getCurrentUserId());
        swHcXm.setXmlx(hcxmlx);
        swHcXm.setXmybj(Blzt.WBJ.toString());
        this.baseRepository.save((Object)swHcXm);
        String shxrId = UUIDGenerator.generate();
        SwHcXmRwRel swHcXmRwRel = new SwHcXmRwRel();
        swHcXmRwRel.setShxrId(shxrId);
        swHcXmRwRel.setRwId(wiid);
        swHcXmRwRel.setSwHcXm(swHcXm);
        swHcXmRwRel.setBdId(id);
        swHcXmRwRel.setBlzt(Blzt.WBJ.toString());
        this.baseRepository.save((Object)swHcXmRwRel);
        ArrayList<QueryCondition> queryConditionList = new ArrayList<QueryCondition>();
        queryConditionList.add(new QueryCondition("syzt", "=", (Object)Syzt.ZC.toString()));
        if (hcxmlx.equals(Hcxmlx.ZDHC.toString())) {
            SSjZdqlr sSjZdqlr = (SSjZdqlr)this.baseRepository.get(SSjZdqlr.class, (Object)id);
            queryConditionList.add(new QueryCondition("zd.qlrmc", "=", (Object)sSjZdqlr.getQlrmc()));
        } else if (hcxmlx.equals(Hcxmlx.SYHC.toString()) || hcxmlx.equals(Hcxmlx.FCSYHC.toString())) {
            queryConditionList.add(new QueryCondition("swDjJbb.jbbId", "=", (Object)id));
        } else if (hcxmlx.equals(Hcxmlx.MJBYZHC.toString())) {
            queryConditionList.add(new QueryCondition("swDjJbb.jbbId", "=", (Object)id));
        } else if (hcxmlx.equals(Hcxmlx.SBBYZHC.toString())) {
            queryConditionList.add(new QueryCondition("swDjJbb.jbbId", "=", (Object)id));
        }
        List swDjSyList = this.taxService.findSyList(queryConditionList);
        SwDjSyTemp swDjSyTemp = null;
        if (CollectionUtils.isNotEmpty((Collection)swDjSyList)) {
            for (SwDjSy swDjSy : swDjSyList) {
                if (swDjSy.getSwDjTd() == null && swDjSy.getSwDjFc() == null) continue;
                swDjSyTemp = this.taxService.copySyToTemp(swDjSy);
                swDjSyTemp.setSwHcXmRwRel(swHcXmRwRel);
                this.baseRepository.save((Object)swDjSyTemp);
            }
        }
        if (returnProid) {
            taskId = wiid;
        }
        return taskId;
    }

    @Transactional
    public String wfCreateZdgxhc(String hcxmlx, String groupid, List<SwDjSy> swDjSyList) {
        Project project = new Project();
        String wiid = UUIDGenerator.generate();
        project.setProjectId(wiid);
        String wwid = this.workFlowIdMap.get(hcxmlx).toString();
        project.setWdid(wwid);
        project.setBz("");
        String userId = SessionUtil.getCurrentUserId();
        String taskName = Hcxmlx.getMcByDm((String)hcxmlx) + new SimpleDateFormat("yyyy-mm-dd").format(Calendar.getInstance().getTime()) + ":" + groupid;
        if (hcxmlx.equals(Hcxmlx.ZDGXHC.toString())) {
            for (SwDjSy swDjSy : swDjSyList) {
            }
        }
        String taskId = "";
        try {
            taskId = this.platUtil.createWorkFlowInstance(project, userId, taskName);
        }
        catch (Exception e) {
            if (((RuntimeException)e).getMessage().equals("\u8be5\u7528\u6237\u4e0d\u5141\u8bb8\u521b\u5efa\u8be5\u6d41\u7a0b")) {
                taskId = "java.lang:" + ((RuntimeException)e).getMessage().substring(0, ((RuntimeException)e).getMessage().length());
                return taskId;
            }
            throw new RuntimeException();
        }
        SwHcXm swHcXm = new SwHcXm();
        swHcXm.setMc(Hcxmlx.getMcByDm((String)hcxmlx));
        swHcXm.setXmId(UUIDGenerator.generate());
        swHcXm.setCjrq(Calendar.getInstance().getTime());
        swHcXm.setCjrId(SessionUtil.getCurrentUserId());
        swHcXm.setXmlx(hcxmlx);
        swHcXm.setXmybj(Blzt.WBJ.toString());
        this.baseRepository.save((Object)swHcXm);
        String shxrId = UUIDGenerator.generate();
        SwHcXmRwRel swHcXmRwRel = new SwHcXmRwRel();
        swHcXmRwRel.setShxrId(shxrId);
        swHcXmRwRel.setRwId(wiid);
        swHcXmRwRel.setSwHcXm(swHcXm);
        swHcXmRwRel.setBdId(groupid);
        swHcXmRwRel.setBlzt(Blzt.WBJ.toString());
        this.baseRepository.save((Object)swHcXmRwRel);
        SwDjSyTemp swDjSyTemp = null;
        if (CollectionUtils.isNotEmpty(swDjSyList)) {
            for (SwDjSy swDjSy : swDjSyList) {
                if (swDjSy.getSwDjTd() == null && swDjSy.getSwDjFc() == null) continue;
                swDjSyTemp = this.taxService.copySyToTemp(swDjSy);
                swDjSyTemp.setSwHcXmRwRel(swHcXmRwRel);
                this.baseRepository.save((Object)swDjSyTemp);
                swDjSy.setZd(null);
                this.taxService.updateSwDjSy(swDjSy);
            }
        }
        return wiid;
    }

    public String getHcxmlx(String proid) {
        String hcxmlx = "";
        SwHcXmRwRel swHcXmRwRel = this.getSwHcXmRwRelByWiid(proid);
        hcxmlx = swHcXmRwRel.getSwHcXm().getXmlx();
        return hcxmlx;
    }

    public String autoTurnWorkflow(String proid, String userId) {
        String taskidZz = PlatUtil.getTaskIdByProid((String)proid);
        String turnXmlZz = null;
        try {
            turnXmlZz = this.initTurnTaskXml(proid, userId, taskidZz);
            Document docZz = DocumentHelper.parseText((String)turnXmlZz);
            this.workFlowCoreService.turnTask(docZz, taskidZz);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    private void doUpSwHcXmRwRel(SwHcXmRwRel swHcXmRwRel, String blzt) {
        if (StringUtils.isEmpty((String)blzt)) {
            blzt = Blzt.YBJ.toString();
        }
        swHcXmRwRel.setBlzt(blzt);
        this.baseRepository.update((Object)swHcXmRwRel);
    }

    private void doUpSwHcXm(SwHcXmRwRel swHcXmRwRel) {
        SwHcXm swHcXm = swHcXmRwRel.getSwHcXm();
        String xmId = swHcXm.getXmId();
        String jpql = "from SwHcXmRwRel o where o.swHcXm.xmId=?0 and o.blzt='0'";
        List swHcXmRwRelList = this.baseRepository.getByJpql(jpql, new Object[]{xmId});
        if (CollectionUtils.isEmpty((Collection)swHcXmRwRelList)) {
            swHcXm.setXmybj("1");
            this.baseRepository.update((Object)swHcXm);
        }
    }

    @Transactional(readOnly=true)
    private SwHcXmRwRel getSwHcXmRwRelByWiid(String wiid) {
        ArrayList<QueryCondition> queryConditionList = new ArrayList<QueryCondition>();
        queryConditionList.add(new QueryCondition("rwId", "=", (Object)wiid));
        return (SwHcXmRwRel)this.baseRepository.getSingleResult(SwHcXmRwRel.class, queryConditionList);
    }

    private String initTurnTaskXml(String proid, String userId, String taskid) throws Exception {
        WorkFlowInfo info = this.workFlowCoreService.getWorkFlowTurnInfo(userId, taskid);
        WorkFlowTransInfo transInfo = info.getTransInfo();
        List lstTrans = transInfo.getTranActivitys();
        if (lstTrans != null && lstTrans.size() > 0) {
            String nextActivityDefineId = ((ActivityModel)lstTrans.get(0)).getDefineId();
            WorkFlowXml workXml = WorkFlowXmlUtil.getInstanceModel((PfWorkFlowInstanceVo)info.getWorkFlowIntanceVo());
            ActivityModel nextModel = workXml.getActivity(nextActivityDefineId);
            List performerList = nextModel.getPerformerList();
            if (performerList != null && performerList.size() > 0) {
                String roleId = "";
                List roleList = this.sysUserService.getRoleListByUser(userId);
                for (PerformerModel performerModel : performerList) {
                    if (!StringUtils.isNotBlank((String)performerModel.getRoleId())) continue;
                    boolean isok = false;
                    for (PfRoleVo roleVo : roleList) {
                        if (!StringUtils.equals((String)performerModel.getRoleId(), (String)roleVo.getRoleId())) continue;
                        roleId = performerModel.getRoleId();
                        isok = true;
                        break;
                    }
                    if (!isok) continue;
                    break;
                }
                String activityRelType = "";
                activityRelType = transInfo.getTransType().equalsIgnoreCase("and") ? "and" : "or";
                String activitysElement = "<Activitys RelType=\"" + activityRelType + "\"";
                activitysElement = activitysElement + " SendSMS= \"false\"";
                activitysElement = activitysElement + ">";
                String activityElement = "<Activity ";
                activityElement = activityElement + " Id=\"" + nextActivityDefineId + "\">";
                String userInfoElement = "<UserInfo ";
                userInfoElement = userInfoElement + " RoleId=\"" + roleId + "\"";
                userInfoElement = userInfoElement + " Id=\"\">";
                userInfoElement = userInfoElement + "</UserInfo>";
                activityElement = activityElement + userInfoElement;
                activityElement = activityElement + "</Activity>";
                activitysElement = activitysElement + activityElement;
                String remarkElement = "<ReMark>";
                String remarkTextElement = "<text>";
                remarkTextElement = remarkTextElement + "</text>";
                remarkElement = remarkElement + remarkTextElement + "</ReMark>";
                activitysElement = activitysElement + remarkElement + "</Activitys>";
                return activitysElement;
            }
        }
        return null;
    }

    public PerformerTaskModel getTurnUserList(String userId, String proid) throws Exception {
        PerformerTaskModel result = new PerformerTaskModel();
        try {
            String taskid = PlatUtil.getTaskIdByProid((String)proid);
            if (StringUtils.isNotBlank((String)taskid)) {
                WorkFlowInfo info = this.workFlowCoreService.getWorkFlowTurnInfo(userId, taskid);
                WorkFlowXml workXml = WorkFlowXmlUtil.getInstanceModel((PfWorkFlowInstanceVo)info.getWorkFlowIntanceVo());
                String activityDefinitionId = info.getSourceActivity().getActivityDefinitionId();
                ActivityModel activityModel = workXml.getActivity(activityDefinitionId);
                List lstTrans = activityModel.getTransitionsList();
                ArrayList tranActivitys = new ArrayList();
                for (TransitionModel transModel : lstTrans) {
                    String nextActivityDefineId = transModel.getToId();
                    ActivityModel nextModel = workXml.getActivity(nextActivityDefineId);
                    List performerList = nextModel.getPerformerList();
                    for (PerformerModel performerModel : performerList) {
                        List users;
                        if (!performerModel.getUserId().equals("")) {
                            String userid = performerModel.getUserId();
                            PfUserVo userVo = this.sysUserService.getUserVo(userid);
                            List organs = this.sysUserService.getOrganListByUser(userVo.getUserId());
                            result.setName(((PfOrganVo)organs.get(0)).getOrganName());
                            result.setId("0");
                            result.getUserList().add(userVo);
                            result.setType("User");
                            continue;
                        }
                        if (!performerModel.getOrganId().equals("")) {
                            users = this.sysUserService.getUserListByOragn(performerModel.getOrganId());
                            PfOrganVo organVo = this.sysUserService.getOrganVo(performerModel.getOrganId());
                            if (organVo != null) {
                                result.setName(organVo.getOrganName());
                                result.setId(organVo.getOrganId());
                                for (PfUserVo vo : users) {
                                    result.getUserList().add(vo);
                                }
                            }
                            result.setType("Organ");
                            continue;
                        }
                        if (performerModel.getRoleId().equals("")) continue;
                        users = this.sysUserService.getUserListByRole(performerModel.getRoleId());
                        PfRoleVo roleVo = this.sysUserService.getRoleVo(performerModel.getRoleId());
                        result.setName(roleVo.getRoleName());
                        result.setId(roleVo.getRoleId());
                        for (PfUserVo vo : users) {
                            result.getUserList().add(vo);
                        }
                        result.setType("Role");
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }
}

