/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.landtax.service.impl;

import cn.gtmap.landtax.entity.SDmDwxxCz;
import cn.gtmap.landtax.entity.SwDjSy;
import cn.gtmap.landtax.model.dictionary.Dwjb;
import cn.gtmap.landtax.service.DwxxService;
import cn.gtmap.landtax.support.jpa.BaseRepository;
import cn.gtmap.landtax.util.QueryCondition;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DwxxServiceImpl
implements DwxxService {
    @Autowired
    BaseRepository baseRepository;

    @Transactional(readOnly=true)
    public List<SDmDwxxCz> getAllDwxx() {
        SDmDwxxCz sDmDwxxCz = new SDmDwxxCz();
        return this.baseRepository.list(SDmDwxxCz.class, null);
    }

    public SDmDwxxCz getDwxxByDwdm(String dwdm) {
        return (SDmDwxxCz)this.baseRepository.get(SDmDwxxCz.class, (Object)dwdm);
    }

    public SDmDwxxCz getCityByDwdm(String dwdm) {
        ArrayList<QueryCondition> queryConditionList = new ArrayList<QueryCondition>();
        queryConditionList.add(new QueryCondition("dwdm", "=", (Object)dwdm));
        queryConditionList.add(new QueryCondition("dwjb", "=", (Object)Dwjb.DS.toString()));
        List list = this.baseRepository.list(SDmDwxxCz.class, queryConditionList);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            return (SDmDwxxCz)list.get(0);
        }
        return null;
    }

    public List<SDmDwxxCz> getCountiesByDwdm(String dwdm) {
        SDmDwxxCz sDmDwxxCz = new SDmDwxxCz();
        ArrayList<QueryCondition> queryConditionList = new ArrayList<QueryCondition>();
        queryConditionList.add(new QueryCondition("dwdm", "like", (Object)dwdm));
        queryConditionList.add(new QueryCondition("dwjb", "=", (Object)Dwjb.QX.toString()));
        return this.baseRepository.list(SDmDwxxCz.class, queryConditionList);
    }

    public List<SDmDwxxCz> getAllQxList() {
        List allDwxxList = this.getAllDwxx();
        ArrayList<SDmDwxxCz> qxDwxxList = new ArrayList<SDmDwxxCz>();
        for (SDmDwxxCz tempVo : allDwxxList) {
            if (tempVo.getDwdm().length() != 6) continue;
            qxDwxxList.add(tempVo);
        }
        return qxDwxxList;
    }

    public List<SDmDwxxCz> getJdByQx(String qx) {
        SDmDwxxCz sDmDwxxCz = new SDmDwxxCz();
        ArrayList<QueryCondition> queryConditionList = new ArrayList<QueryCondition>();
        queryConditionList.add(new QueryCondition("dwdm", "like", (Object)qx));
        queryConditionList.add(new QueryCondition("dwjb", "=", (Object)Dwjb.XZJD.toString()));
        return this.baseRepository.list(SDmDwxxCz.class, queryConditionList);
    }

    public List<SDmDwxxCz> getJfByJd(String jd) {
        SDmDwxxCz sDmDwxxCz = new SDmDwxxCz();
        ArrayList<QueryCondition> queryConditionList = new ArrayList<QueryCondition>();
        queryConditionList.add(new QueryCondition("dwdm", "like", (Object)jd));
        queryConditionList.add(new QueryCondition("dwjb", "=", (Object)Dwjb.CJF.toString()));
        return this.baseRepository.list(SDmDwxxCz.class, queryConditionList);
    }

    @Transactional(readOnly=true)
    public Page<SwDjSy> getSwdjSy(Pageable pageable) {
        SwDjSy swDjSy = new SwDjSy();
        if (pageable == null) {
            pageable = new PageRequest(1, 4);
        }
        ArrayList<QueryCondition> queryConditionList = new ArrayList<QueryCondition>();
        queryConditionList.add(new QueryCondition("swDjJbb.nsrmc", "=", (Object)"\u5e38\u719f\u5e02\u6c5f\u8d38\u7269\u8d44\u6709\u9650\u8d23\u4efb\u516c\u53f8"));
        return this.baseRepository.find(SwDjSy.class, queryConditionList, null, pageable);
    }
}

