﻿-- 更新征管系统纳税人信息数据
UPDATE SW_DJ_JBB t SET (t.NSRMC, t.ZCLX_DM, t.ZGSWJG_DM, t.ZGSWJG_MC, t.NSRZT_DM, t.HY_DM, t.ZCDZ, t.FDDBR, t.FDDBRZJHM) = 
(SELECT TO_CHAR(t1.NSR_MC) AS NSRMC, TO_CHAR(t1.DJZCLX_DM) AS ZCLX_DM, 
        TO_CHAR(t1.GLJG_DM) AS ZGSWJG_DM, TO_CHAR(t3.MC) AS ZGSWJG_MC, TO_CHAR(t1.NSRZT_DM) AS NSRZT_DM, 
        TO_CHAR(t1.GBHY_DM) AS HY_DM, TO_CHAR(t1.ZCDZ) AS ZCDZ, TO_CHAR(t2.XM) AS FDDBR, TO_CHAR(t2.ZJH) AS FDDBRZJHM 
 FROM T_DJ_JGNSR t1
      LEFT JOIN (SELECT * 
                 FROM T_DJ_RYQKB
                 WHERE RYLX_DM='05'
                ) t2 ON t1.SWGLM=t2.SWGLM
      LEFT JOIN T_DM_GY_SWJG t3 ON t1.GLJG_DM=t3.SWJG_DM
 WHERE t.SWGLM=t1.SWGLM
) 
WHERE EXISTS (SELECT t1.SWGLM FROM T_DJ_JGNSR t1 WHERE t.SWGLM=t1.SWGLM);
-- 插入新增的征管系统纳税人信息数据
INSERT INTO SW_DJ_JBB (SWGLM, NSRMC, ZCLX_DM, ZGSWJG_DM, ZGSWJG_MC, NSRZT_DM, HY_DM, ZCDZ, FDDBR, FDDBRZJHM)
SELECT TO_CHAR(t.SWGLM) AS SWGLM, TO_CHAR(t.NSR_MC) AS NSRMC, TO_CHAR(t.DJZCLX_DM) AS ZCLX_DM, 
       TO_CHAR(t.GLJG_DM) AS ZGSWJG_DM, TO_CHAR(t2.MC) AS ZGSWJG_MC, TO_CHAR(t.NSRZT_DM) AS NSRZT_DM, 
       TO_CHAR(t.GBHY_DM) AS HY_DM, TO_CHAR(t.ZCDZ) AS ZCDZ, TO_CHAR(t1.XM) AS FDDBR, TO_CHAR(t1.ZJH) AS FDDBRZJHM 
FROM T_DJ_JGNSR t
     LEFT JOIN (SELECT * 
                FROM T_DJ_RYQKB
                WHERE RYLX_DM='05'
               ) t1 ON t.SWGLM=t1.SWGLM
     LEFT JOIN T_DM_GY_SWJG t2 ON t.GLJG_DM=t2.SWJG_DM
     LEFT JOIN SW_DJ_JBB t3 ON t.SWGLM=t3.SWGLM
WHERE t3.SWGLM IS NULL;

-- 更新征管系统土地税源数据
UPDATE SW_DJ_TD t SET (t.SJDM, t.XJDM, t.XZDM, t.TDZH, t.TDZL, t.TDMJ) =
(SELECT TO_CHAR(t1.TDQY_SJDM) AS SJDM, TO_CHAR(t1.TDQY_XJDM) AS XJDM, 
        TO_CHAR(t1.XZJD_DM) AS XZDM, TO_CHAR(t1.TDZ_HM) AS TDZH, TO_CHAR(t1.TD_DZ) AS TDZL, t1.TD_MJ AS TDMJ
 FROM T_FT_ZD t1
 WHERE t.TD_BM=t1.TD_BM
)
WHERE EXISTS (SELECT t1.TD_BM FROM T_FT_ZD t1 WHERE t.TD_BM=t1.TD_BM);
-- 插入新增的征管系统土地税源数据
INSERT INTO SW_DJ_TD (SY_ID, TD_BM, SJDM, XJDM, XZDM, TDZH, TDZL, TDMJ)  
SELECT  SYS_GUID() AS SY_ID, TO_CHAR(t.TD_BM) AS TD_BM, TO_CHAR(t.TDQY_SJDM) AS SJDM, TO_CHAR(t.TDQY_XJDM) AS XJDM, 
        TO_CHAR(t.XZJD_DM) AS XZDM, TO_CHAR(t.TDZ_HM) AS TDZH, TO_CHAR(t.TD_DZ) AS TDZL, t.TD_MJ AS TDMJ
FROM T_FT_ZD t
     LEFT JOIN SW_DJ_TD t1 ON t.TD_BM=t1.TD_BM
WHERE t1.TD_BM IS NULL; 


-- 更新征管系统房产税源数据
UPDATE SW_DJ_FC t SET (t.TD_BM, t.SJDM, t.XJDM, t.XZDM, t.CQSYR_MC, t.FCZH, t.FWZL, t.JZ_MJ, t.CZ_MJ) =
(SELECT TO_CHAR(t1.TD_BM) AS TD_BM, TO_CHAR(t1.XZQHDS_DM) AS SJDM, TO_CHAR(t1.XZQHXQ_DM) AS XJDM, 
        TO_CHAR(t1.XZJD_DM) AS XZDM, TO_CHAR(t1.CQSYR_MC) AS CQSYR_MC, TO_CHAR(t1.CQZSH) AS FCZH, TO_CHAR(t1.FWZL) AS FWZL,
        t1.JZ_MJ, t1.CZ_MJ
 FROM T_FT_ZYFW t1
 WHERE t1.DJ_ZT='01' AND t.FY_BM=t1.FY_BM
)
WHERE EXISTS (SELECT t1.FY_BM FROM T_FT_ZYFW t1 WHERE t.FY_BM=t1.FY_BM);
-- 插入新增的征管系统房产税源数据
INSERT INTO SW_DJ_FC (SY_ID, FY_BM, TD_BM, SJDM, XJDM, XZDM, CQSYR_MC, FCZH, FWZL, JZ_MJ, CZ_MJ)   
SELECT SYS_GUID() AS SY_ID, TO_CHAR(t.FY_BM) AS FY_BM, TO_CHAR(t.TD_BM) AS TD_BM, TO_CHAR(t.XZQHDS_DM) AS SJDM, TO_CHAR(t.XZQHXQ_DM) AS XJDM, 
       TO_CHAR(t.XZJD_DM) AS XZDM, TO_CHAR(t.CQSYR_MC) AS CQSYR_MC, TO_CHAR(t.CQZSH) AS FCZH, TO_CHAR(t.FWZL) AS FWZL,
       t.JZ_MJ, t.CZ_MJ
FROM T_FT_ZYFW t
     LEFT JOIN SW_DJ_FC t1 ON t.FY_BM=t1.FY_BM
WHERE t.DJ_ZT='01' AND t.FY_BM IN (SELECT FY_BM FROM T_FT_ZYFW WHERE TD_BM IS NULL 
                                   UNION 
                                   SELECT MIN(FY_BM) FROM T_FT_ZYFW WHERE TD_BM IS NOT NULL GROUP BY TD_BM)
      AND t1.FY_BM IS NULL; 
-- 更新房产税源与土地税源数据的关联关系
UPDATE SW_DJ_FC t SET t.SY_ID = (SELECT t1.SY_ID FROM SW_DJ_TD t1 WHERE t.TD_BM=t1.TD_BM)
WHERE  t.TD_BM IS NOT NULL AND EXISTS (SELECT t1.SY_ID FROM SW_DJ_TD t1 WHERE t.TD_BM=t1.TD_BM); 

-- 更新税源数据与国土宗地关系数据
INSERT INTO SW_DJ_SY (SY_ID, SWGLM, SJLY, SYZT) 
SELECT t.SY_ID, TO_CHAR(t.SWGLM) AS SWGLM, '0' AS SJLY, '1' AS SYZT
FROM (SELECT t.SY_ID, t1.SWGLM FROM SW_DJ_TD t LEFT JOIN T_FT_ZD t1 ON t.TD_BM=t1.TD_BM
      UNION
      SELECT t.SY_ID, t1.SWGLM FROM SW_DJ_FC t LEFT JOIN (SELECT * FROM T_FT_ZYFW WHERE DJ_ZT='01') t1 ON t.FY_BM=t1.FY_BM
     ) t 
     LEFT JOIN SW_DJ_SY t1 ON t.SY_ID=t1.SY_ID
WHERE t1.SY_ID IS NULL;

-- 根据纳税人状态更新税源状态
UPDATE SW_DJ_SY t SET t.SYZT='2'
WHERE t.SYZT='1' AND EXISTS (SELECT t1.SWGLM FROM SW_DJ_JBB t1 WHERE t.SWGLM=t1.SWGLM AND SUBSTR(t1.NSRZT_DM, 1, 1) = '5');
