﻿-- 更新宗地数据
UPDATE ZD t SET (t.DJH, t.TDZL, t.TDYT, t.SCMJ, t.XZQDM, t.QLRMC, t.TDZH, t.FDDBR, t.FDDBRZJHM, t.TDYTMC) =
(
SELECT t1.DJH, t1.TDZL, t1.TDYT, t1.SCMJ, t1.XZQDM,
       t2.QLRMC, t2.TDZH, t2.FRDBXM AS FDDBR, t2.FRDBZJH AS FDDBRZJHM,
       t3.MC AS TDYTMC 
FROM ZD_K_320581 t1
     LEFT JOIN (SELECT DJH, WM_CONCAT(DISTINCT TO_CHAR(TRIM(TDZH))) AS TDZH, WM_CONCAT(DISTINCT TO_CHAR(QLRMC)) AS QLRMC,
                       MAX(TO_CHAR(TRIM(FRDBXM))) AS FRDBXM, MAX(TO_CHAR(TRIM(FRDBZJH))) AS FRDBZJH
                FROM ZD_QLR
                GROUP BY DJH
               ) t2 ON t1.DJH=t2.DJH
     LEFT JOIN S_ZD_DLDM t3 ON t1.TDYT=t3.DM
WHERE t.DJH=t1.DJH
)
WHERE EXISTS (SELECT t1.DJH FROM ZD_K_320581 t1 WHERE t.DJH=t1.DJH) 
      AND NOT EXISTS (SELECT t2.DJH FROM ZD_HISTORY t2);
-- 把消失的宗地信息保存到历史表
INSERT INTO ZD_HISTORY (DJH, TDZL, TDYT, SCMJ, XZQDM, QLRMC, TDZH, FDDBR, FDDBRZJHM, TDYTMC, USERNAME, USERID, ZDXGRQ, UUID)
SELECT t.DJH, t.TDZL, t.TDYT, t.SCMJ, t.XZQDM, t.QLRMC, t.TDZH, t.FDDBR, t.FDDBRZJHM, t.TDYTMC,
       '系统' AS USERNAME, '' AS USERID, SYSDATE AS ZDXGRQ, SYS_GUID() AS UUID
FROM ZD t
WHERE t.DJH NOT IN (SELECT DJH FROM ZD_K_320581 WHERE DJH IS NOT NULL);
-- 撤销消失宗地与税源数据的关联关系
UPDATE SW_DJ_SY t SET (t.GT_BM, t.GTLY, t.SJLY)=(SELECT NULL AS GT_BM, NULL AS GTLY, '0' AS SJLY FROM DUAL)
WHERE t.GT_BM IS NOT NULL AND NOT EXISTS (SELECT t1.DJH FROM ZD_K_320581 t1 WHERE t.GT_BM=t1.DJH);
-- 将消失宗地信息删除
DELETE FROM ZD t WHERE NOT EXISTS (SELECT t1.DJH FROM ZD_K_320581 t1 WHERE t.DJH=t1.DJH);

-- 清空数据挂接用宗地数据表记录
DELETE FROM ZD_SJGJ;
-- 更新数据挂接用宗地数据表数据
INSERT INTO ZD_SJGJ (SJGJ_ID, DJH, TDYT, TDYTMC, FDDBR, FDDBRZJHM, XZQDM, SCMJ, QLRMC, TDZH, TDZL) 
SELECT SYS_GUID() AS SJGJ_ID, TO_CHAR(t.DJH) AS DJH, TO_CHAR(t.TDYT) AS TDYT, TO_CHAR(t.TDYTMC) AS TDYTMC,
       TO_CHAR(t.FDDBR) AS FDDBR, TO_CHAR(t.FDDBRZJHM) AS FDDBRZJHM, TO_CHAR(t.XZQDM) AS XZQDM, t.SCMJ,  
       TO_CHAR(DECODE(t1.QLR, NULL, t.QLRMC, t1.QLR)) AS QLRMC,
       TO_CHAR(DECODE(t1.TDZH, NULL, t.TDZH, t1.TDZH)) AS TDZH,
       TO_CHAR(DECODE(t1.ZL, NULL, t.TDZL, t1.ZL)) AS TDZL
FROM ZD t
     LEFT JOIN (
                SELECT DJH, QLR, TDZH, ZL FROM TBL_GYTDSYZ
                UNION ALL 
                SELECT DJH, QLR, TDZH, ZL FROM TBL_JTTDSYZ
               ) t1 ON t.DJH=t1.DJH;
