/**
 * 封装了jqGrid
 */
(function($){
    var config = {
        id: "tg1",
        width: "1300",
        renderTo: "topdiv",
        headerAlign: "left",
        headerHeight: "43",
        dataAlign: "left",
        indentation: "20",
        folderOpenIcon: "../static/thirdparty/treegrid/images/zk.png",
        folderCloseIcon: "../static/thirdparty/treegrid/images/wzk.png",
        defaultLeafIcon: "../static/thirdparty/treegrid/images/point.png",
        hoverRowBackground: "false",
        folderColumnIndex: "0",
        itemClick: "itemClickEvent"
       // columns:colmu,
     /*   data:[
            {"name": "城区分公司", counts: "200", ppcount: "12",zzpp:"20",rgpp:"1",wpp:"21", children:[
                {name: "城区卡品分销中心",counts: "200", ppcount: "12",zzpp:"20",rgpp:"1",wpp:"21"},
                {name: "先锋服务厅",counts: "200", ppcount: "12",zzpp:"20",rgpp:"1",wpp:"21", children:[
                    {name: "chlid1",counts: "200", ppcount: "12",zzpp:"20",rgpp:"1",wpp:"21"},
                    {name: "chlid2", counts: "200", ppcount: "12",zzpp:"20",rgpp:"1",wpp:"21", children:[]},
                    {name: "chlid3",counts: "200", ppcount: "12",zzpp:"20",rgpp:"1",wpp:"21", children: [
                        {name: "chlid3-1", counts: "200", ppcount: "12",zzpp:"20",rgpp:"1",wpp:"21"},
                        {name: "chlid3-2", counts: "200", ppcount: "12",zzpp:"20",rgpp:"1",wpp:"21"},
                        {name: "chlid3-3", counts: "200", ppcount: "12",zzpp:"20",rgpp:"1",wpp:"21"},
                        {name: "chlid3-4", counts: "200", ppcount: "12",zzpp:"20",rgpp:"1",wpp:"21"}
                    ]}
                ]},
                {name: "半环服务厅",counts: "200", ppcount: "12",zzpp:"20",rgpp:"1",wpp:"21"}
            ]},
            {name: "清新分公司", counts: "200", ppcount: "12",zzpp:"20",rgpp:"1",wpp:"21", children:[]},
            {name: "英德分公司", counts: "200", ppcount: "12",zzpp:"20",rgpp:"1",wpp:"21", children:[]},
            {name: "佛冈分公司", counts: "200", ppcount: "12",zzpp:"20",rgpp:"1",wpp:"21", children:[]}
        ]*/
    };

    var treegrid;

    function initGrid(options) {
       // treegrid=jQuery(options.grid_selector).jqGrid(options);
        //创建一个组件对象
        treeGrid = new TreeGrid(options);
        treeGrid.show();
        treeGrid.expandAll("N");
    }


    $.fn.gtreeGrid = function(options){
        var options = $.extend(config,options);
        return this.each(function(){
            var gridDefAtt = $(this).attr('data-definition');
            options.gridDefinitionUrl = (gridDefAtt!=null&&gridDefAtt!='')?gridDefAtt:options.gridDefinition;
            if(options.gridDefinitionUrl!=null&&options.gridDefinitionUrl!=''){
                $.getJSON(options.gridDefinitionUrl, function(data){
                    var url  ="" ;

                    if(options.url==null || options.url==""){
                        options.url  = data.baseUrl;
                        url = data.baseUrl;
                    }else{
                        url =options.url;
                    }
                    options.columns = data.colNames;
                    $.ajax({
                        url : url,
                        cache : false,
                        async : false,
                        type : "POST",
                        dataType : 'json',
                        success : function (result){
                            //alert(result);
                            options.data=result;
                            initGrid(options);
                        } ,
                        error:function(error){
                           //alert("3232");
                        }
                    });
                    //initGrid(options);

                });
            }


        });
    };

    $.fn.getTreeGrid = function(){
        return treegrid;
    }



})(jQuery);

/*
 单击数据行后触发该事件
 id：行的id
 index：行的索引。
 data：json格式的行数据对象。
 */
function itemClickEvent(id, index, data){
    jQuery("#currentRow").val(id + ", " + index + ", " + TreeGrid.json2str(data));
}


/*
 通过指定的方法来自定义栏数据
 */
function customCheckBox(row, col){
    return "<input type='checkbox'>";
}

function customOrgName(row, col){
    var name = row[col.dataField] || "";
    return name;
}

function customLook(row, col){

    return "<a href='' style='color:blue;'>查看</a>";
}

function notpp(row, col){
   // alert(row[col.dataField]);
    var name = row["xzqdm"] || "";
   // alert(name) ;
    return "<a href='javascript:void(0)' onclick='showWppList(\""+name+"\")' style='color:blue'>未关联登记核查</a>";
}

/*function showWppList(xzq){
    alert(xzq);
}*/

function tpp(row, col){
    var name = row["xzqdm"] || "";
    return "<a href='javascript:void(0)' onclick='showyppList(\""+name+"\")' style='color:blue'>已关联登记核查</a>";
}

/*
function showyppList(xzq){
    alert(xzq);
}
*/

/*
 展开、关闭所有节点。
 isOpen=Y表示展开，isOpen=N表示关闭
 */
function expandAll(isOpen){
    treeGrid.expandAll(isOpen);
}

/*
 取得当前选中的行，方法返回TreeGridItem对象
 */
function selectedItem(){
    var treeGridItem = treeGrid.getSelectedItem();
    if(treeGridItem!=null){
        //获取数据行属性值
        //alert(treeGridItem.id + ", " + treeGridItem.index + ", " + treeGridItem.data.name);

        //获取父数据行
        var parent = treeGridItem.getParent();
        if(parent!=null){
            //jQuery("#currentRow").val(parent.data.name);
        }

        //获取子数据行集
        var children = treeGridItem.getChildren();
        if(children!=null && children.length>0){
            jQuery("#currentRow").val(children[0].data.name);
        }
    }
}

