define(["dojo/_base/declare","dojo/_base/lang",'esri/graphic', 'esri/tasks/QueryTask','esri/tasks/query',
	"dojo/on","widgetUtils","../mapUtils","slimScroll"], function(declare,lang,Graphic,QueryTask,Query,on,widgetUtils,mapUtils,slimScroll) {
    return declare([],{
        map:null,
        moduleConfig:null,
        template:null,
        title:'<i class="pink ace-icon fa fa-globe"></i>税源',
        _identifyHandle:null,
        constructor:function(args){
            declare.safeMixin(this,args);
            if(this.template==null)
               this.template = landtaxUrl+'/static/js/map/modules/zdIdentify/zdSy.tpl';

        },
        identifyTool:function(){
            this._identifyHandle=on(this.map, "click", lang.hitch(this,this._doIdentify));
            this.map.setMapCursor('crosshair');
            mapUtils.setMap(this.map);

        },
        destroyIdentifyTool:function(){
            if(this._identifyHandle!=null)
               this._identifyHandle.remove();
        },
        _queryMapLayer:function(mapLayerUrl,geometry, where, outFields,returnGeometry){
            var queryTask = new QueryTask(mapLayerUrl);
            var query = new Query();
            if (where != null)
                query.where = where;
            if (geometry != null)
                query.geometry = geometry;
            query.returnGeometry = returnGeometry;
            if (outFields == null)
                query.outFields = ['*'];
            else
                query.outFields = outFields;
            on(queryTask, 'complete', lang.hitch(this,this._queryResultHandler));
            on(queryTask, 'error', this._queryResultError);
            queryTask.execute(query);
        },
        _queryResultError:function(event){
            alert(event.error);
        },
        _queryResultHandler:function(event) {
            this.map.setMapCursor('default');
            widgetUtils.setDynamicTabTitle(this.title);
            widgetUtils.clearDynamicTab();
            widgetUtils.changeToDynamicTab();
            if (event.featureSet.features != null && event.featureSet.features.length > 0) {
                var feature = event.featureSet.features[0];
                mapUtils.highlightFeatures(event.featureSet.features);
                var tmpDjh = feature.attributes['DJH'];

                $.getJSON(landtaxUrl+'/ts/djh?djh='+tmpDjh,lang.hitch(this,function(result){
                    this._getWidgetTemplate({syList:result});
                }));
            }
        },

        _doIdentify:function(event) {
            this.map.graphics.clear();
            this.map.setMapCursor('wait');

            var mapLayerUrl = this._getZtLayerUrl();
            var returnFields = ['DJH'];
            this._queryMapLayer(mapLayerUrl,event.mapPoint,null,returnFields,true);
            this.destroyIdentifyTool();
        },
        _getZtLayerUrl:function(){
            var tmpXzqdm = '';
            if(this.map.filterByRegion)
               tmpXzqdm = this.map.xzqdm||'default';
            else
                tmpXzqdm = 'default';
            return this.map.getLayer(this.moduleConfig[tmpXzqdm].zdServiceId).url+'/'+this.moduleConfig[tmpXzqdm].zdLayerIndex;
        },
        _taxDetailClickHandle:function(event){
            var taxId=$(event.target).attr('data-tax');
            var taxIds = taxId.split(';');
            window.open(landtaxUrl+'/ts/taxMap?tdId='+taxIds[0]+"&fcId="+taxIds[1]);
        },
        _getWidgetTemplate:function(data){
            $.get(this.template,lang.hitch(this,this._renderWidgetTemplate,data));
        },
        _renderWidgetTemplate:function(data,template){
            widgetUtils.renderDynamicWidget(template,data);
            on($('a[data-tax]'),'click',this._taxDetailClickHandle);
            $('#clearZdSy').click(function(){
                $('#zdSyContent').empty();
                mapUtils.clearMapGraphics();
            });
        }
    });
});