﻿define(["jquery","dojo/_base/declare",
    "dojo/_base/lang","dojo/on",'mustache',"mapUtils",'esri/tasks/QueryTask','esri/tasks/query'
], function($,declare,lang,on,Mustache,mapUtils,QueryTask,Query) {
    var taxItemTpl="taxItemTpl";
    var pageTpl="pageTpl";
    var zdInfoTpl="ztInfoTpl";
    var mapFilterByRegion=false;
    var operationalLayersConfig=null;
    var currentXzqdm=null;
    var postTaxSearch=function(url,value,moduleConfig){
        $.ajax({
            type:'POST',
            url:url,
            data:value,
            dataType:'json',
            success:function(data){
                $('#queryContent').empty();
                $('#contentPaginator').empty();
                $('#resultCount').text(data.totalElements);
                var itemTemplate = $('#'+taxItemTpl).html();
                var paginatorTemplate = $('#'+pageTpl).html();
                Mustache.parse(itemTemplate);
                Mustache.parse(paginatorTemplate);
                for(var i in data.content){
                    var taxInfo = data.content[i];
                    if (!taxInfo.syId)
                        continue;
                    var tmpItem = Mustache.render(itemTemplate,taxInfo);
                    $('#queryContent').append(tmpItem);
                    on($('#loc'+taxInfo.syId),'click',lang.hitch(this,locationClickHandle,moduleConfig));
                    on($('#detail'+taxInfo.syId),'click',taxDetailBySyId);
                }
                var currentPageNum = data.number;
                var totalPages = data.totalPages;
                var paginatorData = {};
                if(data.lastPage!=null&&data.lastPage==true)
                    paginatorData.nextDisabled=true;
                else
                    paginatorData.nextDisabled=false;
                if(currentPageNum!=null&&currentPageNum==1)
                    paginatorData.preDisabled=true;
                else
                    paginatorData.preDisabled=false;

                paginatorData.pageNumList=[];
                var pageStart =1;
                if(currentPageNum>=5)
                    pageStart=currentPageNum-3;
                pageStart = pageStart < 1 ? 1 : pageStart;
                var i=0;
                for (i = 0;i <5; i = i + 1) {
                    var tmpPageNum = pageStart+i;
                    if(tmpPageNum<=totalPages){
                        var isActive = false;
                        if(tmpPageNum==currentPageNum)
                            isActive = true;
                        var pageNumObj = {pageNum:tmpPageNum,isActive:isActive};
                        paginatorData.pageNumList.push(pageNumObj);
                    }
                }
                var preItem = Mustache.render(paginatorTemplate,paginatorData);
                $('#contentPaginator').append(preItem);
                $('#contentPaginator>li>a').click(function(event){
                    if( $(event.target).has('i').length>0||$(event.target)[0].tagName==='I'){
                        if($(event.target).has('i').length>0){
                            $(event.target).find('i').each(function(){
                                if($(this).hasClass('ace-icon fa fa-angle-double-left'))
                                    value.page = currentPageNum-1;
                                else
                                    value.page = currentPageNum+1;
                                postTaxSearch(url,value,moduleConfig);
                                return;
                            });
                        }else{
                            if($(event.target).hasClass('ace-icon fa fa-angle-double-left'))
                                value.page = currentPageNum-1;
                            else
                                value.page = currentPageNum+1;
                            postTaxSearch(url,value,moduleConfig);
                        }
                    }else{
                        value.page =  $(event.target).text();
                        postTaxSearch(url,value,moduleConfig);
                    }
                });
            }
        });
    };
    var locationClickHandle=function(moduleConfig,event){
        modifyReusltItemClass(event.target);
        var djh=$(event.target).attr('data-djh');
        locationByDjh(moduleConfig,djh);
    };
    var taxDetailBySyId=function(event){
        var taxId=$(event.target).attr('data-tax');
        var taxIds = taxId.split(';');
        window.open(landtaxUrl+'/ts/taxMap?tdId='+taxIds[0]+"&fcId="+taxIds[1]);
    };


    var taxDetailClickHandle=function(event){
        var djh=$(event.target).attr('data-djh');
        window.open(landtaxUrl+'/tj/baseTj?tag=tdsList&customParams=[{"djh":"'+djh+'"},{"djh":"="}]');
    };
    var locationByDjh=function(moduleConfig,djh){
        var tmpXzqdm = djh.substr(0,6);
        var zdServiceId = moduleConfig[tmpXzqdm].zdServiceId;
        var zdLayerIndex = moduleConfig[tmpXzqdm].zdLayerIndex;
        var mapServiceIds=moduleConfig[tmpXzqdm].mapServiceIds;
        var mapSrid = moduleConfig[tmpXzqdm].srid;
        if(currentXzqdm==null)
            currentXzqdm = $('#xzqdm').val();
        if(mapFilterByRegion){
            if(currentXzqdm!=tmpXzqdm){
                var mapLayersConfig=[];
                for(var i in operationalLayersConfig){
                    var tmpOperationalLayerId= operationalLayersConfig[i].id;
                    if(mapServiceIds.indexOf(tmpOperationalLayerId)>-1){
                        mapLayersConfig[mapServiceIds.indexOf(tmpOperationalLayerId)]=(operationalLayersConfig[i]);
                    }
                }
                mapUtils.reloadMapLayers(mapSrid,mapLayersConfig);
                currentXzqdm = tmpXzqdm;
                mapUtils.setMapXzqdm(currentXzqdm);
            }
        }

        //根据地籍号查询定位

        var mapLayerUrl = mapUtils.getLayer(zdServiceId).url;
        mapLayerUrl +='/'+zdLayerIndex;
        var returnFields = null;
        var where = "djh = '"+djh+"'";
        queryMapLayer(djh,mapLayerUrl,null,where,returnFields,true);
    };
    var queryMapLayer=function(djh,mapLayerUrl,geometry, where, outFields,returnGeometry){
        var queryTask = new QueryTask(mapLayerUrl);
        var query = new Query();
        if (where != null)
            query.where = where;
        if (geometry != null)
            query.geometry = geometry;
        query.returnGeometry = returnGeometry;
        if (outFields == null)
            query.outFields = ['*'];
        else
            query.outFields = outFields;
        on(queryTask, 'complete',lang.hitch(this,queryResultHandler,djh));
        on(queryTask, 'error', queryResultError);
        queryTask.execute(query);
    };
    var queryResultError=function(event){
        alert(event.error);
    };
    var queryResultHandler=function(djh,event) {
        var infoTemplate = $('#'+zdInfoTpl).html();
        Mustache.parse(infoTemplate);
        if (event.featureSet.features != null && event.featureSet.features.length>0) {
            var tmpInfo = Mustache.render(infoTemplate,event.featureSet.features[0].attributes);
            mapUtils.showMapInfoWindow("信息",tmpInfo,event.featureSet.features[0].geometry.getExtent().getCenter());
            mapUtils.highlightFeatures(event.featureSet.features);
            mapUtils.locateFeatures(event.featureSet.features);
            on($('#taxDetailByDjh'+djh),'click',lang.hitch(this,taxDetailClickHandle));
        }
    };
    var modifyReusltItemClass=function(target){
        var wellParent = $(target).parents('.well');
        $(wellParent).siblings().filter('.well-selected').each(function(){
            $(this).removeClass('well-selected');
            $(this).find('.glyphicon-map-marker').each(function(){
                $(this).removeClass('red');
            });
        });
        $(wellParent).addClass('well-selected');
        $(wellParent).find('.glyphicon-map-marker').each(function(){
            $(this).addClass('red');
        });
    };
    return declare([],{
        map:null,
        moduleConfig:null,
        constructor:function(args){
            declare.safeMixin(this,args);
        },
        searchTax:function(value){
            var url=landtaxUrl+"/ts/syJson";
            mapUtils.setMap(this.map);
            postTaxSearch(url,value,this.moduleConfig);
        },
        setMapFilterByRegion:function(value){
            mapFilterByRegion = value;
        },
        setOperationalLayersConfig:function(value){
            operationalLayersConfig = value;
        }
    });
});