define(["dojo/_base/lang",'esri/graphic','esri/symbols/SimpleMarkerSymbol','esri/symbols/SimpleLineSymbol','esri/symbols/SimpleFillSymbol',
    "esri/layers/ArcGISTiledMapServiceLayer", "esri/layers/ArcGISDynamicMapServiceLayer","esri/layers/FeatureLayer","dojo/on","esri/SpatialReference"],function(lang,Graphic,SimpleMarkerSymbol,
	SimpleLineSymbol,SimpleFillSymbol,ArcGISTiledMapServiceLayer,ArcGISDynamicMapServiceLayer,FeatureLayer,on,SpatialReference){
	var map;
	var setMap = function(value) {
		map = value;
	};
    var _highlightFeature = function(feature){
        var symbol;
        var geo = feature.geometry;
        if (geo != undefined) {
            switch (geo.type) {
                case "point":
                    symbol = new SimpleMarkerSymbol(SimpleMarkerSymbol.STYLE_SQUARE, 10, new SimpleLineSymbol(SimpleLineSymbol.STYLE_SOLID, new dojo.Color([255, 0, 0]), 1), new dojo.Color([0, 255, 0, 0.8]));
                    break;
                case "polyline":
                    symbol = new SimpleLineSymbol(SimpleLineSymbol.STYLE_SOLID, new dojo.Color([255, 0, 0]), 2);
                    break;
                case "polygon":
                    symbol = new SimpleFillSymbol(SimpleFillSymbol.STYLE_SOLID, new SimpleLineSymbol(SimpleLineSymbol.STYLE_DASHDOT, new dojo.Color([255, 0, 0]), 2), new dojo.Color([255, 255, 0, 0.25]));
                    break;
            }
            var graphic = new Graphic(feature.geometry, symbol, feature.attributes);
            map.graphics.add(graphic);
        }
    };
    var highlightFeatures = function(features) {
        map.graphics.clear();
        for(var i in features){
            if (features[i] != null && features[i] != undefined)
                _highlightFeature(features[i]);
        }
    };
    var locateFeatures = function(features) {
        var extent = null;
        for (var i in features) {
            var feature = features[i];
            var tmpExtent = null;
            if (feature != null && feature.geometry != undefined) {
                switch (feature.geometry.type) {
                    case "point":
                        break;
                    case "polyline":
                        tmpExtent = feature.geometry.getExtent();
                        break;
                    case "polygon":
                        tmpExtent = feature.geometry.getExtent();
                        break;
                }
                if (tmpExtent == null)
                    return;
                if (extent == null)
                    extent = tmpExtent;
                else
                    extent = extent.union(tmpExtent);
            }
        }
        if (extent != null && extent != undefined)
            map.setExtent(extent.expand(2));
    };
	var clearMapGraphics = function() {
		map.graphics.clear();
		if (map.infoWindow.isShowing)
			map.infoWindow.hide();
	};

    var showMapInfoWindow = function(title,content,pos){
        if (map.infoWindow.isShowing)
            map.infoWindow.hide();
        map.infoWindow.setTitle(title);
        map.infoWindow.setContent(content);
        map.infoWindow.show(pos);
    };

    var getModuleConfig=function(modulesConfig,id){
        for(var i in modulesConfig){
            if(id===modulesConfig[i].id){
                return modulesConfig[i].config;
            }
        }
        return undefined;
    };
    var getMapServiceConfig=function(mapServicesConfig,id){
        for(var i in mapServicesConfig){
            if(id===mapServicesConfig[i].id){
                return mapServicesConfig[i];
            }
        }
    };

    var setMapSerivceVisible = function(id,visible){
        var tmpLayer = map.getLayer(id);
        tmpLayer.setVisibility(visible);
    };

    var setMapSerivceVisibleLayers = function(serviceId,layerIds){
        var tmpLayer = map.getLayer(serviceId);
        if(!tmpLayer.visible)
            tmpLayer.setVisibility(true);
        tmpLayer.setVisibleLayers(layerIds);
    };
    var _layerOnload = function(event){
        alert(event.layer.id);
    };

    var reloadMapLayers = function(srid,mapLayersConfig){
        map.removeAllLayers();
        if(srid!=null)
           map.spatialReference=new SpatialReference(srid);
        for (var i in mapLayersConfig) {
            var tmpLayerConfig = mapLayersConfig[i];
            var tmpLayer=null;
            if ("tiled" === tmpLayerConfig.type) {
                tmpLayer = new ArcGISTiledMapServiceLayer(tmpLayerConfig.url, {
                    id: tmpLayerConfig.id,
                    visible:tmpLayerConfig.visible
                });
            } else if ("dynamic" === tmpLayerConfig.type) {
                tmpLayer = new ArcGISDynamicMapServiceLayer(tmpLayerConfig.url, {
                    id: tmpLayerConfig.id,
                    visible:tmpLayerConfig.visible
                });
                if(tmpLayerConfig.hasOwnProperty('visibleLayers')){
                    tmpLayer.setVisibleLayers(tmpLayerConfig.visibleLayers);
                }
            } else if ("feature" == tmpLayerConfig.type) {
                tmpLayer = new FeatureLayer(tmpLayerConfig.url, {
                    mode: FeatureLayer.MODE_SNAPSHOT,
                    visible:tmpLayerConfig.visible
                });

            }

            if(tmpLayerConfig.loadedCallback!=null){
                on(tmpLayer,'load',lang.hitch(this,tmpLayerConfig.loadedCallback,tmpLayerConfig.loadedCallbackParams));
            }


            if(tmpLayer!=null){
                tmpLayer.alias = tmpLayerConfig.name;
                tmpLayer.visible = tmpLayerConfig.visible;
                map.addLayer(tmpLayer);
            }
            if(i==0&&tmpLayer!=null){
                on(tmpLayer,'load',function(event){
                    var layer = event.layer;
                    map.setExtent(layer.fullExtent);
                })
            }
        }
    };
    var getLayer = function(layerId){
        return map.getLayer(layerId);
    };
    var setMapXzqdm = function(value){
        map.xzqdm = value;
    };



    var setMapThematicChecked=function(layerId,checked){
        $('#thematic'+layerId).attr('data-visible',checked);
        var content = $('#thematic'+layerId).text();
        if(checked){
            $('#thematic'+layerId).empty();
            $('#thematic'+layerId).append('<i class="ace-icon fa fa-check"></i>'+content);
        }
        else{
            $('#thematic'+layerId).empty();
            $('#thematic'+layerId).append(content);
        }

    };

    var setMapLayerChecked=function(layerId,checked){
        if(checked)
            $('#service'+layerId).prop("checked",true);
        else
            $('#service'+layerId).prop("checked",false);
    };

    var getMapInfoWindow=function(){
        return map.infoWindow;
    }

	return{
		setMap:setMap,
        getLayer:getLayer,
        setMapXzqdm:setMapXzqdm,
        locateFeatures:locateFeatures,
        highlightFeatures:highlightFeatures,
        clearMapGraphics:clearMapGraphics,
        getModuleConfig:getModuleConfig,
        getMapServiceConfig:getMapServiceConfig,
        showMapInfoWindow:showMapInfoWindow,
        setMapSerivceVisible:setMapSerivceVisible,
        reloadMapLayers:reloadMapLayers,
        setMapThematicChecked:setMapThematicChecked,
        setMapLayerChecked:setMapLayerChecked,
        setMapSerivceVisibleLayers:setMapSerivceVisibleLayers,
        getMapInfoWindow:getMapInfoWindow
	};
});