﻿define(["jquery","dojo/_base/declare",
    "dojo/_base/lang","dojo/on",'esri/tasks/QueryTask','esri/tasks/query','mustache',"mapUtils"
], function($,declare,lang,on,QueryTask,Query,Mustache,mapUtils) {
   return declare([],{
       map:null,
       moduleConfig:null,
       constructor:function(args){
           declare.safeMixin(this,args);
       },
       searchByAttribute:function(value){
           var mapLayerUrl = this.map.getLayer(this.moduleConfig.mapServiceId).url;
           mapLayerUrl +='/'+this.moduleConfig.mapLayerIndex;
           var returnFields = this.moduleConfig.returnFields||null;
           var queryFields = this.moduleConfig.queryFields||[];
           var where = "";
           for(var i in queryFields){
               var queryField = queryFields[i];
               if(queryField.fieldName in value){
                   if(queryField.operator==='like')
                      where += queryField.fieldName +" "+queryField.operator+" '%"+value[queryField.fieldName]+"%'";
                   else
                      where += queryField.fieldName +" "+queryField.operator+" '"+value[queryField.fieldName]+"'";
               }
           }
           this._queryMapLayer(mapLayerUrl,null,where,returnFields,true);
       },
       _queryMapLayer:function(mapLayerUrl,geometry, where, outFields,returnGeoemtry){
           var queryTask = new QueryTask(mapLayerUrl);
           var query = new Query();
           if (where != null)
               query.where = where;
           if (geometry != null)
               query.geometry = geometry;
           query.returnGeometry = returnGeoemtry;
           if (outFields == null)
               query.outFields = ['*'];
           else
               query.outFields = outFields;
           on(queryTask, 'complete', lang.hitch(this,this._queryResultHandler));
           on(queryTask, 'error', this._queryResultError);
           queryTask.execute(query);
       },
       _queryResultError:function(event){
           alert(event.error);
       },
       _queryResultHandler:function(event){
           if (event.featureSet.features!=null&&event.featureSet.features.length > 0) {
               var featureExtent = event.featureSet.features[0].geometry.getExtent();
               var selectedGraphic = event.featureSet.features[0];
               mapUtils.setMap(this.map);
//               $('#queryContent').empty();
//               $('#resultCount').text(event.featureSet.features.length);
//               var itemTemplate = $('#'+this.moduleConfig.itemTemplate).html();
//               var infoTemplate = $('#'+this.moduleConfig.infoTemplate).html();
//               Mustache.parse(itemTemplate);
//               Mustache.parse(infoTemplate);

               mapUtils.highlightFeatures(event.featureSet.features);
               mapUtils.locateFeatures(event.featureSet.features);
//               for(var i in event.featureSet.features){
//                   var feature = event.featureSet.features[i];
//                   mapUtils.highlightFeature(feature);
//                   var tmpItem = this._contructQueryResultItem(itemTemplate,feature.attributes);
//                   var tmpInfo = this._contructQueryResultItem(infoTemplate,feature.attributes);
//                   $('#queryContent').append(tmpItem);
//                   on($('#loc'+feature.attributes[this.moduleConfig.linkField]),'click',lang.hitch(this,this._locationClickHandle,feature,tmpInfo));
//               }




           }
       }
//       ,
//       _locationClickHandle:function(feature,tmpItem,event){
//           mapUtils.setMap(this.map);
//           mapUtils.showMapInfoWindow("信息",tmpItem,feature.geometry.getExtent().getCenter());
//           mapUtils.highlightFeature(feature);
//
//       }
   });
});