define(["dojo/_base/declare","dojo/_base/lang",'esri/graphic', 'esri/tasks/QueryTask','esri/tasks/query',
	"dojo/on","widgetUtils","../mapUtils","slimScroll"], function(declare,lang,Graphic,QueryTask,Query,on,widgetUtils,mapUtils,slimScroll) {
    return declare([],{
        map:null,
        moduleConfig:null,
        template:null,
        title:'<i class="blue ace-icon fa fa-bookmark"></i>书签',
        constructor:function(args){
            declare.safeMixin(this,args);
            if(this.template==null)
               this.template = landtaxUrl+'/static/js/map/modules/mapMarker/mapMarker.tpl';

        },
        doMarker:function(){
            on(this.map, "click", lang.hitch(this,this._doMarker));
            mapUtils.setMap(this.map);
            widgetUtils.setDynamicTabTitle(this.title);
            widgetUtils.changeToDynamicTab();
            widgetUtils.clearDynamicTab();
            this._getWidgetTemplate(null);
        },
        _doMarker:function(event) {
        },
        _getWidgetTemplate:function(data){
            $.get(this.template,lang.hitch(this,this._renderWidgetTemplate,data));
        },
        _renderWidgetTemplate:function(data,template){
            widgetUtils.renderDynamicWidget(template,data);
        }
    });
});