<#assign jsContent>
    <@com.script name="static/js/tax/grid.js"></@com.script>
    <@com.script name="static/js/public.js"></@com.script>
</#assign>

<#assign cssContent>
    <@com.style name="static/css/pageForm.css"></@com.style>
    <@com.style name="static/thirdparty/ace/css/font-awesome.min.css"></@com.style>
    <@com.style name="static/thirdparty/ace/css/ace-fonts.css"></@com.style>
    <@com.style name="static/thirdparty/ace/css/ace.min.css"></@com.style>
    <@com.style name="static/thirdparty/ace/css/ace-skins.min.css"></@com.style>
    <@com.style name="static/thirdparty/ace/css/ace-rtl.min.css"></@com.style>
</#assign>

<@com.html title="${reportName!}" import="jquery,jqueryEasyUI,multiselect,jqgrid,bootstrap,bootbox,datetimepicker,highcharts" js=jsContent css=cssContent >
    <div class="main-container" id="main-container">
        <script type="text/javascript">
            try {
                ace.settings.check('main-container', 'fixed')
            } catch (e) {
            }
        </script>

        <div class="main-container-inner" id="basetj">
            <div class="page-content">
                <div class="row">
                    <div class="widget-box transparent">
                        <div class="widget-body">
                            <div class="widget-main">
                                <div class="row">
                                    <div class="col-xs-12">
                                        <div class="col-xs-12">
                                            <div>
                                                <form id="queryForm">
                                                    <#if headPageFile?? && headPageFile != "">
                                                        <#include "../${headPageFile!}" />
                                                    </#if>
                                                    <div class="no-padding-left col-sm-12" style="margin-top: 5px">
                                                        <fieldset class="searchInput form-inline">
                                                            <#if headPageFile?? && headPageFile != "">
                                                            <button type="button" class="btn btn-info btn-sm" id="btnQuery" >
                                                                <i class="ace-icon fa fa-search bigger-110"></i>
                                                                查询
                                                            </button>
                                                            </#if>
                                                            <#if needExport?? || autoExport??>
                                                            <button type="button" class="btn btn-success btn-sm" id="btnExportExcel">
                                                                <i class="ace-icon glyphicon glyphicon-share bigger-110"></i>
                                                                导出
                                                            </button>
                                                            </#if>
                                                        </fieldset>
                                                    </div>
                                                </form>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <p></p>
                                <row>
                                    <div class="col-xs-12" >
                                        <div id="gGrid" data-definition="${base}/static/json/${colJson}.json">
                                            <table id="grid-table"></table>
                                            <div id="grid-pager"></div>
                                        </div>
                                    </div>
                                </row>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div><!-- /.main-container-inner -->

        <table style="width: 100%">
            <tr>
            <#if tjBaseParamVo.chartBaseParamVoList ??>
                <#list tjBaseParamVo.chartBaseParamVoList as chartBaseParamVo>
                    <tr><td class="chart" uniqueId="${chartBaseParamVo.uniqueId}" style="width: 50%"><#include "baseChart.ftl"/></td></tr>
                </#list>
            </#if>
            </tr>
        </table>
    </div>

    <#assign jsContent>
        <@com.script name="static/thirdparty/ace/js/ace-extra.min.js"></@com.script>
        <@com.script name="static/thirdparty/ace/js/ace-elements.min.js"></@com.script>
        <@com.script name="static/thirdparty/ace/js/ace.min.js"></@com.script>
    </#assign>
</@com.html>

<script type="text/javascript">
    var grid;

    $(function () {
        bootbox.setDefaults({
            locale: "zh_CN"
        });

        var scrollHeight = 15;
        var minRows = 3;
        var rowHeigth = 33;

        var drawHeight = jQuery(window).height() - 140 - $('#basetj')[0].clientHeight;
        var drawRowNum = Math.floor(drawHeight / rowHeigth);
        drawHeight = drawRowNum * rowHeigth + scrollHeight;

        if (drawHeight < minRows * rowHeigth) {
            drawHeight = minRows * rowHeigth + scrollHeight;
            drawRowNum = minRows;
        }
        var showRowNum = drawRowNum;
        <#if tjBaseParamVo.allRowShowOnePage ?? && tjBaseParamVo.allRowShowOnePage = true>
            showRowNum = -1;
        </#if>

        grid = $('#gGrid').gGrid({
            rownumbers: true,
            rownumWidth: 40,
            footerrow: false,
            autoHeight: false,
            height: drawHeight,
            rowNum: showRowNum,
            caption: "${reportName!}",
            url:'/landtax/tj/tjJson?tag=${tag}&customParams=${customParams!}',
            gridComplete: function() {
                //在gridComplete调用行合并方法
                $('#gGrid').mergeRowCell();

                // 调整高度
                <#if tjBaseParamVo.allRowShowOnePage ?? && tjBaseParamVo.allRowShowOnePage = true>
                    var rowCnt = grid.jqGrid('getGridParam', 'records');
                    drawHeight = drawHeight + (rowCnt - drawRowNum) * rowHeigth;
                    $("#gview_grid-table").height($("#gview_grid-table").height() + (rowCnt - drawRowNum) * rowHeigth);
                    $(".ui-jqgrid-bdiv").height($(".ui-jqgrid-bdiv").height() + (rowCnt - drawRowNum) * rowHeigth);
                    $("#grid-pager").css("display", "none");
                </#if>
            }
        });

        $('#btnExportExcel').click(function () {
            if ("${needExport!}" != null && "${needExport!}" != "") {
                exportExcel(1);
            } else {
                exportExcel(2);
            }
        });

        $(":input").focus(
                function(){
                    if(this.value=="" ||this.value==null){this.placeholder=""};
                }
        ) ;

        $(":input").blur(
                function(){
                    if(this.value==""||this.value==null){this.placeholder=(this.getAttribute("aliasName") == null) ? "" : this.getAttribute("aliasName");};
                }
        ) ;
        initializeSelect($);

        // 初始化图表
        $('td.chart:has([name="baseChart"])').each(function () {
            var uniqueId = $(this).attr('uniqueId');
            loadChartData(uniqueId, $('td[uniqueId="' + uniqueId + '"] [name="baseChart"]'));
        });
    });

    $('#btnQuery').click(function () {
        var params = $('#queryForm').serializeJson();
        queryCommand(params);
    });

    function queryCommand (params) {
        $('#gGrid').refreshGrid(params);
    }

    function exportExcel(param){
        var queryParam = $('#queryForm').serializeJson();
        var gridOptions = $('#gGrid').getOptions();
        var actionURL;
        if (param == 1) {
            actionURL = '${base}/tj/exportExcelTj?tag=${tag}&customParams=${customParams!}&query=' + queryParam["query"];
        } else {
            actionURL = '${base}/tj/exportExcelTjEx?tag=${tag}&customParams=${customParams!}&query=' + queryParam["query"] + '&gridOptions=' + JSON.stringify(gridOptions);
        }
        window.open(actionURL,"exportWin", "left=50,top=50,height=600px,width=750px,resizable=yes,status=yes,toolbar=no, menubar=no,location=no");
    }

    function turnToUrl(id, baseUrl, paramNames, paramValues, paramOperators) {
        paramNames = paramNames.split(",");
        paramValues = paramValues.split(",");

        if (paramOperators == null)
            paramOperators = '';
        paramOperators = paramOperators.split(",");

        var paramCnt = paramNames.length;
        var paramName, paramValue, paramOperator, paramStr, i;
        var valueJson = {};
        var operatorJson = {};
        var hasCustomParams = false;
        id = (id.split("="))[1];
        for (i = 0; i < paramCnt; i++) {
            paramName = paramNames[i].trim();
            paramValue = grid.jqGrid('getRowData', id)[paramValues[i].trim()];
            if (paramValue == null)
                paramValue = paramValues[i].trim();

            if (i < paramOperators.length) {
                paramOperator = paramOperators[i].trim();
            } else {
                paramOperator = '';
            }
            if (paramOperator == '') {
                if (paramStr != '')
                    paramStr += '&';
                paramStr += paramName + '=' + paramValue;
            } else {
                hasCustomParams = true;
                valueJson[paramName] = paramValue;
                operatorJson[paramName] = paramOperators[i];
            }
        }

        if (hasCustomParams) {
            if (paramStr != '')
                paramStr += '&';
            paramStr += 'customParams=' + '[' + JSON.stringify(valueJson) + ',' + JSON.stringify(operatorJson) + ']';
        }


        window.open("${base!}/" + baseUrl + "?" + paramStr, "")

    }

    function loadChartData(uniqueId, chartObj) {
        var chartUrl='/landtax/tj/chartJson?tag=${tjBaseParamVo.tag}&uniqueId=' + uniqueId + '&customParams=${customParams!}';
        $.ajax({
            type: 'post',
            url: chartUrl,
            dataType: 'json',
            success: function (data) {
                var options = {
                    chart: {
                        type: data.chartBaseParamVo.chartType
                    },
                    title: {
                        text: data.chartBaseParamVo.title
                    },
                    xAxis: {
                        categories: data.categories
                    },
                    yAxis: {
                        title: {
                            text: data.chartBaseParamVo.unit
                        }
                    },
                    tooltip: {
                        headerFormat: '<span style="font-size:12px">{point.key}</span><table>',
                        pointFormat: '<tr><td style="color:{series.color};padding:0">{series.name}: </td>' +
                                '<td style="padding:0"><b>{point.y:.2f} {series.options.unit}</b></td></tr>',
                        footerFormat: '</table>',
                        shared: true,
                        useHTML: true
                    },
                    plotOptions: {
                        column: {
                            pointPadding: 0.2,
                            borderWidth: 0,
                            dataLabels: {
                                enabled: true
                            }
                        },
                        pie: {
                            allowPointSelect: true,
                            cursor: 'pointer',
                            dataLabels: {
                                enabled: true,
                                color: '#000000',
                                connectorColor: '#000000',
                                format: '{point.name}: {point.percentage:.1f} %'
                            }
                        }
                    },
                    credits:
                    {
                        enabled : false
                    },
                    series: data.series
                };

                // 加入自定义的option配置
                if (data.customOptions != undefined && data.customOptions.length > 0) {
                    options = $.extend(false, options, eval("(" + data.customOptions + ")"));
                }

                chartObj.highcharts(options);
            }
        });
    }
</script>