<#assign jsContent>

    <@com.script name="static/js/tax/grid.js"></@com.script>
    <@com.script name="static/js/public.js"></@com.script>
    <@com.script name="static/js/tax/swDjSy-save-validate.js"></@com.script>
    <@com.script name="static/thirdparty/bootstrap/js/bootstrap-typeahead.min.js"></@com.script>
</#assign>
<#assign cssContent>
    <@com.style name="static/css/pageForm.css"></@com.style>
    <@com.style name="static/thirdparty/ace/css/font-awesome.min.css"></@com.style>
    <@com.style name="static/thirdparty/ace/css/ace-fonts.css"></@com.style>
    <@com.style name="static/thirdparty/ace/css/ace.min.css"></@com.style>
    <@com.style name="static/thirdparty/ace/css/ace-skins.min.css"></@com.style>
    <@com.style name="static/thirdparty/ace/css/ace-rtl.min.css"></@com.style>
</#assign>
<@com.html title="宗地更新核查税源台帐" import="jquery,jqgrid,bootstrap,bootbox,datetimepicker" js=jsContent css=cssContent >
<div class="main-container" id="main-container">
    <script type="text/javascript">
        try {
            ace.settings.check('main-container', 'fixed')
        } catch (e) {
        }
    </script>
    <form>
        <input type="hidden" id="proid" value="${proid!}" name="proid">
    </form>

    <div class="main-container-inner" id="sytz">
        <div class="page-content">

            <div class="row">
                <div class="widget-box transparent">
                    <div class="widget-body">
                        <div class="widget-main">
                            <row>
                                <div id="pageTitle" style="padding-bottom: 0px; text-align: ">
                                    宗地数据更新详情
                                </div>
                                <div class="col-xs-12" >
                                    <table  class="table table-bordered">
                                        <thead>
                                        <tr>
                                            <th style="width:10%;">地籍号（更新前）</th>
                                            <th>地籍号（更新后）</th>
                                            <th>土地坐落（更新后）</th>
                                            <th>土地用途（更新后）</th>
                                            <th>国土宗地面积（更新后）</th>
                                            <th>权利人名称（更新后）</th>
                                            <th>变更类型</th>
                                        </tr>
                                        </thead>
                                        <tbody id="zdbgAnalyList">
                                            <#if zdbgAnalyList??>
                                                <#list zdbgAnalyList as zdbgAnaly>
                                                <tr name="zdbgAnaly">
                                                    <td>${zdbgAnaly.DJH_BEFORE!}</td>
                                                    <td>${zdbgAnaly.DJH_NEW!}</td>
                                                    <td>${zdbgAnaly.TDZL!}</td>
                                                    <td>${zdbgAnaly.TDYTMC!}</td>
                                                    <td>${zdbgAnaly.SCMJ!}</td>
                                                    <td>${zdbgAnaly.QLRMC!}</td>
                                                    <td>${zdbgAnaly.BGLX!}</td>
                                                </tr>
                                                </#list>
                                            </#if>
                                        </tbody>
                                    </table>
                                </div>
                                <#if mjMap??>
                                <div id="pageTitle">
                                    纳税人国土面积与税源面积差异情况
                                </div>
                                <div class="col-xs-12" >
                                    <table  class="table table-striped table-bordered">
                                        <thead>
                                        <tr>
                                            <th>国土面积合计</th>
                                            <th>税源面积合计</th>
                                            <th>面积差值</th>
                                            <th>差异比例</th>
                                        </tr>
                                        </thead>
                                        <tbody>
                                            <tr>
                                                <td>${mjMap.zdMjHJ!}</td>
                                                <td>${mjMap.syMjHJ!}</td>
                                                <td>${mjMap.mjcz!}</td>
                                                <td>${mjMap.cybl!}</td>
                                            </tr>
                                        </tbody>
                                    </table>
                                </div>
                                </#if>
                                <div id="pageTitle" style="padding-bottom: 0px; text-align: ">
                                    国土宗地列表
                                </div>
                                <div class="col-xs-12" >
                                    <table  class="table table-bordered">
                                        <thead>
                                        <tr>
                                            <th style="width:10%;">地籍号</th>
                                            <th>土地坐落</th>
                                            <th>土地用途</th>
                                            <th>国土宗地面积</th>
                                            <th>权利人名称</th>
                                            <th>操作</th>
                                        </tr>
                                        </thead>
                                        <tbody id="zdList">
                                        <#if zdList??>
                                            <#list zdList as zd>
                                                <tr name="zd">
                                                    <td>${zd.DJH!}</td>
                                                    <td>${zd.TDZL!}</td>
                                                    <td>${zd.TDYTMC!}</td>
                                                    <td>${zd.SCMJ!}</td>
                                                    <td>${zd.QLRMC!}</td>
                                                    <#if isYbj='false'>
                                                        <td><div title='新增土地税源' class='pull-left'  style='margin-left: 5px'><a href="javascript:void(0)" onclick="addSyTd('${zd.DJH!}');">新增土地税源</a></div></td>
                                                    </#if>
                                                </tr>
                                            </#list>
                                        </#if>
                                        </tbody>
                                    </table>
                                </div>

                                <div id="pageTitle">
                                    城镇土地税税源列表
                                </div>
                                <div class="col-xs-12" >
                                    <table  class="table table-bordered">
                                        <thead>
                                            <tr>
                                                <th>地籍号</th>
                                                <th>纳税人名称</th>
                                                <th>土地坐落</th>
                                                <th>土地证号</th>
                                                <th>实测面积</th>
                                                <th>修改时间</th>
                                                <th>修改人</th>
                                                <th>操作</th>
                                            </tr>
                                        </thead>
                                        <tbody id="swDjSyTempList">
                                            <#if swDjSyTempList??>
                                                <#list swDjSyTempList as swDjSyTemp>
                                                    <#if swDjSyTemp.syzt == '1' && swDjSyTemp.swDjTdTemp??>
                                                        <tr name="sy">
                                                            <td><#if swDjSyTemp.zd??>${swDjSyTemp.zd.djh!}</#if></td>
                                                            <td>${swDjSyTemp.swDjJbbTemp.nsrmc!}</td>
                                                            <td>${swDjSyTemp.swDjTdTemp.tdzl!}</td>
                                                            <td>${swDjSyTemp.swDjTdTemp.tdsyzh!}</td>
                                                            <td>${swDjSyTemp.swDjTdTemp.scmj!}</td>
                                                            <td>${swDjSyTemp.updateRq!}</td>
                                                            <td>${swDjSyTemp.updateUsername!}</td>
                                                            <td>
                                                                <div title='查看' class='pull-left'  style='margin-left: 5px'><a href="javascript:void(0)" onclick="viewSy('${swDjSyTemp.tempId!}', '1');">查看</a></div>
                                                                <#if isYbj='false'>
                                                                    <div title='税源编辑' class='pull-left'  style='margin-left: 5px'><a href="javascript:void(0)" onclick="updSy('${swDjSyTemp.tempId!}', '1');">税源编辑</a></div>
                                                                    <div title='税源删除' class='pull-left'  style='margin-left: 5px'><a href="javascript:void(0)" onclick="delSy('${swDjSyTemp.tempId!}', '1');">税源删除</a></div>
                                                                </#if>
                                                            </td>
                                                        </tr>
                                                    </#if>
                                                </#list>
                                            </#if>
                                        </tbody>
                                    </table>
                                </div>

                                <div id="pageTitle" style="padding-bottom: 0px; text-align: ">
                                    房产税税源列表
                                </div>
                                <div class="col-xs-12" >
                                    <#if isYbj='false'>
                                    <div class="col-sm-6 pull-right" style="padding-top:10px;">
                                        <button class="btn btn-sm btn-success pull-right" type="button" onclick="addSyFc('<#if swDjJbb??>${swDjJbb.jbbId!}</#if>');">
                                            <i class="ace-icon fa fa-reply bigger-110"></i>
                                            新增房产税
                                        </button>
                                    </div>
                                    </#if>
                                    <table  class="table table-striped table-bordered">
                                        <thead>
                                        <tr>
                                            <th>纳税人名称</th>
                                            <th>房产坐落</th>
                                            <th>房产面积</th>
                                            <th>年应纳税额</th>
                                            <th>修改时间</th>
                                            <th>修改人</th>
                                            <th>操作</th>
                                        </tr>
                                        </thead>

                                        <tbody>
                                            <#if swDjSyTempList??>
                                                <#list swDjSyTempList as swDjSyTemp>
                                                    <#if swDjSyTemp.syzt == '1' && swDjSyTemp.swDjFcTemp??>
                                                        <tr>
                                                            <td>${swDjSyTemp.swDjJbbTemp.nsrmc!}</td>
                                                            <td>${swDjSyTemp.swDjFcTemp.fczl!}</td>
                                                            <td>${swDjSyTemp.swDjFcTemp.fcmj!}</td>
                                                            <td>${swDjSyTemp.swDjFcTemp.nynse!}</td>
                                                            <td>${swDjSyTemp.updateRq!}</td>
                                                            <td>${swDjSyTemp.updateUsername!}</td>
                                                            <td>
                                                                <div title='查看' class='pull-left'  style='margin-left: 5px'><a href="javascript:void(0)" onclick="viewSy('${swDjSyTemp.tempId!}', '2');">查看</a></div>
                                                                <#if isYbj='false'>
                                                                    <div title='税源编辑' class='pull-left'  style='margin-left: 5px'><a href="javascript:void(0)" onclick="updSy('${swDjSyTemp.tempId!}', '2');">税源编辑</a></div>
                                                                    <div title='税源删除' class='pull-left'  style='margin-left: 5px'><a href="javascript:void(0)" onclick="delSy('${swDjSyTemp.tempId!}', '2');">税源删除</a></div>
                                                                </#if>
                                                            </td>
                                                        </tr>
                                                    </#if>
                                                </#list>
                                            </#if>
                                        </tbody>
                                    </table>
                                </div>

                            </row>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div><!-- /.main-container-inner -->

    <div class="main-container-inner" id="syxx" toggleId="sytz" style="display:none;">

    </div>

    <div class="modal fade" id="addZdModal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true" style="width:100%;">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header" style="background: #f7f7f7;background-image:linear-gradient(to bottom, #fff 0, #eee 100%);background-repeat:repeat-x;">
                    <button type="button" class="close"
                            data-dismiss="modal" aria-hidden="true">
                        &times;
                    </button>
                    <h4 class="modal-title" id="myModalLabel">
                        <i class="fa fa-pencil-square" style="color: #669fc7;">请选择新增宗地：</i>
                    </h4>
                </div>

                <div>
                    <form id="queryZdForm">
                        <div class="pull-left col-sm-12 search-query" style="margin-top: 15px; margin-bottom: 5px;">
                            <div class="col-xs-4 no-padding-left">
                                <div>地籍号</div>
                                <input type="text" name="DJH" id="djh" operator="operator-LLK" class="form-control input-mask-date"/>
                            </div>
                            <div class="col-xs-4 no-padding-left">
                                <div>权利人名称</div>
                                <input type="text" name="QLRMC" operator="operator-LK" class="form-control input-mask-date"/>
                            </div>
                            <div class="col-xs-4 no-padding-left">
                                <div>土地坐落</div>
                                <input type="text" name="TDZL" operator="operator-LK" class="form-control input-mask-date"/>
                            </div>
                            <div class="col-xs-4 no-padding-left">
                                <button type="button" class="btn btn-info btn-sm" id="btnQuery" onclick="queryZdList()">
                                    <i class="ace-icon fa fa-search bigger-110"></i>
                                    查询
                                </button>
                            </div>
                        </div>
                    </form>
                    <div class="col-xs-12" >
                        <table  class="table table-striped table-bordered">
                            <thead>
                                <tr>
                                    <th style="width:20px;">操作</th>
                                    <th>地籍号</th>
                                    <th>土地坐落</th>
                                    <th>土地用途</th>
                                    <th>国土宗地面积</th>
                                    <th>权利人名称</th>
                                </tr>
                            </thead>

                            <tbody id="zdListForm">

                            </tbody>
                        </table>
                    </div>
                    <span style="color: #669fc7;"></span>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-default"
                            data-dismiss="modal">关闭
                    </button>
                    <button type="button" class="btn btn-primary" id="addTd" onclick="addTd()">
                        确认增加
                    </button>
                </div>
            </div><!-- /.modal-content -->
        </div><!-- /.modal -->
    </div>
    <div style="display: none"><input type="button" id="btnPrintSingle"></div>

</div>
    <script type="text/javascript">
        var zdList = new Array();
        $(function() {
            bootbox.setDefaults({
                locale: "zh_CN"
            });

            $("tr:odd[name='zd']").css("background-color", "#f9f9f9");
            $("tr:odd[name='sy']").css("background-color", "#f9f9f9");

            zdList = [];
            <#list zdList as zd>
                zdList.push("${zd.DJH!}");
            </#list>

            $("#btnPrintAll").on("click", function () {
                $.ajax({
                    type: 'post',
                    url: "${base}/ts/getPrintIdByProid?proid=${proid!}",
                    dataType: 'json',
                    success: function (data) {
                        goPrintAll(data);
                    },

                });
            });

            $("tr[name='zd']").on("click", function() {
                $("tr:odd[name='zd']").css("background-color", "#f9f9f9");
                $("tr:even[name='zd']").css("background-color", "#ffffff");
                $(this).css("background-color", "#DDDDDD");

                $("tr:odd[name='sy']").css("background-color", "#f9f9f9");
                $("tr:even[name='sy']").css("background-color", "#ffffff");
                var selectDjh = this.children[0].innerText;
                for (var i = 0; i < $("tr[name='sy']").length; i++) {
                    var djh= $("tr[name='sy']")[i].children[0].innerText;
                    if (selectDjh == djh) {
                        $($("tr[name='sy']")[i]).css("background-color", "#DDDDDD")
                    }

                }
            });

            $("tr[name='sy']").on("click", function() {
                $("tr:odd[name='sy']").css("background-color", "#f9f9f9");
                $("tr:even[name='sy']").css("background-color", "#ffffff");
                $(this).css("background-color", "#DDDDDD");

                $("tr:odd[name='zd']").css("background-color", "#f9f9f9");
                $("tr:even[name='zd']").css("background-color", "#ffffff");

                var selectDjh = this.children[0].innerText;
                for (var i = 0; i < $("tr[name='zd']").length; i++) {
                    var djh= $("tr[name='zd']")[i].children[0].innerText;
                    if (selectDjh == djh) {
                        $($("tr[name='zd']")[i]).css("background-color", "#DDDDDD")
                    }

                }
            });

            $("#btnPrintSingle").on("click", function(event, tempId, djh, sylx) {

                goPrintTemp(tempId, djh, sylx);
            });
        });

        function addTds(){
            $("#addZdModal").modal("show");
        }

        function queryZdList() {
            var params = $('#queryZdForm').serializeJson();
            $.ajax({
                type: 'post',
                url: "${base}/tj/tjList?tag=zdList&query=" + params["query"],
                dataType: 'json',
                success: function (data) {
                    for (var i in $('#zdListForm')[0].children) {
                        $('#zdListForm')[0].children[i].remove;
                    }
                    for (var j in data) {
                        if (j >= 10) {
                            bootbox.alert("查询结果过多（" + data.length + "），只显示10条记录！");
                            break;
                        }

                        var zd = data[j];

                        var tr = document.createElement("tr");
                        tr.setAttribute("onclick", "this.children[0].children[0].checked = true");
                        var input;
                        var td;
                        input = document.createElement("input");
                        input.setAttribute("type", "radio");
                        input.setAttribute("name", "zdSelectR");
                        input.setAttribute("value", zd.DJH);
                        td = document.createElement("td");
                        td.appendChild(input);
                        tr.appendChild(td);

                        td = document.createElement("td");
                        td.innerText = zd.DJH;
                        tr.appendChild(td);

                        td = document.createElement("td");
                        td.innerText = zd.TDZL;
                        tr.appendChild(td);

                        td = document.createElement("td");
                        td.innerText = zd.TDYTMC;
                        tr.appendChild(td);

                        td = document.createElement("td");
                        td.innerText = zd.SCMJ;
                        tr.appendChild(td);

                        td = document.createElement("td");
                        td.innerText = zd.QLRMC;
                        tr.appendChild(td);

                        $('#zdListForm')[0].appendChild(tr);
                    }
                }
            });
        }

        function addSyTd(djh){
            var proid = $("#proid").val();
            var jbbId='${swDjJbb.jbbId!}';
            $.ajax({
                type: 'post',
                url: "${base}/syhc/createNewSyTdTemp",
                data: {djh: djh, jbbId: jbbId, proid: proid},
                dataType: 'json',
                success: function (data) {
                    if (data != null && data.msg != "") {
                        updSy(data.msg, '1');
                    }
                },
            });
        }

        function addSyFc(jbbId){
            var proid = $("#proid").val();
            $.ajax({
                type: 'post',
                url: "${base}/syhc/createNewSyFcTemp",
                data: {jbbId: jbbId, proid: proid},
                dataType: 'json',
                success: function (data) {
                    if (data != null && data.msg != "") {
                        updSy(data.msg, '2');
                    }
                },
            });
        }

        function updSy(tempId, sylx){
            $.ajax({
                type: 'post',
                url: "${base}/ts/syxxTempInput",
                data:{tempId: tempId, sylx: sylx},
                dataType: 'text',
                success: function (data) {
                    $('#syxx').empty();
                    $('#syxx').append(data);
                    $("#syxx").toggle(300);
                    $("#sytz").toggle(300);
                },
                error: function (XmlHttpRequest, textStatus, errorThrown) {
                    alert('读取税源信息有误！');
                }
            });
        }

        function viewSy(tempId, sylx){
            $.ajax({
                type: 'post',
                url: "${base}/ts/syxxTempInput",
                async: false,
                data:{tempId:tempId, sylx:sylx, noSave:'1'},
                dataType: 'text',
                success: function (data) {
                    $('#syxx').empty();
                    $('#syxx').append(data);
                    $("#syxx").toggle(300);
                    $("#sytz").toggle(300);
                },
                error: function (XmlHttpRequest, textStatus, errorThrown) {
                    alert('读取税源信息有误！');
                }
            });
        }

        function delSy(tempId){
            bootbox.confirm("确认删除吗?", function(result) {
                if(result){
                    $.ajax({
                        type: 'post',
                        url: "${base}/syhc/delete?tempId="+tempId,
                        dataType: 'json',
                        success: function (data) {
                            bootbox.alert(data.msg,function(){
                                if(data.msg=="删除成功!"){
                                    window.location.reload();
                                }
                            })
                        }
                    });
                }
            });
        }

        var printlist = new Array();
        function goPrintAll(data) {
            printlist = [];;
            var zds = data.zddjh;
            if (zds != undefined && zds.length > 0) {
                zds = zds.split(",");
                for (var i = 0; i < zds.length; i++) {
                    printlist.push("," + zds[i] + ",1");
                }
            }

            var tds = data.tdsTempId;
            if (tds != undefined && tds.length > 0) {
                tds = tds.split(",");
                for (var i = 0; i < tds.length; i++) {
                    printlist.push(tds[i] + ",,1");
                }
            }

            var fcs = data.fcsTempId;
            if (fcs != undefined && fcs.length > 0) {
                fcs = fcs.split(",");
                for (var i = 0; i < fcs.length; i++) {
                    printlist.push(fcs[i] + ",,2");
                }
            }

            doPrint(0);
        }
        function doPrint(i) {
            if (i >= printlist.length)
                return;

            var data = printlist[i].split(",");
            this.focus();
            $("#btnPrintSingle").trigger("click", [data[0], data[1], data[2]]);

            i++;
            window.setTimeout("doPrint(" + i + ")", 1000);
        }

        function goPrintTemp(tempId, djh, sylx){
            try {
                var modalName = "syxx.fr3";
                if (sylx == "1") {
                    modalName = "syxxTd.fr3";
                } else if (sylx == "2") {
                    modalName = "syxxFc.fr3";
                }

                var modalUrl = getURL()+"${base}/static/print/" + modalName;
                var dataUrl = getURL()+"${base}/ts/printSyxxTemp?djh="+djh+"&tempId="+tempId;

                printSheet(modalUrl, dataUrl, false);
            } catch (ex) {
            }
            return false;
        };
</script>

    <#assign jsContent>
        <@com.script name="static/thirdparty/ace/js/ace-extra.min.js"></@com.script>
        <@com.script name="static/thirdparty/ace/js/ace-elements.min.js"></@com.script>
        <@com.script name="static/thirdparty/ace/js/ace.min.js"></@com.script>


    </#assign>
</@com.html>