<#assign jsContent>

    <@com.script name="static/js/tax/grid.js"></@com.script>
    <@com.script name="static/js/public.js"></@com.script>
    <@com.script name="static/js/tax/swDjSy-save-validate.js"></@com.script>
    <@com.script name="static/thirdparty/bootstrap/js/bootstrap-typeahead.min.js"></@com.script>


</#assign>
<#assign cssContent>
    <@com.style name="static/css/pageForm.css"></@com.style>
    <@com.style name="static/thirdparty/ace/css/font-awesome.min.css"></@com.style>
    <@com.style name="static/thirdparty/ace/css/ace-fonts.css"></@com.style>
    <@com.style name="static/thirdparty/ace/css/ace.min.css"></@com.style>
    <@com.style name="static/thirdparty/ace/css/ace-skins.min.css"></@com.style>
    <@com.style name="static/thirdparty/ace/css/ace-rtl.min.css"></@com.style>

</#assign>
<@com.html title="数据处理" import="jquery,jqgrid,bootstrap,bootbox,datetimepicker" js=jsContent css=cssContent >
<div class="main-container" id="main-container">
    <script type="text/javascript">
        try {
            ace.settings.check('main-container', 'fixed')
        } catch (e) {
        }
    </script>
    <div class="page-content no-padding-bottom">
    <div class="row">
        <div class="widget-box transparent">
            <div class="widget-body">
                <div class="widget-main">
                    <div class="row">
                        <div class="col-sm-12 " id="searchPanel" style="color:#888;">
                            <form id="advancedQueryForm">
                                <div class="col-xs-9 no-padding-left">
                                    <button class="btn btn-info btn-sm" id="updateZdData" type="button" sqlfile="/static/sql/更新宗地数据.sql">
                                        <i class="ace-icon fa fa-eye bigger-110"></i>
                                        更新宗地数据
                                    </button>
                                    <button class="btn btn-info btn-sm" id="updateZgData" type="button" sqlfile="/static/sql/更新税务数据.sql">
                                        <i class="ace-icon fa fa-eye bigger-110"></i>
                                        更新税务数据
                                    </button>
                                    <button class="btn btn-info btn-sm" id="initZgData" type="button" sqlfile="/static/sql/自动挂接处理.sql">
                                        <i class="ace-icon fa fa-eye bigger-110"></i>
                                        分析税务数据（自动挂接）
                                    </button>
                                </div>
                                <div class="col-xs-3 no-padding-left" >
                                    <button class="btn btn-danger btn-sm pull-right" id="clearInfo" type="button">
                                        <i class="ace-icon glyphicon glyphicon-remove bigger-110"></i>
                                        清空信息
                                    </button>
                                </div>
                            </form>
                        </div>
                    </div>
                    <p></p>
                    <row>
                        <div class="col-xs-12 no-padding-left">
                            <div style="height: '100%';overflow-y:auto;overflow-x:auto">
                                <textarea id="info" name="info" wrap="virtual" readonly="true" style="height: 500px; width: 100%">日志信息：</textarea>
                            </div>
                        </div>
                    </row>
                </div>
            </div>
        </div>
    </div>

    </div>
  </div>
<script>
    $(function(){
        bootbox.setDefaults({
            locale: "zh_CN"
        });

        var isExuceting = false;

        $('#clearInfo').on('click', function () {
            $('#info')[0].textContent = '日志信息：';
        });

        $('button').each(function(){
            var sqlfile = $(this).attr('sqlfile');
            if(sqlfile != null && sqlfile != ''){
                $(this).on('click', function () {
                    if (isExuceting) {
                        bootbox.alert('正在执行中，请稍后继续！');
                        return;
                    }

                    $('#info')[0].textContent += '\n------------------------------------';
                    $('#info')[0].textContent += '\n';
                    $('#info')[0].textContent += (new Date()).Format('yyyy-MM-dd hh:mm:ss') + '：';
                    $('#info')[0].textContent += '开始执行……';

                    var filePath = $(this).attr("sqlfile");
                    doExcuteSqlFile(filePath, 0);
                });
            }
        });

        // 执行sql脚本
        function doExcuteSqlFile(filePath, pos) {
            if (pos == null)
                pos = 0;

            isExuceting = true;
            $.ajax({
                type: 'post',
                url: "${base}/sjgj/excuteSqlFile",
                data:{filePath: filePath, pos:pos},
                dataType: 'json',
                success: function (data) {
                    if (data.msg != null && data.msg != '' && data.msg != 'null') {
                        $('#info')[0].textContent += '\n';
                        $('#info')[0].textContent += (new Date()).Format('yyyy-MM-dd hh:mm:ss') + '：';
                        $('#info')[0].textContent += data.msg;
                    }

                    if (data.bool) {
                        doExcuteSqlFile(filePath, data.tag);
                    } else {
                        isExuceting = false;

                        $('#info')[0].textContent += '\n';
                        $('#info')[0].textContent += (new Date()).Format('yyyy-MM-dd hh:mm:ss') + '：';
                        $('#info')[0].textContent += '执行结束！';
                        $('#info')[0].textContent += '\n------------------------------------';
                    }
                }
            });
        }
    })

</script>

    <#assign jsContent>
        <@com.script name="static/thirdparty/ace/js/ace-extra.min.js"></@com.script>
        <@com.script name="static/thirdparty/ace/js/ace-elements.min.js"></@com.script>
        <@com.script name="static/thirdparty/ace/js/ace.min.js"></@com.script>

    </#assign>
</@com.html>