/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.landtax.web.hcxm;

import cn.gtmap.landtax.entity.TjBaseParamVo;
import cn.gtmap.landtax.model.dictionary.Hcxmlx;
import cn.gtmap.landtax.model.dictionary.ResponseMessage;
import cn.gtmap.landtax.print.PrintGridExcelUtil;
import cn.gtmap.landtax.service.HcxmService;
import cn.gtmap.landtax.service.TjService;
import cn.gtmap.landtax.service.WorkFlowService;
import cn.gtmap.landtax.support.jpa.BaseRepository;
import cn.gtmap.landtax.util.CommonUtil;
import cn.gtmap.landtax.util.QueryCondition;
import com.alibaba.fastjson.JSONObject;
import com.gtis.plat.service.SysUserService;
import com.gtis.plat.vo.PfUserVo;
import com.gtis.plat.vo.UserInfo;
import com.gtis.plat.wf.model.PerformerTaskModel;
import com.gtis.web.SessionUtil;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.persistence.Query;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.hibernate.SQLQuery;
import org.hibernate.transform.ResultTransformer;
import org.hibernate.transform.Transformers;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/hcxm"})
public class HcxmController {
    @Autowired
    TjService tjService;
    @Autowired
    WorkFlowService workFlowService;
    @Autowired
    SysUserService sysUserService;
    @Autowired
    HcxmService hcxmService;
    @Autowired
    BaseRepository baseRepository;

    @RequestMapping(value={""})
    public String hcxm(Model model, String hcxmlx, String customParams, String forbiddenList, String isBl) {
        model.addAttribute("hcxmlx", (Object)hcxmlx);
        String tag = this.getTag(hcxmlx);
        if (StringUtils.isNotEmpty((String)forbiddenList)) {
            tag = tag + "Forbidden";
            model.addAttribute("forbiddenList", (Object)true);
        } else {
            model.addAttribute("forbiddenList", (Object)false);
        }
        model.addAttribute("tag", (Object)tag);
        model.addAttribute("customParams", (Object)customParams);
        TjBaseParamVo tjBaseParamVo = this.tjService.getTjBaseParam(tag);
        if (tjBaseParamVo != null) {
            model.addAttribute("colJson", (Object)tjBaseParamVo.getColJson());
            model.addAttribute("headPageFile", (Object)tjBaseParamVo.getHeadPageFile());
            model.addAttribute("reportName", (Object)tjBaseParamVo.getReportName());
            if (StringUtils.isNotBlank((String)tjBaseParamVo.getExcelTemplate()) && StringUtils.isNotBlank((String)tjBaseParamVo.getExcelXml()) && StringUtils.isNotBlank((String)tjBaseParamVo.getExportFieldList())) {
                model.addAttribute("needExport", (Object)"true");
            }
            if (tjBaseParamVo.isNeedExport()) {
                model.addAttribute("autoExport", (Object)"true");
            }
        }
        model.addAttribute("isBl", (Object)isBl);
        return "landtax/hcxm/baseHcxmTz";
    }

    @RequestMapping(value={"forbiddenCreateHcxm"})
    @ResponseBody
    public Object forbiddenCreateHcxm(Model model, String hcxmlx, String ids, String bz) {
        ResponseMessage responseMessage = new ResponseMessage();
        try {
            String[] idArray = ids.split(",");
            List<String> idList = Arrays.asList(idArray);
            this.hcxmService.signForbiddenCreateHcxm(hcxmlx, idList, bz);
        }
        catch (Exception e) {
            responseMessage.setMsg(e.getMessage());
        }
        return responseMessage;
    }

    @RequestMapping(value={"needCreateHcxm"})
    @ResponseBody
    public Object needCreateHcxm(Model model, String hcxmlx, String ids) {
        ResponseMessage responseMessage = new ResponseMessage();
        try {
            String[] idArray = ids.split(",");
            List<String> idList = Arrays.asList(idArray);
            this.hcxmService.signNeedCreateHcxm(hcxmlx, idList);
        }
        catch (Exception e) {
            responseMessage.setMsg(e.getMessage());
        }
        return responseMessage;
    }

    @RequestMapping(value={"createSelHcxm"})
    @ResponseBody
    public Object createSelHcxm(Model model, String hcxmlx, String tag, String ids, String fjdm) {
        TjBaseParamVo tjBaseParamVo;
        ResponseMessage responseMessage = new ResponseMessage();
        if (StringUtils.isEmpty((String)tag)) {
            tag = this.getTag(hcxmlx);
        }
        if ((tjBaseParamVo = this.tjService.getTjBaseParam(tag)) == null) {
            return null;
        }
        ArrayList<QueryCondition> queryConditionList = new ArrayList<QueryCondition>();
        ids = ids.replaceAll(",", "','");
        queryConditionList.add(new QueryCondition(" rwbm in ('" + ids + "')"));
        List list = this.tjService.getTjList(tag, queryConditionList);
        if (fjdm != null && !fjdm.equals("32038103")) {
            fjdm = null;
        }
        String msg = this.createAndTurnWf(hcxmlx, list, fjdm);
        responseMessage.setMsg(msg);
        return responseMessage;
    }

    @RequestMapping(value={"createAllHcxm"})
    @ResponseBody
    public Object createAllHcxm(Model model, String hcxmlx, String tag, String query, String customParams, String fjdm, String mjyz) {
        TjBaseParamVo tjBaseParamVo;
        ResponseMessage responseMessage = new ResponseMessage();
        if (StringUtils.isEmpty((String)tag)) {
            tag = this.getTag(hcxmlx);
        }
        if ((tjBaseParamVo = this.tjService.getTjBaseParam(tag)) == null) {
            return null;
        }
        List queryConditionList = CommonUtil.initQueryCondition((String)query);
        queryConditionList = this.addCustomParams(queryConditionList, customParams);
        if (hcxmlx.equals(Hcxmlx.ZDHC.toString())) {
            queryConditionList.add(new QueryCondition("MJHJ_GT", ">=", (Object)mjyz));
        } else if (hcxmlx.equals(Hcxmlx.SYHC.toString())) {
            queryConditionList.add(new QueryCondition("MJHJ_SW", ">=", (Object)mjyz));
        } else if (hcxmlx.equals(Hcxmlx.MJBYZHC.toString())) {
            queryConditionList.add(new QueryCondition("MJCZ", ">=", (Object)mjyz));
        }
        List list = this.tjService.getTjList(tag, queryConditionList);
        if (fjdm != null && !fjdm.equals("32038103")) {
            fjdm = null;
        }
        String msg = this.createAndTurnWf(hcxmlx, list, fjdm);
        responseMessage.setMsg(msg);
        return responseMessage;
    }

    @RequestMapping(value={"hcjd"})
    public String hcjd(Model model, String hcxmlx) {
        model.addAttribute("hcxmlx", (Object)hcxmlx);
        return "landtax/hcxm/hcjd";
    }

    @RequestMapping(value={"hcjdRootJson"})
    @ResponseBody
    public Object hcjdRootJson(Model model, String hcxmlx, String id) {
        Object obj = this.hcxmService.hcjdRootJson(hcxmlx, id);
        return obj;
    }

    @RequestMapping(value={"getTipMsg"})
    @ResponseBody
    public Object getTipMsg(Model model, String hcxmlx, String tag, String query, String customParams) {
        Query querylist;
        List queryConditionList = CommonUtil.initQueryCondition((String)query);
        queryConditionList = this.addCustomParams(queryConditionList, customParams);
        if (StringUtils.isEmpty((String)tag)) {
            tag = this.getTag(hcxmlx);
        }
        String sql = this.tjService.getTjSql(tag);
        String msg = "";
        String resultExpression = "";
        if (hcxmlx.equals(Hcxmlx.ZDHC.toString())) {
            resultExpression = "NVL(SUM(MJHJ_GT),0) AS MJHJ_GT";
            querylist = this.tjService.createQuery(sql, resultExpression, queryConditionList, null, false);
            ((SQLQuery)querylist.unwrap(SQLQuery.class)).setResultTransformer((ResultTransformer)Transformers.ALIAS_TO_ENTITY_MAP);
            List list = querylist.getResultList();
            if (CollectionUtils.isNotEmpty((Collection)list)) {
                msg = "\u56fd\u571f\u53d1\u8bc1\u9762\u79ef\u5408\u8ba1\uff1a" + this.formatString("#,##0.00", ((HashMap)list.get(0)).get("MJHJ_GT").toString()) + "\u5e73\u65b9\u7c73";
            }
        } else if (hcxmlx.equals(Hcxmlx.SYHC.toString())) {
            resultExpression = "NVL(SUM(MJHJ_SW),0) AS MJHJ_SW";
            querylist = this.tjService.createQuery(sql, resultExpression, queryConditionList, null, false);
            ((SQLQuery)querylist.unwrap(SQLQuery.class)).setResultTransformer((ResultTransformer)Transformers.ALIAS_TO_ENTITY_MAP);
            List list = querylist.getResultList();
            if (CollectionUtils.isNotEmpty((Collection)list)) {
                msg = "\u571f\u5730\u7a0e\u9762\u79ef\u5408\u8ba1\uff1a" + this.formatString("#,##0.00", ((HashMap)list.get(0)).get("MJHJ_SW").toString()) + "\u5e73\u65b9\u7c73";
            }
        } else if (hcxmlx.equals(Hcxmlx.MJBYZHC.toString())) {
            resultExpression = "NVL(SUM(MJHJ_GT),0) AS MJHJ_GT, NVL(SUM(MJHJ_SW),0) AS MJHJ_SW, NVL(SUM(MJCZ),0) AS MJCZ";
            querylist = this.tjService.createQuery(sql, resultExpression, queryConditionList, null, false);
            ((SQLQuery)querylist.unwrap(SQLQuery.class)).setResultTransformer((ResultTransformer)Transformers.ALIAS_TO_ENTITY_MAP);
            List list = querylist.getResultList();
            if (CollectionUtils.isNotEmpty((Collection)list)) {
                msg = "\u7a0e\u52a1\u9762\u79ef\u5408\u8ba1\uff1a" + this.formatString("#,##0.00", ((HashMap)list.get(0)).get("MJHJ_SW").toString()) + "\u5e73\u65b9\u7c73\uff0c" + "\u56fd\u571f\u53d1\u8bc1\u9762\u79ef\u5408\u8ba1\uff1a" + this.formatString("#,##0.00", ((HashMap)list.get(0)).get("MJHJ_GT").toString()) + "\u5e73\u65b9\u7c73\uff0c" + "\u9762\u79ef\u5dee\u503c\u5408\u8ba1\uff1a" + this.formatString("#,##0.00", ((HashMap)list.get(0)).get("MJCZ").toString()) + "\u5e73\u65b9\u7c73";
            }
        }
        ResponseMessage responseMessage = new ResponseMessage();
        responseMessage.setMsg(msg);
        return responseMessage;
    }

    private String createAndTurnWf(String hcxmlx, List<HashMap> list, String fjdm) {
        String resultStr = null;
        int countSuccess = 0;
        List toUserList = null;
        String rwIdField = "RWBM";
        String reginCodeField = "FJDM";
        String rwId = "";
        String wiid = "";
        String toUserId = "";
        for (HashMap hashMap : list) {
            String string = rwId = hashMap.get(rwIdField) == null ? "" : hashMap.get(rwIdField).toString();
            if (this.hcxmService.getCurSwHcXmRwRelByRwid(rwId) != null) continue;
            wiid = this.workFlowService.wfCreate(hcxmlx, rwId, true);
            if (toUserList == null) {
                PerformerTaskModel result = null;
                try {
                    result = this.workFlowService.getTurnUserList(SessionUtil.getCurrentUserId(), wiid);
                    toUserList = result.getUserList();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (!wiid.startsWith("java.lang:")) {
                if (StringUtils.isEmpty((String)fjdm)) {
                    fjdm = hashMap.get(reginCodeField) == null ? "" : hashMap.get(reginCodeField).toString();
                }
                for (PfUserVo pfUserVo : toUserList) {
                    String regionCode = this.sysUserService.getRegionCodeByUserId(pfUserVo.getUserId());
                    if (regionCode.length() > 8) {
                        regionCode = regionCode.substring(0, 8);
                    }
                    if (!regionCode.startsWith(fjdm)) continue;
                    toUserId = pfUserVo.getUserId();
                    break;
                }
                this.workFlowService.autoTurnWorkflow(wiid, toUserId);
                ++countSuccess;
                continue;
            }
            resultStr = wiid;
            break;
        }
        if (resultStr == null) {
            resultStr = String.valueOf(countSuccess);
        }
        return resultStr;
    }

    private String getTag(String hcxmlx) {
        String tag = "";
        if (hcxmlx.equals(Hcxmlx.ZDHC.toString())) {
            tag = "zdhc";
        } else if (hcxmlx.equals(Hcxmlx.SYHC.toString())) {
            tag = "syhc";
        } else if (hcxmlx.equals(Hcxmlx.MJBYZHC.toString())) {
            tag = "zdsymjdfTj";
        }
        return tag;
    }

    private List<QueryCondition> addCustomParams(List<QueryCondition> queryConditionList, String customParams) {
        if (queryConditionList == null) {
            queryConditionList = new ArrayList<QueryCondition>();
        }
        if (StringUtils.isNotBlank((String)customParams)) {
            List customQueryConditionList = CommonUtil.initQueryCondition((String)customParams);
            for (int i = 0; i < customQueryConditionList.size(); ++i) {
                queryConditionList.add((QueryCondition)customQueryConditionList.get(i));
            }
        }
        return queryConditionList;
    }

    private String formatString(String formatExpression, String value) {
        DecimalFormat decimalFormat = new DecimalFormat(formatExpression);
        String formatResult = value;
        try {
            formatResult = decimalFormat.format(Double.valueOf(value));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return formatResult;
    }

    @RequestMapping(value={"getTaskUrl"})
    @ResponseBody
    public Object getTaskUrl(Model model, String proid) {
        UserInfo user = SessionUtil.getCurrentUser();
        String userId = user.getId();
        String sql = "";
        Query query = null;
        sql = "SELECT USER_ID, ASSIGNMENT_ID, BEGIN_TIME, BJ,        RANK() OVER(PARTITION BY USER_ID ORDER BY BEGIN_TIME DESC) AS YHPM,        RANK() OVER(ORDER BY BEGIN_TIME DESC) AS JDPM FROM (       SELECT USER_ID, ACTIVITY_ID, BEGIN_TIME, ASSIGNMENT_ID, 0 AS BJ       FROM PF_ASSIGNMENT       UNION       SELECT USER_ID, ACTIVITY_ID, BEGIN_TIME, ASSIGNMENT_ID, 1 AS BJ       FROM PF_ASSIGNMENTHISTORY      ) t\nWHERE t.ACTIVITY_ID IN (       SELECT ACTIVITY_ID       FROM PF_ACTIVITY       WHERE WORKFLOW_INSTANCE_ID='" + proid + "' " + "      ) ";
        sql = "SELECT * FROM (" + sql + ") WHERE USER_ID='" + userId + "' AND YHPM=1 AND ROWNUM=1 ";
        query = this.baseRepository.getEntityManager().createNativeQuery(sql);
        ((SQLQuery)query.unwrap(SQLQuery.class)).setResultTransformer((ResultTransformer)Transformers.ALIAS_TO_ENTITY_MAP);
        List list = query.getResultList();
        String url = "";
        String taskid = "";
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            taskid = ((HashMap)list.get(0)).get("ASSIGNMENT_ID").toString();
            String jdpm = ((HashMap)list.get(0)).get("JDPM").toString();
            String bj = ((HashMap)list.get(0)).get("BJ").toString();
            url = jdpm.equals("1") && bj.equals("0") ? "taskhandle.action?taskid=" + taskid : "taskoverhandle.action?taskid=" + taskid;
        } else {
            url = "";
        }
        ResponseMessage responseMessage = new ResponseMessage();
        responseMessage.setMsg(url);
        return responseMessage;
    }

    @RequestMapping(value={"wclYclTz"})
    public String wclTz(Model model, String hcxmlx, String xzqdm, String xflx, String cllx) {
        model.addAttribute("hcxmlx", (Object)hcxmlx);
        model.addAttribute("xzqdm", (Object)xzqdm);
        model.addAttribute("cllx", (Object)cllx);
        model.addAttribute("xflx", (Object)xflx);
        String name = Hcxmlx.getMcByDm((String)hcxmlx);
        if (StringUtils.isNotBlank((String)cllx) && "1".equals(cllx)) {
            name = name + "\u672a\u5904\u7406\u4efb\u52a1\u8be6\u60c5";
        } else if (StringUtils.isNotBlank((String)cllx) && "2".equals(cllx)) {
            name = name + "\u5df2\u5904\u7406\u4efb\u52a1\u8be6\u60c5";
        }
        model.addAttribute("reportName", (Object)name);
        return "landtax/hcxm/wclYclTz";
    }

    @RequestMapping(value={"wclYclTzJson"})
    @ResponseBody
    public Object wclYclTzJson(Model model, Pageable pageable, String hcxmlx, String xzqdm, String xflx, String cllx, String query) {
        List queryConditionList = CommonUtil.initQueryCondition((String)query);
        return this.hcxmService.getWclYclTzJson(pageable, hcxmlx, xzqdm, xflx, cllx, queryConditionList);
    }

    @RequestMapping(value={"exportExcelTjEx"})
    public String exportExcelTjEx(HttpServletRequest request, String hcxmlx, String xzqdm, String xflx, String cllx, String query, String gridOptions) {
        try {
            List queryConditionList = CommonUtil.initQueryCondition((String)query);
            List list = this.hcxmService.getWclYclTzList(hcxmlx, xzqdm, xflx, cllx, queryConditionList);
            String name = Hcxmlx.getMcByDm((String)hcxmlx);
            if (StringUtils.isNotBlank((String)cllx) && "1".equals(cllx)) {
                name = name + "\u672a\u5904\u7406\u4efb\u52a1\u8be6\u60c5";
            } else if (StringUtils.isNotBlank((String)cllx) && "2".equals(cllx)) {
                name = name + "\u5df2\u5904\u7406\u4efb\u52a1\u8be6\u60c5";
            }
            new JSONObject();
            JSONObject jsonObject = JSONObject.parseObject((String)gridOptions);
            PrintGridExcelUtil printGridExcel = new PrintGridExcelUtil();
            printGridExcel.setTitle(name);
            printGridExcel.setGridOptions(jsonObject);
            printGridExcel.printGridExcel(request, list);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "common/downExcel";
    }
}

